package jp.groupsession.v2.rng.restapi.templates.steps.users.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.biz.UserGroupSelectBiz;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnBelongmDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroDao;
import jp.groupsession.v2.rng.dao.RngTemplateKeiroUserDao;
import jp.groupsession.v2.rng.model.RngTemplateKeiroModel;
import jp.groupsession.v2.rng.model.RngTemplateKeiroUserModel;
import jp.groupsession.v2.rng.rng110keiro.EnumKeiroKbn;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 経路に選択できるユーザを一覧取得する ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class RngTemplatesStepsUsersQueryGetBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngTemplatesStepsUsersQueryGetBiz.class);

    /** リクエストパラメータ */
    private RngTemplatesStepsUsersQueryGetParamModel param__;
    /** 実行結果*/
    private List<RngTemplatesStepsUsersQueryResultModel> result__ = new ArrayList<>();
    /** 最大件数 */
    private int maxCnt__;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     */
    public RngTemplatesStepsUsersQueryGetBiz(
        RngTemplatesStepsUsersQueryGetParamModel param,
        RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     *
     * <br>[機  能] 経路に選択できるユーザを一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        log__.info("経路に選択できるユーザを一覧取得するAPI execute");

        //経路情報を取得する
        RngTemplateKeiroDao rtkDao = new RngTemplateKeiroDao(con__);
        RngTemplateKeiroModel rtkMdl = rtkDao.select(param__.getStepSid());

        //ユーザ選択経路の場合、経路に選択できるユーザを一覧取得
        if (rtkMdl.getRtkType() == EnumKeiroKbn.USERSEL_VAL) {

            //経路に選択できるユーザ一覧のユーザSIDリストを取得
            List<Integer> usrSidList = __getUsrSidList(rtkMdl);

            //グループIDが指定されている場合、指定したグループに所属するユーザのみに絞り込む
            if (param__.getGroupId() != null) {
                CmnGroupmDao cgmDao = new CmnGroupmDao(con__);
                CmnGroupmModel grpMdl = cgmDao.getGroupInf(param__.getGroupId());
                int grpSid = -1;
                if (grpMdl != null) {
                    grpSid = grpMdl.getGrpSid();
                }
                CmnBelongmDao cbmDao = new CmnBelongmDao(con__);
                List<Integer> belongUidList = cbmDao.selectBelongLiveUserSid(grpSid);
                usrSidList = usrSidList.stream()
                                .filter(sid -> belongUidList.contains(sid))
                                .collect(Collectors.toList());
            }

            //取得したユーザの件数を取得
            CmnUsrmDao cumDao = new CmnUsrmDao(con__);
            maxCnt__ = cumDao.getCountActiveUser(usrSidList);

            //「OFFSET < 件数」の場合、LIMIT/OFFSETを元に取得したユーザの詳細情報を取得
            if (param__.getOffset() < maxCnt__) {
                UserSearchDao usDao = new UserSearchDao(con__);
                List<CmnUserModel> usrList
                    = usDao.getUsersDataList(
                        usrSidList,
                        true,
                        param__.getLimit(),
                        param__.getOffset());

                //結果モデルにセット
                for (CmnUserModel usrMdl : usrList) {
                    RngTemplatesStepsUsersQueryResultModel resultMdl
                        = new RngTemplatesStepsUsersQueryResultModel();
                    resultMdl.setUserId(usrMdl.getUsrLgid());
                    resultMdl.setUserName(usrMdl.getUsiName());
                    resultMdl.setLoginStopFlg(usrMdl.getUsrUkoFlg());
                    if (usrMdl.getUsrJkbn() == GSConst.JTKBN_TOROKU) {
                        resultMdl.setUserDeleteFlg(0);
                    } else {
                        resultMdl.setUserDeleteFlg(1);
                    }
                    result__.add(resultMdl);
                }
            }
        }
    }

    /**
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngTemplatesStepsUsersQueryResultModel> getResult() {
        return result__;
    }

    /**
     * <br>[機  能] 最大件数の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 最大件数
     * @throws SQLException
     */
    public int getMaxCount() throws SQLException {
        return maxCnt__;
    }

    /**
     * <br>[機  能] 経路に選択できるユーザ一覧のユーザSIDリストを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return 最大件数
     * @param rtkMdl 経路情報
     * @throws SQLException
     */
    private List<Integer> __getUsrSidList(
        RngTemplateKeiroModel rtkMdl) throws SQLException {

        RngBiz rngBiz = new RngBiz(con__);
        List<Integer> usrSidList = new ArrayList<Integer>();

        //経路の選択対象を取得
        RngTemplateKeiroUserDao rkuDao = new RngTemplateKeiroUserDao(con__);
        List<RngTemplateKeiroUserModel> rkuMdlList = rkuDao.select(rtkMdl.getRtkSid());

        if (rkuMdlList == null || rkuMdlList.isEmpty()) {
            //経路の選択対象が指定されていない場合、全ユーザ一覧を取得
            CmnUsrmDao cumDao = new CmnUsrmDao(con__);
            usrSidList.addAll(cumDao.getUsrAll().stream()
                                        .filter(mdl -> mdl.getUsrJkbn() == GSConst.JTKBN_TOROKU
                                            && mdl.getUsrSid() > GSConstUser.USER_RESERV_SID)
                                        .map(mdl -> mdl.getUsrSid())
                                        .collect(Collectors.toList()));

        } else {
            //経路の選択対象が指定されている場合、選択対象グループ/ユーザを取得
            List<String> selectable = new ArrayList<String>();
            for (RngTemplateKeiroUserModel rkuMdl : rkuMdlList) {
                if (rkuMdl.getUsrSid() > GSConstUser.USER_RESERV_SID) {
                    selectable.add(String.valueOf(rkuMdl.getUsrSid()));
                } else if (rkuMdl.getGrpSid() > -1) {
                    selectable.add(
                        UserGroupSelectBiz.GROUP_PREFIX
                        + String.valueOf(rkuMdl.getGrpSid()));
                }
            }

            //選択対象から選択不可グループ/ユーザを除外したリストを生成
            List<Integer> grpSidList = new ArrayList<Integer>();
            rngBiz.createSelectableForUserSel(
                selectable.toArray(String[]::new),
                grpSidList,
                usrSidList,
                rtkMdl.getRtkOwnsingi(),
                ctx__.getRequestModel());

            //選択対象グループが存在する場合、グループに所属するユーザ一覧を取得
            if (grpSidList != null && !grpSidList.isEmpty()) {
                CmnBelongmDao cbmDao = new CmnBelongmDao(con__);
                for (int grpSid : grpSidList) {
                    usrSidList.addAll(cbmDao.selectBelongLiveUserSid(grpSid));
                }
            }
        }

        //選択不可ユーザを除外
        List<Integer> jogaiUsrSidList
            = rngBiz.getJogaiUser(rtkMdl.getRtkOwnsingi(), ctx__.getRequestUserSid());
        usrSidList = usrSidList.stream()
                        .filter(s -> !jogaiUsrSidList.contains(s))
                        .collect(Collectors.toList());

        return usrSidList;
    }
}
