package jp.groupsession.v2.rng.restapi.templates.steps.users.query;

import java.sql.Connection;
import java.sql.SQLException;

import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.MaxValue;
import jp.groupsession.v2.restapi.parameter.annotation.MinValue;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngFormBuildBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 経路に選択できるユーザを一覧取得する パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
@ParamModel
public class RngTemplatesStepsUsersQueryGetParamModel {

    //パスパラメータ
    /** 稟議テンプレートSID */
    @NotBlank
    private int templateSid__ = 0;
    /** 稟議テンプレート経路SID */
    @NotBlank
    private int stepSid__ = 0;

    //クエリパラメータ
    /** グループID */
    private String groupId__ = null;
    /** 取得件数 */
    @MinValue(1)
    @MaxValue(100)
    private int limit__ = 50;
    /** 取得開始位置 */
    @MinValue(0)
    private int offset__ = 0;

    /**
     * @return the templateSid
     */
    public int getTemplateSid() {
        return templateSid__;
    }
    /**
     * @param templateSid the templateSid to set
     */
    public void setTemplateSid(int templateSid) {
        templateSid__ = templateSid;
    }
    /**
     * @return the stepSid
     */
    public int getStepSid() {
        return stepSid__;
    }
    /**
     * @param stepSid the stepSid to set
     */
    public void setStepSid(int stepSid) {
        stepSid__ = stepSid;
    }
    /**
     * @return the groupId
     */
    public String getGroupId() {
        return groupId__;
    }
    /**
     * @param groupId the groupId to set
     */
    public void setGroupId(String groupId) {
        groupId__ = groupId;
    }
    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }
    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }
    /**
     * @return the offset
     */
    public int getOffset() {
        return offset__;
    }
    /**
     * @param offset the offset to set
     */
    public void setOffset(int offset) {
        offset__ = offset;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @throws SQLException
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        RequestModel reqMdl = ctx.getRequestModel();
        Connection con = ctx.getCon();

        //稟議テンプレートSIDに0以下を指定した場合、エラー
        if (templateSid__ <= 0) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.92")
            );
        }

        //稟議テンプレート情報取得
        RngFormBuildBiz formBiz = new RngFormBuildBiz(reqMdl);
        RngTemplateModel rtpMdl = null;
        try {
            rtpMdl = formBiz.getRtpModelMaxVer(con, templateSid__);
        } catch (RtpNotfoundException e) {
            //稟議テンプレートが存在しない場合、エラー
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.92")
            );
        }

        //稟議テンプレートへのアクセス権限がない場合、エラー
        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        if (!rtpBiz.isUseableTemplate(rtpMdl, reqMdl, con)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.92")
            );
        }

        //経路と稟議テンプレートが紐づいていない場合、エラー
        if (!rtpBiz.isRelatedToKeiro(rtpMdl, stepSid__, con)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_TEMPLATE_KEIRO,
                    "search.data.notfound",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.24")
            );
        }
    }
}
