package jp.groupsession.v2.rng.restapi.users.entities;

import java.sql.SQLException;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Get;
import jp.groupsession.v2.restapi.controller.annotation.Parameter;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;

/**
 * <br>[機  能] 稟議 稟議詳細情報取得API アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngUsersEntitiesAction extends AbstractRestApiAction {

    /** ロギングクラス */
    private static Log log__ = LogFactory.getLog(RngUsersEntitiesAction.class);

    /**
     * <br>[機  能] GETメソッド
     * <br>[解  説] 稟議RestAPI「稟議詳細情報を取得する」
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPath GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Get
    public void doGet(
            HttpServletResponse res,
            RngUsersEntitiesGetParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPath)
        throws SQLException, RtpNotfoundException, IOToolsException {

        log__.info("稟議 稟議詳細情報取得RESTAPIの開始");
        RngUsersEntitiesGetBiz biz = new RngUsersEntitiesGetBiz(ctx);
        biz.execute(param, tempPath);
        log__.info("稟議 稟議詳細情報取得完了");

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();
        log__.info("稟議 稟議詳細情報取得RESTAPIのレスポンス完了");
    }


    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(承認)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "syonin")
    public void doPostSyonin(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RESTAPI 「稟議にアクションする（承認）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RESTAPI 「稟議にアクションする（承認）」の終了");
    }

    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(否認)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "hinin")
    public void doPostHinin(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RESTAPI 「稟議にアクションする（否認）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RESTAPI 「稟議にアクションする（否認）」の終了");

    }

    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(確認)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "kakunin")
    public void doPostKakunin(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（確認）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（確認）」の終了");

    }

    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(完了)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "kanryo")
    public void doPostKanryo(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（完了）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（完了）」の終了");

    }

    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(後閲)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "koetu")
    public void doPostKoetu(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（後閲）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（後閲）」の終了");

    }


    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(差し戻し)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "sasimodosi")
    public void doPostSasimodosi(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（差し戻し）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（差し戻し）」の終了");

    }


    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議にアクションする」(取り下げ)
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    @Parameter(name = "action", value = "torisage")
    public void doPostTorisage(
            HttpServletResponse res,
            RngUsersEntitiesPostParamModel param,
            RestApiContext ctx,
            GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（取り下げ）」の開始");

        //テンポラリディレクトリチェック（アップロードされていなければ作成する）
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        RngUsersEntitiesPostBiz biz = new RngUsersEntitiesPostBiz(ctx);
        biz.executeShingi(param, tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
        .addResult(biz.getResult())
        .build().execute();

        log__.info("稟議RestAPIRestAPI 「稟議にアクションする（取り下げ）」の終了");

    }
}
