package jp.groupsession.v2.rng.restapi.users.entities;

import java.sql.Connection;
import java.sql.SQLException;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;

/**
 * <br>[機  能] 稟議 稟議詳細情報取得API ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 */
public class RngUsersEntitiesGetBiz {

    /** 実行結果*/
    private RngRestapiRingiModel result__ = null;
    /** コンテキスト */
    private final RestApiContext ctx__;
    /** コネクション */
    private final Connection con__;

    /**
     *
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiConst
     */
    public RngUsersEntitiesGetBiz(RestApiContext ctx) {
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     *
     * <br>[機  能] 稟議詳細情報の取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl リクエストパラメータ情報
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public void execute(RngUsersEntitiesGetParamModel paramMdl, GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException {

        //指定された稟議アカウントに対応するユーザSIDを取得
        CmnUsrmDao usrDao = new CmnUsrmDao(con__);
        int usrSid = usrDao.select(paramMdl.getUserId()).getUsrSid();

        //テンポラリディレクトリ作成
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        result__ = rngApiBiz.getRingiDetailModel(ctx__,
                                                paramMdl.getRingiSid(),
                                                usrSid,
                                                tempPathModel);
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public RngRestapiRingiModel getResult() {
        return result__;
    }
}
