package jp.groupsession.v2.rng.restapi.users.entities;

import java.sql.SQLException;

import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 稟議 稟議詳細情報取得用モデル
 * <br>[解  説]
 * <br>[備  考]
 */
@ParamModel
public class RngUsersEntitiesGetParamModel {

    /** ユーザID */
    @NotBlank
    private String userId__ = null;
    /** 稟議SID */
    @NotBlank
    private int ringiSid__ = 0;

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }
    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        //ユーザIDに自分自身 or 代理人が指定されているかをチェック
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx.getCon());
        int viewUserSid = usrDao.selectLoginId(userId__);

        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        if (viewUserSid <= GSConstUser.USER_RESERV_SID
            || !rng030Biz.chkViewAccount(viewUserSid)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_ACCOUNT,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.account")
            );
        }

        //草稿は本APIの取得対象外
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);
        if (rngDataMdl != null
            && rngDataMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT
            && rngDataMdl.getRngAuid() == ctx.getRequestUserModel().getUsrsid()) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_DIF_TYPE_RINGI,
                    "errors.free.msg",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("restapi.ringi.diftypes.draft")
            );
        }

        //指定した稟議を参照可能かをチェック (草稿は参照不可)
        if (rngDataMdl == null || !rng030Biz.chkViewRingi(viewUserSid, ringiSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }
    }
}
