package jp.groupsession.v2.rng.restapi.users.entities;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.man.GSConstMain;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.apiconnect.RngApiThreadBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngKeiroStepDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngSingiDao;
import jp.groupsession.v2.rng.model.RingiDataModel;
import jp.groupsession.v2.rng.model.RngKeiroStepModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.rng.rng030.RngApprovalModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議RestAPI「稟議にアクションする」のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 */
public class RngUsersEntitiesPostBiz {


    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngUsersEntitiesPostBiz.class);
    /** 実行結果*/
    private RngRestapiRingiModel result__ = null;
    /** コンテキスト */
    private final RestApiContext ctx__;
    /** コネクション */
    private final Connection con__;
    /** 採番コントローラ*/
    private final MlCountMtController mlCnt__;


    /**
     *
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiConst
     */
    public RngUsersEntitiesPostBiz(RestApiContext ctx) {
        ctx__ = ctx;
        con__ = ctx__.getCon();

        try {
            mlCnt__ =
                    GroupSession.getResourceManager().getCountController(ctx.getRequestModel());
        } catch (Exception e) {
            throw new RuntimeException("採番コントローラ取得失敗", e);
        }
    }


    /**
     *
     * <br>[機  能] 稟議を決裁する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl リクエストパラメータ情報
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public void executeShingi(
        RngUsersEntitiesPostParamModel paramMdl,
        GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, Exception {

        log__.info("稟議決裁する");

        CommonBiz cmnBiz = new CommonBiz();
        Rng030Biz rng030Biz = new Rng030Biz(con__, ctx__.getRequestModel());

        //アクション
        String action = paramMdl.getAction();
        boolean smailPluginUseFlg =
            cmnBiz.isCanUsePlugin(GSConstMain.PLUGIN_ID_SMAIL, ctx__.getPluginConfig());

        //ユーザID→SID
        String viewUserId = paramMdl.getUserId();
        UserSearchDao useDao = new UserSearchDao(con__);
        //ユーザIDからユーザ情報取得
        CmnUsrmInfModel viewUserInfMdl = useDao.getUsrData(viewUserId);
        int viewUserSid = viewUserInfMdl.getUsrSid();

        //稟議SID
        int rngSid = paramMdl.getRingiSid();

        //稟議決裁処理モデルを取得
        RngApprovalModel mdl = __getRngApprovalMdl(paramMdl, rngSid, viewUserSid);

        //コミットOFF
        boolean defAutoCommit = con__.getAutoCommit();
        con__.setAutoCommit(false);
        boolean commitFlg = false;

        String opCode = null;
        boolean isDoApi = false;

        //決裁処理実行
        try {
            if (action.equals("syonin")) {
                // 承認処理
                opCode = "承認";
                isDoApi = rng030Biz.approvalRingi(mdl,
                                        mlCnt__,
                                        viewUserSid,
                                        ctx__.getAppRootPath(),
                                        tempPathModel.getTempPath(),
                                        ctx__.getPluginConfig(),
                                        smailPluginUseFlg);

            } else if (action.equals("hinin")) {
                //却下処理
                opCode = "否認";
                rng030Biz.denialRingi(mdl,
                                    mlCnt__,
                                    viewUserSid,
                                    ctx__.getAppRootPath(),
                                    tempPathModel.getTempPath(),
                                    ctx__.getPluginConfig(),
                                    smailPluginUseFlg);

            } else if (action.equals("kakunin")) {
                //確認処理
                opCode = "確認";
                rng030Biz.confirmationRingi(
                                    mdl,
                                    mlCnt__,
                                    viewUserSid,
                                    ctx__.getAppRootPath(),
                                    tempPathModel.getTempPath());

            } else if (action.equals("kanryo")) {
                //完了処理
                opCode = "完了";
                rng030Biz.completeRingi(
                                    mdl,
                                    viewUserSid,
                                    mlCnt__,
                                    ctx__.getAppRootPath(),
                                    ctx__.getPluginConfig(),
                                    smailPluginUseFlg);
            } else if (action.equals("koetu")) {
                //後閲指示
                opCode = "後閲指示";
                rng030Biz.koetu(
                                mdl,
                                mlCnt__,
                                viewUserSid,
                                ctx__.getAppRootPath(),
                                tempPathModel.getTempPath(),
                                ctx__.getPluginConfig(),
                                smailPluginUseFlg);
            } else if (action.equals("sasimodosi")) {
                //差し戻し
                opCode = "差し戻し";
                rng030Biz.reflectionRingi(
                                    mdl,
                                    mlCnt__,
                                    viewUserSid,
                                    ctx__.getAppRootPath(),
                                    tempPathModel.getTempPath(),
                                    ctx__.getPluginConfig(),
                                    smailPluginUseFlg);
            } else if (action.equals("torisage")) {
                //取り下げ
                opCode = "取り下げ";
                rng030Biz.torisage(
                                mdl,
                                mlCnt__,
                                viewUserSid,
                                ctx__.getAppRootPath(),
                                ctx__.getPluginConfig(),
                                smailPluginUseFlg);
            }

            //オペレーションログ出力
            __outPutOpLog(paramMdl, opCode, viewUserInfMdl);

            con__.commit();

            //コミット後実行
            if (isDoApi) {
                //最終承認者が承認ボタンを押下した際に連携APIを実行
                RngApiThreadBiz.operateDomainThread(ctx__.getRequestModel(), rngSid);
            }

            commitFlg = true;

        } catch (Exception e) {
            log__.error("稟議決裁例外発生", e);
            throw e;
        } finally {
            if (!commitFlg) {
                JDBCUtil.rollback(con__);
            }

            //実行後添付フォルダ破棄
            GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
            tempUtil.clearTempPath(tempPathModel);

        }

        con__.setAutoCommit(defAutoCommit);

        //稟議詳細情報の取得
        __getRngData(paramMdl, tempPathModel);
    }


    /**
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public RngRestapiRingiModel getResult() {
        return result__;
    }


    /**
     * <br>[機  能] 稟議詳細情報の取得(共通処理)
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl リクエストパラメータ情報
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    private void __getRngData(
        RngUsersEntitiesPostParamModel paramMdl, GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException {

        //指定された稟議アカウントに対応するユーザSIDを取得
        CmnUsrmDao usrDao = new CmnUsrmDao(con__);
        int usrSid = usrDao.select(paramMdl.getUserId()).getUsrSid();

        //テンポラリディレクトリ作成
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        result__ = rngApiBiz.getRingiDetailModel(ctx__,
                                                paramMdl.getRingiSid(),
                                                usrSid,
                                                tempPathModel);
    }


    /**
     * ユーザが該当稟議に対しての、どの立ち位置の承認者なのか判定する
     *
     * @param viewUserSid
     * @param rngSid
     * @param rksSid
     * @return 0:通常（通常承認可） 1:後閲（後閲承認・否認、後閲指示可） 2:後閲（閲覧のみ）
     * @throws SQLException
     */
    public int checkApprUserKbn(int viewUserSid, int rngSid, int rksSid) throws SQLException {

        int ret = -1;

        int apprMode = RngConst.RNG_APPRMODE_APPR;
        RingiDao ringiDao = new RingiDao(con__);
        RingiDataModel ringiMdl = ringiDao.getRingiData(rngSid, viewUserSid, rksSid);

        RngKeiroStepDao kDao = new RngKeiroStepDao(con__);
        RngKeiroStepModel kMdl = kDao.select(rksSid);

        int syonin = 0;
        int koetu = 0;

        //承認・却下可能判定
        //@see jp.groupsession.v2.rng.rng030.Rng030Biz.buttonDisp()
        if (ringiMdl.getRngCompflg() == RngConst.RNG_COMPFLG_UNDECIDED
            && ringiMdl.getRncType() == RngConst.RNG_RNCTYPE_APPR
            && apprMode == RngConst.RNG_APPRMODE_APPR) {
            if (ringiMdl.getRncStatus() == RngConst.RNG_RNCSTATUS_CONFIRM
                    || (ringiMdl.getRncStatus() != RngConst.RNG_RNCSTATUS_CONFIRM
                    && kMdl != null
                    && kMdl.getRksKoetuSizi() == 0
                    && kDao.getApprButtonFlg(rksSid, rngSid))) {
                syonin = 1;
            }
        }

        //後閲指示（後閲指示判定）
        //@see jp.groupsession.v2.rng.rng030.Rng030Biz.buttonDisp()
        if (ringiMdl.getRngCompflg() == RngConst.RNG_COMPFLG_UNDECIDED
            && ringiMdl.getRncType() == RngConst.RNG_RNCTYPE_APPR
            && ringiMdl.getRncStatus() != RngConst.RNG_RNCSTATUS_CONFIRM
            && apprMode == RngConst.RNG_APPRMODE_APPR) {
            if (kMdl != null
                    && kMdl.getRksKoetuSizi() == 0
                    && kDao.getKoetuButtonFlg(rngSid, kDao.getSortNoKeiro(rksSid, rngSid))) {

                koetu = 1;
            }
        }

        //0：通常、1:後閲、-1：権限無し
        //既存のチェックの仕様上、後閲可能でも0にしてあげる必要有
        if (syonin == 1 && koetu == 0) {
            //承認操作のみ可能な場合、即ち、受信者として承認
            ret = 0;
        } else if (syonin == 1 && koetu == 1) {
            //後閲ボタンが押せる為、後閲者として承認
            ret = 1;
        } else if (syonin == 0 && koetu == 0) {
            //承認ボタンの操作権限が無い状態、即ち後閲ユーザが閲覧のみ可能な状況
            ret = 2;
        } else if (syonin == 0 && koetu == 1) {
            //その他：あり得ない
            ret = -1;
        }

        return ret;
    }


    /**
     * オペレーションログの出力
     * @param paramMdl アクションパラメータ
     * @param opCode 操作コード
     * @param viewUserInfMdl 実行ユーザモデル
     * @throws SQLException
     */
    private void __outPutOpLog(
        RngUsersEntitiesPostParamModel paramMdl, String opCode, CmnUsrmInfModel viewUserInfMdl)
        throws SQLException {


        String action = paramMdl.getAction();
        int rngSid = paramMdl.getRingiSid();

        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        RngRndataDao rndataDao = new RngRndataDao(con__);
        RngRndataModel rnDataMdl = rndataDao.select(rngSid);
        RngSingiDao singiDao = new RngSingiDao(con__);


        StringBuilder sb = new StringBuilder();
        sb.append("[アカウント] " + viewUserInfMdl.getUsiSei() + " " + viewUserInfMdl.getUsiMei());
        sb.append("\n");
        sb.append("[タイトル] " + rnDataMdl.getRngTitle());
        sb.append("\n");
        sb.append("[申請ID] " + NullDefault.getString(rnDataMdl.getRngId(), ""));

        Rng030Biz rng030biz = new Rng030Biz(con__, ctx__.getRequestModel());
        if (action.equals("koetu")) {
            sb.append("\n");
            sb.append("[対象経路] ");
            rng030biz.setOpLogValue(gsMsg, sb, paramMdl.getStepSid(), rngSid);

        } else if (action.equals("sasimodosi")) {

            sb.append("\n");
            sb.append("[対象経路] ");
            //差し戻し対象：申請者
            if (paramMdl.getReturnTargetType() == 0) {
                //申請者の経路情報を更新する
                int shinseiUsrSid = singiDao.selectUserSid(rngSid);
                CmnUsrmInfDao udao = new CmnUsrmInfDao(con__);
                CmnUsrmInfModel umdl = udao.select(shinseiUsrSid);
                sb.append(umdl.getUsiSei() + " " + umdl.getUsiMei());
                sb.append("(");
                sb.append(gsMsg.getMessage("rng.47"));
                sb.append(")");
            //差し戻し対象：審議者
            } else {
                rng030biz.setOpLogValue(gsMsg, sb, paramMdl.getStepSid(), rngSid);
            }
        }

        //オペレーションログ出力
        RngRestapiBiz biz = new RngRestapiBiz();
        biz.outPutLog(
            ctx__, GSConstLog.LEVEL_TRACE, opCode, sb.toString(), "rngSid: " + rngSid);
    }

    /**
     * 稟議決裁処理用モデルをparamMdlから取得する
     * @param paramMdl
     * @param rngSid
     * @param viewUserSid
     * @return 稟議決裁処理用モデル
     * @throws SQLException
     */
    private RngApprovalModel __getRngApprovalMdl(
        RngUsersEntitiesPostParamModel paramMdl,
        int rngSid, int viewUserSid)
        throws SQLException {

        RngApprovalModel mdl = new RngApprovalModel();
        Rng030Biz rng030Biz = new Rng030Biz(con__, ctx__.getRequestModel());

        //アクション
        String action = paramMdl.getAction();
        int procMode = RngConst.RNG_MODE_JYUSIN;

        if (action.equals("koetu")) {
            procMode = RngConst.RNG_MODE_KOETU;
        } else if (action.equals("torisage")) {
            procMode = RngConst.RNG_MODE_SINSEI;
        }

        //経路ステップSID
        int rksSid = rng030Biz.viewKeiroSid(rngSid, viewUserSid, procMode);

        //代理フラグの判定
        int dairiFlg = 0;
        if (viewUserSid != ctx__.getRequestUserSid()) {
            dairiFlg = 1;
        }

        int koetuFlg = 1;
        int chkApprUKbn = checkApprUserKbn(viewUserSid, rngSid, rksSid);
        //PC側のチェック処理の都合で、変換
        //chkApprUKbn == 2はアクセス権限で除外されている為、無視
        if (chkApprUKbn == 1) {
            koetuFlg = 0;
        }

        //稟議決裁処理モデル
        mdl.setRngSid(rngSid);
        mdl.setRksSid(rksSid);
        mdl.setDairiFlg(dairiFlg);
        mdl.setKoetuFlg(koetuFlg);
        mdl.setComment(paramMdl.getCheckCommentText());

        //後閲
        if (action.equals("koetu")) {
            mdl.setKoetuNo(paramMdl.getStepSid());

        //差し戻し
        } else if (action.equals("sasimodosi")) {
            //差し戻し対象：申請者
            if (paramMdl.getReturnTargetType() == 0) {
                mdl.setSasiNo(-1);

            //差し戻し対象：審議者
            } else {
                mdl.setSasiNo(paramMdl.getStepSid());
            }
        }

        return mdl;
    }
}