package jp.groupsession.v2.rng.restapi.users.entities;

import java.sql.SQLException;

import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.MaxLength;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.TextArea;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] 稟議RESTAPI「稟議にアクションする」の取得用モデル
 * <br>[解  説]
 * <br>[備  考]
 */
@ParamModel
public class RngUsersEntitiesPostParamModel {

    //パスパラメータ
    /** ユーザID */
    private String userId__ = null;
    /** 稟議SID */
    private int ringiSid__ = 0;


    //クエリパラメータ
    /** アクション */
    @NotBlank
    @TextField
    private String action__ = null;


    //リクエストボディ
    /** 承認・確認時コメント */
    @TextArea
    @MaxLength(300)
    private String checkCommentText__ = null;
    /** 経路SID */
    private int stepSid__ = -1;
    /** 差し戻し対象 */
    @Selectable({"0", "1"})
    private int returnTargetType__ = -1;


    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        /***** アクセス権限チェック *****/
        //[RINGI-101] ユーザIDに自分自身 or 代理人が指定されているかをチェック
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx.getCon());
        int viewUserSid = usrDao.selectLoginId(userId__);

        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        if (viewUserSid <= GSConstUser.USER_RESERV_SID
            || !rng030Biz.chkViewAccount(viewUserSid)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_ACCOUNT,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.account")
            );
        }

        //[RINGI-202] 草稿は本APIの取得対象外
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);
        if (rngDataMdl != null
            && rngDataMdl.getRngStatus() == RngConst.RNG_STATUS_DRAFT
            && rngDataMdl.getRngAuid() == ctx.getRequestUserModel().getUsrsid()) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_DIF_TYPE_RINGI,
                    "errors.free.msg",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("restapi.ringi.diftypes.draft")
            );
        }

        //[RINGI-102] 指定した稟議を参照可能かをチェック (受信していない稟議へのアクセス)
        if (rngDataMdl == null || !rng030Biz.chkViewRingi(viewUserSid, ringiSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }


        /***** 入力チェック *****/
        //後閲
        if (action__.equals("koetu") && stepSid__ == -1) {
            throw new RestApiValidateException(
                    EnumError.PARAM_REQUIRED,
                    "error.input.required.text",
                    "stepSid")
                    .setParamName("stepSid");
        }

        //差し戻し時、差し戻し対象が未選択の場合
        if (action__.equals("sasimodosi") && returnTargetType__ == -1) {
            throw new RestApiValidateException(
                    EnumError.PARAM_REQUIRED,
                    "error.input.required.text",
                    "returnTargetType")
                    .setParamName("returnTargetType");
        }

        //差し戻し時、差し戻し対象が審議者（1）で、経路SIDが未指定の場合
        if (action__.equals("sasimodosi") && returnTargetType__ == 1 && stepSid__ == -1) {
            throw new RestApiValidateException(
                    EnumError.PARAM_REQUIRED,
                    "error.input.required.text",
                    "stepSid")
                    .setParamName("stepSid");
        }

        //[RINGI-201] アクションの実行権限をチェックする
        int rksSid = 0;
        boolean errorFlg201 = false;
        RngUsersEntitiesPostBiz postBiz = new RngUsersEntitiesPostBiz(ctx);
        int chkApprUKbn = 0;
        int koetuFlg = 1;
        switch (action__) {
            //承認・却下の場合
            case "syonin":
            case "hinin":

                rksSid = rng030Biz.viewKeiroSid(ringiSid__, viewUserSid, RngConst.RNG_MODE_JYUSIN);
                chkApprUKbn = postBiz.checkApprUserKbn(viewUserSid, ringiSid__, rksSid);
                //PC側のチェック処理の都合で、変換
                if (chkApprUKbn == 1 || chkApprUKbn == 2) {
                    koetuFlg = 0;
                }

                //後閲権限があった場合でも、承認可能状態でない場合（閲覧状態の場合）はアクセスエラー
                if (chkApprUKbn == 2
                    || !rng030Biz.appRejBtnConf(ringiSid__, rksSid, koetuFlg, viewUserSid)) {
                    errorFlg201 = true;
                }
                break;
            case "kakunin":
                rksSid = rng030Biz.viewKeiroSid(ringiSid__, viewUserSid, RngConst.RNG_MODE_JYUSIN);
                if (!rng030Biz.confBtnConf(ringiSid__, rksSid, viewUserSid)) {
                    errorFlg201 = true;
                }
                break;
            case "kanryo":
                rksSid = rng030Biz.viewKeiroSid(ringiSid__, viewUserSid, RngConst.RNG_MODE_JYUSIN);
                if (!rng030Biz.compBtnConf(ringiSid__, rksSid, viewUserSid)) {
                    errorFlg201 = true;
                }
                break;
            case "koetu":
                rksSid = rng030Biz.viewKeiroSid(ringiSid__, viewUserSid, RngConst.RNG_MODE_KOETU);
                if (!rng030Biz.koetuBtnConf(ringiSid__, rksSid, stepSid__, viewUserSid)) {
                    errorFlg201 = true;
                }
                break;
            case "sasimodosi":
                rksSid = rng030Biz.viewKeiroSid(ringiSid__, viewUserSid, RngConst.RNG_MODE_JYUSIN);
                int sasimodosiStepSid = 0;
                //差し戻し先が申請者の場合は-1
                if (returnTargetType__ == 0) {
                    sasimodosiStepSid = -1;
                } else if (returnTargetType__ == 1) {
                    sasimodosiStepSid = stepSid__;
                }

                chkApprUKbn = postBiz.checkApprUserKbn(viewUserSid, ringiSid__, rksSid);
                //PC側のチェック処理の都合で、変換
                if (chkApprUKbn == 1 || chkApprUKbn == 2) {
                    koetuFlg = 0;
                }

                if (!rng030Biz.reflectionBtnConf(
                    ringiSid__, rksSid, koetuFlg, sasimodosiStepSid, viewUserSid)) {
                    errorFlg201 = true;
                }
                break;
            case "torisage":
                rksSid = rng030Biz.viewKeiroSid(ringiSid__, viewUserSid, RngConst.RNG_MODE_SINSEI);
                if (!rng030Biz.torisageBtnConf(ringiSid__, rksSid, viewUserSid)) {
                    errorFlg201 = true;
                }
                break;
            default:
                errorFlg201 = true;
                break;
        }

        if (errorFlg201) {
            //アクセス不可
            throw new RestApiValidateException(
                RngEnumReasonCode.RESOURCE_CANT_ACTION,
                    "errors.free.msg",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("restapi.ringi.diftypes.action")
            );
        }

    }


    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }


    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }


    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }


    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }


    /**
     * @return the action
     */
    public String getAction() {
        return action__;
    }


    /**
     * @param action the action to set
     */
    public void setAction(String action) {
        action__ = action;
    }


    /**
     * @return the checkCommentText
     */
    public String getCheckCommentText() {
        return checkCommentText__;
    }


    /**
     * @param checkCommentText the checkCommentText to set
     */
    public void setCheckCommentText(String checkCommentText) {
        checkCommentText__ = checkCommentText;
    }


    /**
     * @return the stepSid
     */
    public int getStepSid() {
        return stepSid__;
    }


    /**
     * @param stepSid the stepSid to set
     */
    public void setStepSid(int stepSid) {
        stepSid__ = stepSid;
    }


    /**
     * @return the returnTargetType
     */
    public int getReturnTargetType() {
        return returnTargetType__;
    }


    /**
     * @param returnTargetType the returnTargetType to set
     */
    public void setReturnTargetType(int returnTargetType) {
        returnTargetType__ = returnTargetType;
    }


}
