package jp.groupsession.v2.rng.restapi.users.entities.steps.comment;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

import javax.servlet.http.HttpServletResponse;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Put;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;

/**
 * <br>[機  能] 稟議 確認時コメント編集API アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngUsersEntitiesStepsCommentAction extends AbstractRestApiAction {

    /**
     * <br>[機  能] PUTメソッド
     * <br>[解  説] 稟議RestAPI「稟議の確認時コメントを編集する」
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Put
    public void doPut(
        HttpServletResponse res,
        RngUsersEntitiesStepsCommentPutParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException, UnsupportedEncodingException {
        //テンポラリディレクトリ作成 ※画面側の処理を使用する過程で必要
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        //入力チェック
        param.validate(ctx, tempPathModel);

        //稟議 確認コメントの編集
        RngUsersEntitiesStepsCommentBiz biz
                            = new RngUsersEntitiesStepsCommentBiz(param, ctx, tempPathModel);
        biz.execute();

        //実行後添付フォルダ破棄
        tempUtil.clearTempPath(tempPathModel);

        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build()
            .execute();

    }
}
