package jp.groupsession.v2.rng.restapi.users.entities.steps.comment;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnBinfDao;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngUsedDataBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngBinDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngSingiDao;
import jp.groupsession.v2.rng.model.RngBinModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 確認時コメント編集API ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 */
public class RngUsersEntitiesStepsCommentBiz {

    /** 実行結果 */
    private RngRestapiRingiModel result__ = null;
    /** リクエストパラメータ */
    private final RngUsersEntitiesStepsCommentPutParamModel param__;
    /** コンテキスト */
    private final RestApiContext ctx__;
    /** DBコネクション */
    private final Connection con__;
    /** GSTemporaryPathModel */
    private final GSTemporaryPathModel tempPathModel__;
    /** 採番コントローラ*/
    private MlCountMtController mlCnt__;

    /**
     *
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param param リクエストパラメータ
     * @param ctx RestApiConst
     * @param tempPathModel GSTemporaryPathModel
     */
    public RngUsersEntitiesStepsCommentBiz(RngUsersEntitiesStepsCommentPutParamModel param,
                                        RestApiContext ctx,
                                        GSTemporaryPathModel tempPathModel) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
        tempPathModel__ = tempPathModel;
        try {
            mlCnt__
                = GroupSession.getResourceManager().getCountController(
                    ctx.getRequestModel());
        } catch (Exception e) {
            throw new RuntimeException("採番コントローラ取得失敗", e);
        }
    }

    /**
     *
     * <br>[機  能] 確認時コメントを編集する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public void execute()
        throws SQLException, RtpNotfoundException, IOToolsException, UnsupportedEncodingException {
        boolean defAutoCommit = con__.getAutoCommit();
        con__.setAutoCommit(false);

        int rngSid = param__.getRingiSid();
        int rksSid = param__.getStepSid();
        CmnUsrmInfModel userData = null;
        int viewUserSid = 0;
        String comment = null;

        boolean commit = false;
        try {
            //実行ユーザ情報
            UserSearchDao userSearchDao = new UserSearchDao(ctx__.getCon());
            userData = userSearchDao.getUsrData(param__.getUserId());
            viewUserSid = userData.getUsrSid();

            //稟議申請情報のデータ使用量を登録(変更前情報のデータ使用量を減算)
            RngUsedDataBiz usedDataBiz = new RngUsedDataBiz(con__);
            usedDataBiz.insertSinseiDataSize(param__.getRingiSid(), false);

            //コメントを登録
            RngSingiDao singiDao = new RngSingiDao(con__);
            comment = null;
            if (param__.getCheckCommentText() != null) {
                comment = param__.getCheckCommentText().trim();
            }
            singiDao.commentEdit(comment, rksSid, viewUserSid);

            //既存の確認時添付から「パラメータで未指定の」添付情報を削除する
            RngBinDao binDao = new RngBinDao(con__);
            CommonBiz cmnBiz = new CommonBiz();

            List<Long> binSidList = getRngStepBinSidList(rksSid, viewUserSid);
            if (!binSidList.isEmpty() && param__.getBinSidArray() != null) {
                //既存の添付情報から「パラメータで指定された添付」を除外
                long[] paramBinArray = param__.getBinSidArray();
                Arrays.sort(paramBinArray);
                binSidList
                    = binSidList.stream()
                    .filter(s -> Arrays.binarySearch(paramBinArray, s) < 0)
                    .collect(Collectors.toList());

                //「パラメータで未指定の添付情報」を削除
                if (!binSidList.isEmpty()) {
                    //バイナリー情報を論理削除する
                    CmnBinfModel cmnBinMdl = new CmnBinfModel();
                    cmnBinMdl.setBinJkbn(GSConst.JTKBN_DELETE);
                    cmnBinMdl.setBinUpuser(ctx__.getRequestUserSid());
                    cmnBinMdl.setBinUpdate(new UDate());
                    CmnBinfDao cmnBinDao = new CmnBinfDao(con__);
                    cmnBinDao.updateJKbn(cmnBinMdl, binSidList);

                    //稟議添付情報を物理削除する
                    binDao.delete(rngSid, viewUserSid, rksSid, binSidList);
                }
            }

            //テンポラリディレクトリ内の稟議添付情報を新規登録する
            try {
                String tempDir = tempPathModel__.getTempPath();
                binSidList = null;
                binSidList = cmnBiz.insertBinInfo(
                        ctx__.getCon(), tempDir,
                        ctx__.getAppRootPath(),
                        mlCnt__,
                        ctx__.getRequestUserSid(),
                        new UDate())
                        .stream()
                        .map(str -> Long.parseLong(str))
                        .collect(Collectors.toList());
                if (binSidList != null && !binSidList.isEmpty()) {
                    RngBinModel binMdl = new RngBinModel();
                    binMdl.setRngSid(rngSid);
                    binMdl.setUsrSid(viewUserSid);
                    binMdl.setRksSid(param__.getStepSid());

                    for (Long binSid : binSidList) {
                        binMdl.setBinSid(binSid);
                        binDao.insert(binMdl);
                    }
                }

            } catch (TempFileException e) {
                throw new RuntimeException("添付ファイル登録に失敗", e);
            }

            //稟議申請情報のデータ使用量(変更後)を登録
            usedDataBiz.insertSinseiDataSize(param__.getRingiSid(), true);

            con__.commit();
            commit = true;
        } finally {
            if (!commit) {
                JDBCUtil.rollback(con__);
            }
            con__.setAutoCommit(defAutoCommit);
        }

        //---オペレーションログ出力処理---
        RequestModel reqMdl = ctx__.getRequestModel();
        GsMessage gsMsg = new GsMessage(reqMdl);
        String opCode = gsMsg.getMessage("cmn.comment") + gsMsg.getMessage("cmn.edit");

        String opValue = "[" + gsMsg.getMessage("cmn.account") + "] "; //アカウント名
        opValue += userData.getUsiSei() + " " + userData.getUsiMei();

        RngRndataDao rngDao = new RngRndataDao(ctx__.getCon());
        RngRndataModel rngMdl = rngDao.select(rngSid);
        opValue += "\r\n[" + gsMsg.getMessage("cmn.title") + "] "; //稟議タイトル
        opValue += rngMdl.getRngTitle();

        opValue += "\r\n[" + gsMsg.getMessage("rng.rng180.04") + "] "; //申請ID
        opValue += NullDefault.getString(rngMdl.getRngId(), "");

        opValue += "\r\n[" + gsMsg.getMessage("cmn.comment") + "] "; // コメント
        opValue += comment;

        opValue += "\r\n[" + gsMsg.getMessage("cmn.attach.file") + "] "; // 添付ファイル
        RingiDao ringiDao = new RingiDao(con__);
        List<CmnBinfModel> fileDataList = ringiDao.getSingiTemp(rksSid, viewUserSid);
        for (int idx = 0; idx < fileDataList.size(); idx++) {
            if (idx > 0) {
                opValue += ",";
            }
            opValue += fileDataList.get(idx).getBinFileName();
        }

        if (opValue.length() > GSConstCommon.MAX_LENGTH_LOG_OP_VALUE) {
            opValue.substring(0, GSConstCommon.MAX_LENGTH_LOG_OP_VALUE);
        }

        //LOG_CODE
        String logCode = "rngsid: " + String.valueOf(rngSid);

        RngRestapiBiz apiBiz = new RngRestapiBiz();
        apiBiz.outPutLog(ctx__, GSConstLog.LEVEL_TRACE, opCode, opValue, logCode);
        //---オペレーションログ出力処理---

        //稟議情報取得
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        result__ = rngApiBiz.getRingiDetailModel(ctx__,
                                    rngSid,
                                    viewUserSid,
                                    tempPathModel__);
    }

    /**
     * <br>[機  能] 稟議の確認時添付に関するバイナリSIDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param rksSid 経路SID
     * @param viewUserSid ユーザSID
     * @return バイナリSID
     * @throws SQLException
     */
    public List<Long> getRngStepBinSidList(int rksSid, int viewUserSid) throws SQLException {
        RingiDao ringiDao = new RingiDao(con__);
        List<CmnBinfModel> binList = ringiDao.getSingiTemp(rksSid, viewUserSid);

        return binList.stream().map(mdl -> mdl.getBinSid()).collect(Collectors.toList());
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public RngRestapiRingiModel getResult() {
        return result__;
    }
}
