package jp.groupsession.v2.rng.restapi.users.entities.steps.comment;

import java.sql.SQLException;
import java.util.List;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.MaxLength;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.TextArea;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.dao.RngSingiDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngSingiModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

/**
 *
 * <br>[機  能] 稟議 確認時コメント編集API パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class RngUsersEntitiesStepsCommentPutParamModel {
    /** ユーザID */
    @TextField
    private String userId__ = null;
    /** 稟議SID */
    private int ringiSid__ = 0;
    /** 経路ステップSID */
    private int stepSid__ = 0;
    /** 確認時コメント */
    @TextArea
    @MaxLength(RngConst.MAX_LENGTH_COMMENT)
    private String checkCommentText__ = "";
    /** 既存バイナリSID */
    private long[] binSidArray__;

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }
    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }
    /**
     * @return the stepSid
     */
    public int getStepSid() {
        return stepSid__;
    }
    /**
     * @param stepSid the stepSid to set
     */
    public void setStepSid(int stepSid) {
        stepSid__ = stepSid;
    }
    /**
     * @return the checkCommentText
     */
    public String getCheckCommentText() {
        return checkCommentText__;
    }
    /**
     * @param checkCommentText the checkCommentText to set
     */
    public void setCheckCommentText(String checkCommentText) {
        checkCommentText__ = checkCommentText;
    }
    /**
     * @return the binSidArray
     */
    public long[] getBinSidArray() {
        return binSidArray__;
    }
    /**
     * @param binSidArray the binSidArray to set
     */
    public void setBinSidArray(long[] binSidArray) {
        binSidArray__ = binSidArray;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public void validate(RestApiContext ctx, GSTemporaryPathModel tempPathModel)
                    throws SQLException, RtpNotfoundException, IOToolsException {

        /***** アクセス権限チェック *****/
        //[RINGI-101] ユーザIDに自分自身 or 代理人が指定されているかをチェック
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx.getCon());
        int viewUserSid = usrDao.selectLoginId(userId__);

        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        if (viewUserSid <= GSConstUser.USER_RESERV_SID
            || !rng030Biz.chkViewAccount(viewUserSid)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_ACCOUNT,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.account")
            );
        }

        //[RINGI-102] 指定した稟議を参照可能かをチェック (受信していない稟議へのアクセス)
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);
        if (rngDataMdl == null || !rng030Biz.chkViewRingi(viewUserSid, ringiSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }

        //[RINGI-104] 確認時コメントの編集が可能かをチェック
        RngSingiDao singiDao = new RngSingiDao(ctx.getCon());
        RngSingiModel singiMdl = singiDao.singiSelect(stepSid__, viewUserSid);
        boolean keiroResult = false;
        if (singiMdl != null && singiMdl.getRngSid() == ringiSid__) {
            //対象ユーザが「承認」「否認」「差し戻し」「後閲」「確認」いずれかの操作を行ったか(確認時コメント入力済みか)
            int keiroStatus = singiMdl.getRssStatus();
            keiroResult =
                keiroStatus == RngConst.RNG_RNCSTATUS_APPR
                || keiroStatus == RngConst.RNG_RNCSTATUS_DENIAL
                || keiroStatus == RngConst.RNG_RNCSTATUS_SASI
                || keiroStatus == RngConst.RNG_RNCSTATUS_KOETU
                || keiroStatus == RngConst.RNG_RNCSTATUS_CONFIRMATION;
        }
        if (!keiroResult) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_KEIRO,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.24")
            );

        }

        //[RINGI-103] 指定された添付ファイルが「編集対象ステップの確認時添付」かをチェック
        if (binSidArray__ != null && binSidArray__.length > 0) {
            RngUsersEntitiesStepsCommentBiz biz
                = new RngUsersEntitiesStepsCommentBiz(this, ctx, tempPathModel);
            List<Long> binSidList = biz.getRngStepBinSidList(stepSid__, viewUserSid);
            for (long binSid : binSidArray__) {
                if (!binSidList.contains(binSid)) {
                    //対象ステップの確認時添付として指定されていない
                    throw new RestApiPermissionException(
                        RngEnumReasonCode.RESOURCE_CANT_ACCESS_FILE,
                            "error.no.access.data",
                            new GsMessage(ctx.getRequestModel())
                            .getMessage("rng.rng030.05")
                    );
                }
            }
        }

    }
}
