package jp.groupsession.v2.rng.restapi.users.entities.steps.keiro;

import java.sql.SQLException;

import javax.servlet.http.HttpServletResponse;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;

/**
 * <br>[機  能] 稟議 承認経路追加API アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 */
@Plugin(RngConst.PLUGIN_ID_RINGI)
public class RngUsersEntitiesStepsKeiroAction extends AbstractRestApiAction {

    /**
     * <br>[機  能] POSTメソッド
     * <br>[解  説] 稟議RestAPI「稟議の承認経路を追加する」
     * <br>[備  考]
     *
     * @param res レスポンス
     * @param param パラメータ
     * @param ctx コンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    @Post
    public void doPost(
        HttpServletResponse res,
        RngUsersEntitiesStepsKeiroPostParamModel param,
        RestApiContext ctx,
        GSTemporaryPathModel tempPathModel)
        throws SQLException, RtpNotfoundException, IOToolsException {

        //テンポラリディレクトリ作成 ※画面側の処理を使用する過程で必要
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.createTempDir(tempPathModel);

        //入力チェック
        param.validate(ctx, tempPathModel);

        //経路追加
        RngUsersEntitiesStepsKeiroBiz biz
                            = new RngUsersEntitiesStepsKeiroBiz(param, ctx, tempPathModel);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
            .addResult(biz.getResult())
            .build()
            .execute();
    }
}
