package jp.groupsession.v2.rng.restapi.users.entities.steps.keiro;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.dao.MlCountMtController;
import jp.groupsession.v2.cmn.dao.UserSearchDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.CmnUserModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngUsedDataBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.dao.RngKeiroStepDao;
import jp.groupsession.v2.rng.dao.RngKeirostepSelectDao;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngKeiroStepModel;
import jp.groupsession.v2.rng.model.RngKeirostepSelectModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.rng.rng030.Rng030KeiroParam;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議 承認経路追加API ビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 */
public class RngUsersEntitiesStepsKeiroBiz {

    /** 実行結果*/
    private RngRestapiRingiModel result__ = null;
    /** リクエストパラメータ */
    private final RngUsersEntitiesStepsKeiroPostParamModel param__;
    /** コンテキスト */
    private final RestApiContext ctx__;
    /** DBコネクション */
    private final Connection con__;
    /** GSTemporaryPathModel */
    private final GSTemporaryPathModel tempPathModel__;
    /** 採番コントローラ*/
    private MlCountMtController mlCnt__;

    /**
     *
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param param リクエストパラメータ
     * @param ctx RestApiConst
     * @param tempPathModel GSTemporaryPathModel
     */
    public RngUsersEntitiesStepsKeiroBiz(RngUsersEntitiesStepsKeiroPostParamModel param,
                                            RestApiContext ctx,
                                            GSTemporaryPathModel tempPathModel) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
        tempPathModel__ = tempPathModel;
        try {
            mlCnt__ = GroupSession.getResourceManager().getCountController(
                    ctx.getRequestModel());
        } catch (Exception e) {
            throw new RuntimeException("採番コントローラ取得失敗", e);
        }
    }

    /**
     *
     * <br>[機  能] 承認経路の追加
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public void execute()
                    throws SQLException, RtpNotfoundException, IOToolsException {
        boolean defAutoCommit = con__.getAutoCommit();
        con__.setAutoCommit(false);

        //実行ユーザ情報
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx__.getCon());
        int viewUserSid = usrDao.selectLoginId(param__.getUserId());

        //稟議申請情報のデータ使用量を登録(変更前情報のデータ使用量を減算)
        RngUsedDataBiz usedDataBiz = new RngUsedDataBiz(con__);
        usedDataBiz.insertSinseiDataSize(param__.getRingiSid(), false);

        //指定した経路ステップの後ろに追加する
        RingiDao ringiDao = new RingiDao(con__);
        List<Rng030KeiroParam> keiroList = ringiDao.getKeiroList(param__.getRingiSid());
        boolean sortChange = false;
        RngKeiroStepDao rksDao = new RngKeiroStepDao(con__);
        int sort = keiroList.get(0).getKeiroSort();
        List<RngKeirostepSelectModel> selectList = new ArrayList<RngKeirostepSelectModel>();

        //対象(グループ)のグループ情報を取得
        List<CmnGroupmModel> groupMdlList = new ArrayList<CmnGroupmModel>();
        if (param__.getAddGroupIdArray().length > 0) {
            CmnGroupmDao grpDao = new CmnGroupmDao(ctx__.getCon());
            groupMdlList = grpDao.selectGrpData(
                param__.getAddGroupIdArray(),
                GSConst.JTKBN_TOROKU);
        }

        for (Rng030KeiroParam keiroParam : keiroList) {
            if (sortChange) {
                //追加された経路より後にある既存経路のソート順を更新する
                rksDao.updateKeiroSort(param__.getRingiSid(), keiroParam.getKeiroStepSid(), sort);
            }
            sort++;
            if (keiroParam.getKeiroStepSid() == param__.getStepSid()) {
                //経路の追加を行う
                sortChange = true;
                int addRksSid = (int) mlCnt__.getSaibanNumber(RngConst.SBNSID_RINGI,
                        RngConst.SBNSID_SUB_RINGI_KEIRO_STEP,
                        viewUserSid);

                //経路ステップの登録
                RngKeiroStepModel rksMdl = new RngKeiroStepModel();
                rksMdl.setRngSid(param__.getRingiSid());
                rksMdl.setRksAuid(viewUserSid);
                rksMdl.setRksAdate(new UDate());
                rksMdl.setRksEuid(viewUserSid);
                rksMdl.setRksEdate(new UDate());
                rksMdl.setRksSid(addRksSid);
                rksMdl.setRksRollType(RngConst.RNG_RNCTYPE_APPR);
                rksMdl.setRksSort(sort);
                rksMdl.setRtkSid(-1);
                rksMdl.setRksBelongSid(keiroParam.getRksBelongSid());
                rksMdl.setRksKeiroKoetu(keiroParam.getKeiroKoetu());
                rksMdl.setRksKoetuSizi(keiroParam.getKeiroKoetuSizi());
                rksMdl.setRksAddstep(keiroParam.getAddibleRtkSid());
                rksMdl.setRksStatus(RngConst.RNG_RNCSTATUS_NOSET);
                rksMdl.setRksRcvdate(null);
                rksDao.insert(rksMdl);

                //審議者情報の登録
                RngKeirostepSelectDao selectDao = new RngKeirostepSelectDao(con__);
                RngKeirostepSelectModel selectMdl = new RngKeirostepSelectModel();
                //ユーザ
                if (param__.getAddUserIdArray().length > 0) {
                    for (int userSid : usrDao.selectLoginId(param__.getAddUserIdArray())) {
                        selectMdl = new RngKeirostepSelectModel();
                        selectMdl.setRksSid(addRksSid);
                        selectMdl.setUsrSid(userSid);
                        selectMdl.setGrpSid(-1);
                        selectMdl.setPosSid(-1);
                        selectList.add(selectMdl);
                    }
                }
                //グループ
                if (param__.getAddGroupIdArray().length > 0) {
                    for (CmnGroupmModel groupMdl : groupMdlList) {
                        selectMdl = new RngKeirostepSelectModel();
                        selectMdl.setRksSid(addRksSid);
                        selectMdl.setUsrSid(-1);
                        selectMdl.setGrpSid(groupMdl.getGrpSid());
                        selectMdl.setPosSid(-1);
                        selectList.add(selectMdl);
                    }
                }
                selectDao.insert(selectList);

                //審議情報の登録
                RngBiz rngBiz = new RngBiz(con__);
                rngBiz.insertSingi(ctx__.getRequestModel(), selectList,
                                    rksMdl, param__.getRingiSid(), addRksSid, sort);
                sort++;
            }
        }

        //稟議申請情報のデータ使用量を登録
        usedDataBiz.insertSinseiDataSize(param__.getRingiSid(), true);

        con__.commit();
        con__.setAutoCommit(defAutoCommit);

        //オペレーションログ出力
        GsMessage gsMsg = new GsMessage(ctx__.getRequestModel());
        RngRndataDao rndataDao = new RngRndataDao(con__);
        RngRndataModel rnDataMdl = rndataDao.select(param__.getRingiSid());
        //ユーザIDからユーザ情報取得
        UserSearchDao useDao = new UserSearchDao(con__);
        CmnUsrmInfModel viewUserInfMdl = useDao.getUsrData(param__.getUserId());
        StringBuilder sb = new StringBuilder();
        sb.append("[アカウント] " + viewUserInfMdl.getUsiSei() + " " + viewUserInfMdl.getUsiMei());
        sb.append("\n");
        sb.append("[タイトル] " + rnDataMdl.getRngTitle());
        sb.append("\n");
        sb.append("[申請ID] ");
        if (rnDataMdl.getRngId() != null) {
            sb.append(rnDataMdl.getRngId());
        }
        sb.append("\n");
        sb.append("[対象経路] ");
        Rng030Biz rng030biz = new Rng030Biz(con__, ctx__.getRequestModel());
        rng030biz.setOpLogValue(gsMsg, sb, param__.getStepSid(), param__.getRingiSid());
        sb.append("\n");
        sb.append("[追加経路] ");
        boolean commaFlg = false;
        for (CmnGroupmModel mdl : groupMdlList) {
            if (commaFlg) {
                sb.append(", ");
            } else {
                commaFlg = true;
            }
            sb.append(mdl.getGrpName());
        }
        for (CmnUserModel mdl : useDao.getUsersDataList(param__.getAddUserIdArray())) {
            if (commaFlg) {
                sb.append(", ");
            } else {
                commaFlg = true;
            }
            sb.append(mdl.getUsiSei());
            sb.append(" ");
            sb.append(mdl.getUsiMei());
        }
        RngRestapiBiz biz = new RngRestapiBiz();
        String logCode = "rngSid: " + param__.getRingiSid();
        biz.outPutLog(ctx__,
            GSConstLog.LEVEL_TRACE,
            gsMsg.getMessage("rng.rng020.02"),
            sb.toString(),
            logCode);

        //稟議情報取得
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        result__ = rngApiBiz.getRingiDetailModel(ctx__,
                                    param__.getRingiSid(),
                                    viewUserSid,
                                    tempPathModel__);
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public RngRestapiRingiModel getResult() {
        return result__;
    }
}
