package jp.groupsession.v2.rng.restapi.users.entities.steps.keiro;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.base.CmnBelongmDao;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.EnumError;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.exception.RestApiValidateException;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.dao.RngRndataDao;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.restapi.model.RngRestapiRingiModel;
import jp.groupsession.v2.rng.restapi.model.route.RngRestapiRingiApprovalRouteModel;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

/**
 *
 * <br>[機  能] 稟議 承認経路追加API パラメータモデル
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@ParamModel
public class RngUsersEntitiesStepsKeiroPostParamModel {
    /** ユーザID */
    @TextField
    private String userId__ = null;
    /** 稟議SID */
    private int ringiSid__ = 0;
    /** 経路SID */
    private int stepSid__ = 0;
    /** 追加ユーザID */
    private String[] addUserIdArray__;
    /** 追加グループID */
    private String[] addGroupIdArray__;

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }
    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }
    /**
     * @return the ringiSid
     */
    public int getRingiSid() {
        return ringiSid__;
    }
    /**
     * @param ringiSid the ringiSid to set
     */
    public void setRingiSid(int ringiSid) {
        ringiSid__ = ringiSid;
    }
    /**
     * @return the stepSid
     */
    public int getStepSid() {
        return stepSid__;
    }
    /**
     * @param stepSid the stepSid to set
     */
    public void setStepSid(int stepSid) {
        stepSid__ = stepSid;
    }
    /**
     * @return the addUserIdArray
     */
    public String[] getAddUserIdArray() {
        return addUserIdArray__;
    }
    /**
     * @param addUserIdArray the addUserIdArray to set
     */
    public void setAddUserIdArray(String[] addUserIdArray) {
        addUserIdArray__ = addUserIdArray;
    }
    /**
     * @return the addGroupIdArray
     */
    public String[] getAddGroupIdArray() {
        return addGroupIdArray__;
    }
    /**
     * @param addGroupIdArray the addGroupIdArray to set
     */
    public void setAddGroupIdArray(String[] addGroupIdArray) {
        addGroupIdArray__ = addGroupIdArray;
    }

    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     * @param tempPathModel GSTemporaryPathModel
     * @throws SQLException SQL実行時例外
     * @throws RtpNotfoundException 対象の稟議テンプレートが存在しない
     * @throws IOToolsException 稟議フォーム情報生成時に例外発生
     */
    public void validate(RestApiContext ctx, GSTemporaryPathModel tempPathModel)
                    throws SQLException, RtpNotfoundException, IOToolsException {
        /***** アクセス権限チェック *****/
        //[RINGI-101] ユーザIDに自分自身 or 代理人が指定されているかをチェック
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx.getCon());
        int viewUserSid = usrDao.selectLoginId(userId__);

        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        if (viewUserSid <= GSConstUser.USER_RESERV_SID || !rng030Biz.chkViewAccount(viewUserSid)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_ACCOUNT,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.account")
            );
        }

        //[RINGI-102] 指定した稟議を参照可能かをチェック (受信していない稟議へのアクセス)
        RngRndataDao rndataDao = new RngRndataDao(ctx.getCon());
        RngRndataModel rngDataMdl = rndataDao.select(ringiSid__);
        if (rngDataMdl == null || !rng030Biz.chkViewRingi(viewUserSid, ringiSid__)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_RINGI,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("main.useddisk.rng.rndata")
            );
        }

        //[RINGI-104] 指定した経路へのアクセスチェック
        RngRestapiBiz rngApiBiz = new RngRestapiBiz();
        RngRestapiRingiModel restRngMdl = rngApiBiz.getRingiDetailModel(ctx,
                                                ringiSid__,
                                                viewUserSid,
                                                tempPathModel);
        RngRestapiRingiApprovalRouteModel appRouteMdl = restRngMdl.getApprovalRouteArray().stream()
                                                        .filter(m -> m.getStepSid() == stepSid__)
                                                        .findFirst()
                                                        .orElse(null);
        if (appRouteMdl == null) {
            //経路ステップが存在しない
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_KEIRO,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.24")
            );
        } else if (appRouteMdl.getAddStepFlg() == RngConst.RNG_DISABLE_ADDKEIRO) {
            //経路追加できない
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_KEIRO,
                    "error.no.access.data",
                    new GsMessage(ctx.getRequestModel())
                    .getMessage("rng.24")
            );
        }

        /***** 入力チェック *****/

        //承認者ユーザ, グループ いずれかが選択されている必要がある。
        if (addUserIdArray__.length == 0
                && addGroupIdArray__.length == 0) {
            throw new RestApiValidateException(
                    EnumError.PARAM_REQUIRED,
                    "error.input.required.text",
                    new GsMessage(ctx.getRequestModel()).getMessage(
                        "restapi.ringi.paramerror.user.group"));
        }

        //承認者ユーザ 論理削除区分を確認、またはユーザは稟議プラグイン使用権限チェック
        if (addUserIdArray__.length > 0) {
            //ログイン可能ユーザSIDリスト
            List<Integer> userSidList = usrDao.selectLoginId(addUserIdArray__);
            CommonBiz cmnBiz = new CommonBiz();
            //稟議プラグイン利用可能ユーザSIDリスト
            List<Integer> cantUseSidList =
                    cmnBiz.getCanUsePluginUser(
                        ctx.getCon(), RngConst.PLUGIN_ID_RINGI,
                        userSidList);
            if (userSidList.size() != addUserIdArray__.length) {
                //存在しない、または削除済みのユーザが指定されている
                throw new RestApiValidateException(
                    EnumError.PARAM_USER_ACCESS,
                    "error.no.access.data",
                    "addUserIdArray"
                    );
            } else if (cantUseSidList.size() != addUserIdArray__.length) {
                //稟議プラグインが使用できないユーザが指定されている
                throw new RestApiValidateException(
                    EnumError.PARAM_USER_ACCESS,
                    "error.no.access.data",
                    "addUserIdArray"
                    );
            }
        }
        //承認者グループ 論理削除区分を確認、または所属ユーザの利用可能チェック
        if (addGroupIdArray__.length > 0) {

            CmnGroupmDao grpDao = new CmnGroupmDao(ctx.getCon());
            List<CmnGroupmModel> grpMdlList = grpDao.selectGrpData(
                addGroupIdArray__, CmnGroupmDao.GRP_JKBN_LIVING);
            if (grpMdlList.size() != addGroupIdArray__.length) {
                //存在しない、または削除済みのグループが指定されている
                throw new RestApiValidateException(
                    EnumError.PARAM_USER_ACCESS,
                    "error.no.access.data",
                    "addGroupIdArray"
                    );
            } else {
                Integer[] grpSidList =
                    grpMdlList.stream()
                        .map(mdl -> mdl.getGrpSid())
                        .collect(Collectors.toList())
                        .toArray(new Integer[grpMdlList.size()]);
                CmnBelongmDao belongDao = new CmnBelongmDao(ctx.getCon());
                List<String> userSidList =
                    belongDao.select(grpSidList, GSConstUser.USER_JTKBN_ACTIVE);
                if (userSidList.size() <= 0) {
                    //指定したグループに所属する利用可能なユーザが存在しない
                    throw new RestApiValidateException(
                        RngEnumReasonCode.RESOURCE_GROUP_EMPTY,
                        "restapi.error.group.empty",
                        "addGroupIdArray"
                        );
                } else {
                    CommonBiz cmnBiz = new CommonBiz();
                    //稟議プラグイン利用可能ユーザSIDリスト
                    List<Integer> cantUseSidList =
                            cmnBiz.getCanUsePluginUser(
                                ctx.getCon(), RngConst.PLUGIN_ID_RINGI,
                                userSidList.stream()
                                    .map(s -> NullDefault.getInt(s, -1))
                                    .collect(Collectors.toList()));
                    if (cantUseSidList.size() <= 0) {
                        //指定したグループに所属する利用可能なユーザが存在しない
                        throw new RestApiValidateException(
                            RngEnumReasonCode.RESOURCE_GROUP_EMPTY,
                            "restapi.error.group.empty",
                            "addGroupIdArray"
                            );
                    }
                }
            }
        }
    }
}
