package jp.groupsession.v2.rng.restapi.users.folders.entities.query;

import java.sql.SQLException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.restapi.controller.AbstractRestApiAction;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.controller.annotation.Plugin;
import jp.groupsession.v2.restapi.controller.annotation.Post;
import jp.groupsession.v2.restapi.response.RestApiResponseWriter;

/**
 * <br>[機  能] RESTAPI「稟議情報を一覧取得する」アクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
@Plugin(GSConst.PLUGIN_ID_RINGI)
public class RngUsersFoldersEntitiesQueryAction extends AbstractRestApiAction {

    /**
     * POSTメソッド
     *
     * @param req リクエスト
     * @param res レスポンス
     * @param ctx コンテキスト
     * @param param リクエストパラメータ
     * @throws SQLException
     */
    @Post
    public void doPost(
        HttpServletRequest req,
        HttpServletResponse res,
        RngUsersFoldersEntitiesQueryPostParamModel param,
        RestApiContext ctx) throws SQLException {

        //一覧取得
        RngUsersFoldersEntitiesQueryBiz biz = new RngUsersFoldersEntitiesQueryBiz(param, ctx);
        biz.execute();

        RestApiResponseWriter.builder(res, ctx)
        .addResultList(biz.getResult())
        .setMax(biz.getMaxCount())
        .build().execute();
    }

}
