package jp.groupsession.v2.rng.restapi.users.folders.entities.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.dao.base.CmnGroupmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RingiDao;
import jp.groupsession.v2.rng.model.RingiDataModel;
import jp.groupsession.v2.rng.model.RingiSearchModel;
import jp.groupsession.v2.rng.model.RngAconfModel;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;


/**
 * <br>[機  能] 稟議情報を一覧取得するAPI ビジネスロジック
 * <br>[解  説]
 * <br>[備  考]
 */
public class RngUsersFoldersEntitiesQueryBiz {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(RngUsersFoldersEntitiesQueryBiz.class);

    /** リクエストパラメータ */
    private RngUsersFoldersEntitiesQueryPostParamModel param__;
    /** 実行結果*/
    private List<RngUsersFoldersEntitiesQueryResultModel> result__ = new ArrayList<>();
    /** 件数 */
    private int maxCnt__;

    /** コンテキスト */
    private RestApiContext ctx__;
    /** DBコネクション */
    private Connection con__;

    /**
     * コンストラクタ
     * @param param リクエストパラメータ
     * @param ctx コンテキスト
     */
    public RngUsersFoldersEntitiesQueryBiz(
        RngUsersFoldersEntitiesQueryPostParamModel param,
        RestApiContext ctx) {
        param__ = param;
        ctx__ = ctx;
        con__ = ctx__.getCon();
    }

    /**
     *
     * <br>[機  能] 稟議情報を一覧取得する
     * <br>[解  説]
     * <br>[備  考]
     * @throws SQLException SQL実行時例外
     */
    public void execute() throws SQLException {

        log__.info("稟議情報を一覧取得するAPI execute");

        CmnUsrmDao usrDao = new CmnUsrmDao(con__);
        RingiDao rngDao = new RingiDao(con__);
        RngRestapiBiz rrBiz = new RngRestapiBiz();

        //指定された稟議アカウントに対応するユーザSIDを取得
        int usrSid = usrDao.select(param__.getUserId()).getUsrSid();

        //パスパラメータフォルダ名からプロセスモードを取得
        int procMode = rrBiz.getProcMode(param__.getFolderName());

        //管理者設定を取得
        RngBiz rngBiz = new RngBiz(con__);
        RngAconfModel acondfMdl = rngBiz.getRngAconf(con__);

        //管理者権限を取得
        CommonBiz cmnBiz = new CommonBiz();
        boolean isAdmin
            = cmnBiz.isPluginAdmin(con__, ctx__.getRequestUserModel(), RngConst.PLUGIN_ID_RINGI);

        //検索条件取得
        RingiSearchModel searchModel = __createSearchModel(usrSid, procMode);

        //最大件数
        maxCnt__ = rngDao.getRingiDataCount(searchModel, procMode);

        //offsetが最大件数より大きい場合にエラーになるため、検索処理終了
        if (maxCnt__ < param__.getOffset()) {
            return;
        }

        //検索結果
        List <RingiDataModel> ringiList = rngDao.getRingiDataList(searchModel, procMode);

        result__ = ringiList.stream()
                    .map(RingiDataModel -> {
                        RngUsersFoldersEntitiesQueryResultModel mdl
                            = new RngUsersFoldersEntitiesQueryResultModel();


                        mdl.setSid(RingiDataModel.getRngSid());
                        mdl.setTitleText(RingiDataModel.getRngTitle());
                        mdl.setUserId(RingiDataModel.getApprUserId());
                        mdl.setUserName(RingiDataModel.getApprUser());
                        mdl.setLoginStopFlg(RingiDataModel.getUsrUkoFlg());
                        mdl.setUserDeleteFlg(RingiDataModel.isApprUserDelFlg() ? 1 : 0);
                        mdl.setEntryDateTime(RingiDataModel.getRngAppldate());

                        if (procMode == RngConst.RNG_MODE_JYUSIN) {
                            //受信の場合
                            //削除不可
                            //最終更新日時には受信日時
                            mdl.setStatusType(RingiDataModel.getRngStatus());
                            mdl.setCompKbn(RingiDataModel.getRngCompflg());
                            mdl.setDeleteKanouFlg(RngConst.RNG_DEL_NG);
                            mdl.setLastDateTime(RingiDataModel.getRcvDate());
                            mdl.setEntryIdText(RingiDataModel.getRngId());
                        } else if (procMode == RngConst.RNG_MODE_SOUKOU) {
                            //草稿の場合
                            //稟議状態、完了区分はデフォルト値
                            //削除可能
                            //作成者としてセッションユーザの情報を設定する
                            mdl.setStatusType(RingiDataModel.getRngStatus());
                            mdl.setDeleteKanouFlg(RngConst.RNG_DEL_OK);
                            mdl.setUserId(ctx__.getRequestUserModel().getLgid());
                            mdl.setUserName(ctx__.getRequestUserModel().getUsiseimei());
                            mdl.setLoginStopFlg(ctx__.getRequestUserModel().getUsrUkoFlg());
                            mdl.setUserDeleteFlg(0);
                            //申請日時欄に作成日時をセットする
                            mdl.setEntryDateTime(RingiDataModel.getMakeDate());
                        } else if (procMode == RngConst.RNG_MODE_KANRYO) {
                            //完了の場合
                            mdl.setStatusType(RingiDataModel.getRngStatus());
                            mdl.setCompKbn(RingiDataModel.getRngCompflg());
                            mdl.setLastDateTime(RingiDataModel.getLastManageDate());
                            mdl.setEntryIdText(RingiDataModel.getRngId());
                            //削除可能かを判定する
                            if (RingiDataModel.getRngApplicate()
                                == ctx__.getRequestUserModel().getUsrsid()
                                && usrSid == ctx__.getRequestUserModel().getUsrsid()
                                && rngBiz.hasDelAuth(acondfMdl, isAdmin)) {
                                //セッションユーザ = 申請者
                                //稟議アカウントに指定したユーザ = セッションユーザ
                                //管理者設定の削除権限設定をチェック
                                mdl.setDeleteKanouFlg(RngConst.RNG_DEL_OK);
                            } else {
                                mdl.setDeleteKanouFlg(RngConst.RNG_DEL_NG);
                            }
                        } else {
                            //申請中、後閲の場合
                            //削除不可
                            mdl.setStatusType(RingiDataModel.getRngStatus());
                            mdl.setCompKbn(RingiDataModel.getRngCompflg());
                            mdl.setDeleteKanouFlg(RngConst.RNG_DEL_NG);
                            mdl.setLastDateTime(RingiDataModel.getLastManageDate());
                            mdl.setEntryIdText(RingiDataModel.getRngId());
                        }
                        return mdl;
                    })
                    .collect(Collectors.toList());
    }

    /**
     * 最大件数を取得する
     * @return 最大件数
     * @throws SQLException
     */
    public int getMaxCount() throws SQLException {
        return maxCnt__;
    }

    /**
     *
     * <br>[機  能] 実行結果の取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 実行結果
     */
    public List<RngUsersFoldersEntitiesQueryResultModel> getResult() {
        return result__;
    }


    /**
     * <br>[機  能] 検索条件Modelを生成する
     * <br>[解  説]
     * <br>[備  考]
     *
     * @param acUsrSid アカウントユーザSID
     * @param procMode プロセスモード
     * @return 検索条件
     */
    private RingiSearchModel __createSearchModel(int acUsrSid, int procMode) throws SQLException {

        RingiSearchModel model = new RingiSearchModel();

        //----パスパラメータ----
        model.setUserSid(acUsrSid);

        //----クエリパラメータ----
        model.setPageMode(false);
        model.setMaxCnt(param__.getLimit());
        model.setOffSet(param__.getOffset());

        //----リクエストボディ-----

        //--共通パラメータ--
        //キーワード(ANDで固定)
        model.setKeyword(RngBiz.createKeywordList(param__.getKeywordText()));
        model.setKeywordType(RngConst.RNG_SEARCHTYPE_AND);

        //申請者グループID
        //申請者ユーザIDが未設定の場合のみ有効
        if (param__.getEntryGroupId() != null && param__.getEntryUserId() == null) {
            CmnGroupmDao grpDao = new CmnGroupmDao(con__);
            CmnGroupmModel gmdl = grpDao.getGroupInf(param__.getEntryGroupId());
            if (gmdl != null) {
                model.setApplGroupSid(gmdl.getGrpSid());
            } else {
                //存在しないグループSIDを指定
                model.setApplGroupSid(Integer.MAX_VALUE);
            }
        }

        //申請者ユーザID
        if (param__.getEntryUserId() != null) {
            CmnUsrmDao usrDao = new CmnUsrmDao(con__);
            //ユーザID→ユーザSID
            CmnUsrmModel uMdl = usrDao.select(param__.getEntryUserId());
            if (uMdl != null) {
                model.setApplUserSid(uMdl.getUsrSid());
            } else {
                //存在しないユーザSIDを指定
                model.setApplUserSid(Integer.MAX_VALUE);
            }
        }

        //申請日(開始)
        model.setApplDateFr(param__.getFromEntryDate());
        //申請日(終了)
        model.setApplDateTo(param__.getToEntryDate());


        //--フォルダごとのパラメータ--
        //受信・進行中
        if (procMode == RngConst.RNG_MODE_JYUSIN
            || procMode == RngConst.RNG_MODE_SINSEI) {
            //最終確認日(開始・終了)
            model.setLastMagageDateFr(param__.getFromConfirmDate());
            model.setLastMagageDateTo(param__.getToConfirmDate());

            //申請ID検索
            model.setRngIdSearchFlg(true);
        }

        //草稿
        if (procMode == RngConst.RNG_MODE_SOUKOU) {
            //申請者ID・グループ検索は草稿は不要の為、実行しない
            model.setApplGroupSid(-1);
            model.setApplUserSid(-1);
        }

        //完了
        if (procMode == RngConst.RNG_MODE_KANRYO) {
            //稟議状態
            model.setStatusId(param__.getStatusType());
            //最終確認日(開始・終了)
            model.setLastMagageDateFr(param__.getFromConfirmDate());
            model.setLastMagageDateTo(param__.getToConfirmDate());
        }

        //後閲
        if (procMode == RngConst.RNG_MODE_KOETU) {
            //最終確認日(開始・終了)
            model.setLastMagageDateFr(param__.getFromConfirmDate());
            model.setLastMagageDateTo(param__.getToConfirmDate());
        }

        //----その他検索条件----
        model.setAdminFlg(false);
        model.setCategorySid(-1);

        //ソート関係
        switch (procMode) {
            case RngConst.RNG_MODE_JYUSIN:
                model.setSortKey(RngConst.RNG_SORT_JYUSIN);
                model.setOrderKey(RngConst.RNG_ORDER_ASC);
                break;
            case RngConst.RNG_MODE_SINSEI:
                model.setSortKey(RngConst.RNG_SORT_KAKUNIN);
                model.setOrderKey(RngConst.RNG_ORDER_DESC);
                //進行中の場合、第２ソートキーに申請日時を設定
                model.setSortKey2(RngConst.RNG_SORT_DATE);
                model.setOrderKey2(RngConst.RNG_ORDER_DESC);
                break;
            case RngConst.RNG_MODE_KANRYO:
                model.setSortKey(RngConst.RNG_SORT_KAKUNIN);
                model.setOrderKey(RngConst.RNG_ORDER_DESC);
                break;
            case RngConst.RNG_MODE_SOUKOU:
                model.setSortKey(RngConst.RNG_SORT_TOUROKU);
                model.setOrderKey(RngConst.RNG_ORDER_DESC);
                break;
            case RngConst.RNG_MODE_KOETU:
                model.setSortKey(RngConst.RNG_SORT_DATE);
                model.setOrderKey(RngConst.RNG_ORDER_DESC);
                break;
            default:
                model.setSortKey(RngConst.RNG_SORT_JYUSIN);
                model.setOrderKey(RngConst.RNG_ORDER_ASC);
                break;
        }

        return model;
    }

}
