package jp.groupsession.v2.rng.restapi.users.folders.entities.query;

import java.sql.SQLException;

import jp.co.sjts.util.date.UDate;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.restapi.controller.RestApiContext;
import jp.groupsession.v2.restapi.exception.RestApiPermissionException;
import jp.groupsession.v2.restapi.parameter.annotation.Default;
import jp.groupsession.v2.restapi.parameter.annotation.MaxValue;
import jp.groupsession.v2.restapi.parameter.annotation.MinValue;
import jp.groupsession.v2.restapi.parameter.annotation.NotBlank;
import jp.groupsession.v2.restapi.parameter.annotation.ParamModel;
import jp.groupsession.v2.restapi.parameter.annotation.Selectable;
import jp.groupsession.v2.restapi.parameter.annotation.TextField;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat;
import jp.groupsession.v2.restapi.parameter.annotation.UDateFormat.Format;
import jp.groupsession.v2.restapi.parameter.annotation.Validator;
import jp.groupsession.v2.rng.restapi.RngEnumReasonCode;
import jp.groupsession.v2.rng.restapi.RngRestapiBiz;
import jp.groupsession.v2.rng.rng030.Rng030Biz;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.GSConstUser;

/**
 * <br>[機  能] RESTAPI「稟議情報を一覧取得する」取得用モデル
 * <br>[解  説]
 * <br>[備  考]
 */
@ParamModel
public class RngUsersFoldersEntitiesQueryPostParamModel {

    //パスパラメータ
    /** ユーザID */
    @NotBlank
    private String userId__ = null;

    /** フォルダ名 */
    @NotBlank
    @Selectable({"jyusin", "sinsei", "kanryo", "soukou", "koetu"})
    private String folderName__ = null;

    // クエリパラメータ
    /** 取得件数 */
    @MaxValue(100)
    @MinValue(1)
    @Default("50")
    private int limit__;

    /** 取得開始位置 */
    @Default("0")
    @MinValue(0)
    private int offset__;

    // リクエストボディ
    /** 稟議状態 */
    @Default("-1")
    @Selectable({"-1", "2", "3", "4", "5"})
    private int statusType__;

    /** キーワード */
    @TextField
    private String keywordText__ = null;

    /** 申請者グループID */
    private String entryGroupId__ = null;

    /** 申請者ユーザID */
    private String entryUserId__ = null;

    /** 申請日(開始) */
    @UDateFormat(Format.DATE_SLUSH)
    private UDate fromEntryDate__ = null;

    /** 申請日(終了) */
    @UDateFormat(Format.DATE_SLUSH)
    private UDate toEntryDate__ = null;

    /** 最終確認日(開始) */
    @UDateFormat(Format.DATE_SLUSH)
    private UDate fromConfirmDate__ = null;

    /** 最終確認日(終了) */
    @UDateFormat(Format.DATE_SLUSH)
    private UDate toConfirmDate__ = null;


    /**
     * <br>[機  能] 入力チェックを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param ctx RestApiコンテキスト
     */
    @Validator
    public void validate(RestApiContext ctx) throws SQLException {

        //----アクセス権限チェック----
        //ユーザIDに自分自身 or 代理人が指定されているかをチェック
        CmnUsrmDao usrDao = new CmnUsrmDao(ctx.getCon());
        int viewUserSid = usrDao.selectLoginId(userId__);

        Rng030Biz rng030Biz = new Rng030Biz(ctx.getCon(), ctx.getRequestModel());
        if (viewUserSid <= GSConstUser.USER_RESERV_SID || !rng030Biz.chkViewAccount(viewUserSid)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_ACCOUNT,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.account")
            );
        }

        //草稿フォルダへのアクセス権限チェック
        RngRestapiBiz rngrBiz = new RngRestapiBiz();
        int procMode = rngrBiz.getProcMode(folderName__);
        if (!rngrBiz.isAccessSokouFolder(ctx.getRequestModel(), userId__, procMode)) {
            throw new RestApiPermissionException(
                RngEnumReasonCode.RESOURCE_CANT_ACCESS_FOLDER,
                "error.no.access.data",
                new GsMessage(ctx.getRequestModel())
                    .getMessage("cmn.folder")
            );
        }

    }

    /**
     * @return the userId
     */
    public String getUserId() {
        return userId__;
    }

    /**
     * @param userId the userId to set
     */
    public void setUserId(String userId) {
        userId__ = userId;
    }

    /**
     * @return the folderName
     */
    public String getFolderName() {
        return folderName__;
    }

    /**
     * @param folderName the folderName to set
     */
    public void setFolderName(String folderName) {
        folderName__ = folderName;
    }

    /**
     * @return the limit
     */
    public int getLimit() {
        return limit__;
    }

    /**
     * @param limit the limit to set
     */
    public void setLimit(int limit) {
        limit__ = limit;
    }

    /**
     * @return the offset
     */
    public int getOffset() {
        return offset__;
    }

    /**
     * @param offset the offset to set
     */
    public void setOffset(int offset) {
        offset__ = offset;
    }

    /**
     * @return the statusType
     */
    public int getStatusType() {
        return statusType__;
    }

    /**
     * @param statusType the statusType to set
     */
    public void setStatusType(int statusType) {
        statusType__ = statusType;
    }

    /**
     * @return the keywordText
     */
    public String getKeywordText() {
        return keywordText__;
    }

    /**
     * @param keywordText the keywordText to set
     */
    public void setKeywordText(String keywordText) {
        keywordText__ = keywordText;
    }

    /**
     * @return the entryGroupId
     */
    public String getEntryGroupId() {
        return entryGroupId__;
    }

    /**
     * @param entryGroupId the entryGroupId to set
     */
    public void setEntryGroupId(String entryGroupId) {
        entryGroupId__ = entryGroupId;
    }

    /**
     * @return the entryUserId
     */
    public String getEntryUserId() {
        return entryUserId__;
    }

    /**
     * @param entryUserId the entryUserId to set
     */
    public void setEntryUserId(String entryUserId) {
        entryUserId__ = entryUserId;
    }

    /**
     * @return the fromEntryDate
     */
    public UDate getFromEntryDate() {
        return fromEntryDate__;
    }

    /**
     * @param fromEntryDate the fromEntryDate to set
     */
    public void setFromEntryDate(UDate fromEntryDate) {
        fromEntryDate__ = fromEntryDate;
    }

    /**
     * @return the toEntryDate
     */
    public UDate getToEntryDate() {
        return toEntryDate__;
    }

    /**
     * @param toEntryDate the toEntryDate to set
     */
    public void setToEntryDate(UDate toEntryDate) {
        toEntryDate__ = toEntryDate;
    }

    /**
     * @return the fromConfirmDate
     */
    public UDate getFromConfirmDate() {
        return fromConfirmDate__;
    }

    /**
     * @param fromConfirmDate the fromConfirmDate to set
     */
    public void setFromConfirmDate(UDate fromConfirmDate) {
        fromConfirmDate__ = fromConfirmDate;
    }

    /**
     * @return the toConfirmDate
     */
    public UDate getToConfirmDate() {
        return toConfirmDate__;
    }

    /**
     * @param toConfirmDate the toConfirmDate to set
     */
    public void setToConfirmDate(UDate toConfirmDate) {
        toConfirmDate__ = toConfirmDate;
    }

}
