package jp.groupsession.v2.rng.rng300;

import java.sql.Connection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;

import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.cmn999.Cmn999Form;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.rng.AbstractRingiTemplateAction;
import jp.groupsession.v2.rng.RngCategoriCantAccessException;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.rng090.Rng090Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 稟議テンプレート 申請内容プレビュー画面のアクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng300Action extends AbstractRingiTemplateAction {

    /**
     * <p>管理者以外のアクセスを許可するのか判定を行う。
     * <p>サブクラスでこのメソッドをオーバーライドして使用する
     * @param req リクエスト
     * @param form アクションフォーム
     * @return true:許可する,false:許可しない
     */
    public boolean canNotAdminAccess(HttpServletRequest req, ActionForm form) {
        return true;
    }

    /**
    * <br>[機  能] アクション実行前の事前処理を行う
    * <br>[解  説]
    * <br>[備  考]
    * @param form ActionForm
    */
    private void __prepareAction(Rng300Form form) {

        Rng300Form thisForm = form;
        if (form.getRng090templateJSON() != null) {
            String jsonStr = form.getRng090templateJSON();
            if (jsonStr.indexOf(0xA0) >= 0) {
                // HTML用半角スペース(&nbsp; -> 0xA0)が含まれている場合、通常の半角スペース(0x20)へ変換
                jsonStr = jsonStr.replace((char) 0xA0, (char) 0x20);
                form.setRng090templateJSON(jsonStr); // パラメータへ再セット
            }
            //JSONからフォームビルダーを生成する
            thisForm.getRng090template().setFormTable(form.getRng090templateJSON());
        }
   }

   /**
    * <br>[機  能] アクション実行前の事前処理 アクセス制限を行う
    * <br>[解  説]
    * <br>[備  考]
    * @param map ActionMapping
    * @param form ActionForm
    * @param req HttpServletRequest
    * @param con DB Connection
    * @return ActionForward
    * @throws Exception 実行時例外
    */
    private ActionForward __immigration(
        ActionMapping map,
        Rng300Form form,
        HttpServletRequest req,
        Connection con) throws Exception {

        RequestModel reqMdl = getRequestModel(req);
        GsMessage gsMsg = new GsMessage(reqMdl);
        CommonBiz cmnBiz = new CommonBiz();
        boolean adminUser = cmnBiz.isPluginAdmin(con, reqMdl.getSmodel(), getPluginId());

        int tFlg = form.getRngTemplateMode();

        // 個人テンプレートまたはv472以前の共有テンプレートは申請内容プレビュー対象外
        if (tFlg == RngConst.RNG_TEMPLATE_PRIVATE
            || form.getRng090rtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_INIT) {
            return __getErrorPageForPopup(map, req);
        }

        //稟議編集の場合 カテゴリの編集権限がなければアクセスエラー
        //新規作成の場合 カテゴリは登録確認時に入力チェックするのでここではアクセスエラーにならない
        if (form.getRngTplCmdMode() == RngConst.RNG_CMDMODE_ADD) {
            return null;
        }
        RngTemplateBiz rtBiz = new RngTemplateBiz();
        //エラー画面用hidden設定
        RngTemplateModel rtModel = rtBiz.getRtpModel(form.getRngSelectTplSid(), con);
        Cmn999Form cmn999form = new Cmn999Form();
        cmn999form.addHiddenAll(form, form.getClass(), "");
        if (rtModel == null) {
            return getCatchExceptionPageForPopup(map, req, new RtpNotfoundException(), cmn999form);
        }

        //カテゴリアクセス権限例外用のエラー場面設定を用意
        RngCategoriCantAccessException rcaException = new RngCategoriCantAccessException();
        rcaException.setSeigenKbn(RngCategoriCantAccessException.SEIGEN_KBN_AUTH);
        rcaException.setCantActionStr(gsMsg.getMessage("cmn.edit"));
        ActionForward authError = getCatchExceptionPageForPopup(map, req, rcaException, cmn999form);
        //カテゴリアクセス権限
        Rng090Biz rng090Biz = new Rng090Biz(con, reqMdl);
        if (!rng090Biz.categoriAuthChk(tFlg, rtModel.getRtcSid(), adminUser)) {
            return authError;
        }
        //データの不正書き換え対策
        if (form.getRng090rtpSpecVer() != rtModel.getRtpSpecVer()) {
            return __getErrorPageForPopup(map, req);
        }
        return null;
    }

    /**
     * <br>[機  能] アクションを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form ActionForm
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward executeAction(
        ActionMapping map,
        ActionForm form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        ActionForward forward = null;
        Rng300Form thisForm = (Rng300Form) form;
        __prepareAction(thisForm);
        forward = __immigration(map, thisForm, req, con);
        if (forward != null) {
            return forward;
        }
        forward =  __doInit(map, thisForm, req, res, con);
        return forward;
    }

    /**
     * <br>[機  能] 初期表示
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng300Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doInit(
        ActionMapping map,
        Rng300Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        con.setAutoCommit(true);
        Rng300ParamModel paramMdl = new Rng300ParamModel();
        paramMdl.setParam(form);
        RequestModel reqMdl = getRequestModel(req);
        Rng300Biz biz = new Rng300Biz();
        biz.initDsp(paramMdl, _getRingiDir(req), con, reqMdl);
        paramMdl.setFormData(form);
        con.setAutoCommit(false);
        return map.getInputForward();
    }

    /**
     * <br>[機  能] 検索結果が無い場合のエラー画面処理と遷移
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param req リクエスト
     * @return アクションフォワード
     */
    private ActionForward __getErrorPageForPopup(
        ActionMapping map,
        HttpServletRequest req) {

        Cmn999Form cmn999Form = new Cmn999Form();
        MessageResources msgRes = getResources(req);
        cmn999Form.setMessage(
            msgRes.getMessage("error.access.double.submit.popup"));
        cmn999Form.setType_popup(Cmn999Form.POPUP_TRUE);
        req.setAttribute("cmn999Form", cmn999Form);
        return map.findForward("gf_msg");
    }
}
