package jp.groupsession.v2.rng.rng310;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.cmn999.Cmn999Form;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.rng.AbstractRingiTemplateAction;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 連携API登録画面のアクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng310Action extends AbstractRingiTemplateAction {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Rng310Action.class);

    /**
     * <br>[機  能] アクションを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form ActionForm
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward executeAction(
        ActionMapping map,
        ActionForm form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        ActionForward forward = null;
        Rng310Form thisForm = (Rng310Form) form;
        forward = __immigration(map, thisForm, req, con);
        if (forward != null) {
            return forward;
        }

        //コマンドパラメータ取得
        String cmd = NullDefault.getString(req.getParameter("CMD"), "");
        log__.debug("CMD = " + cmd);

        if (cmd.equals("addActionParam")) {
            log__.debug("*** アクションパラメータ追加");
            forward = __addActiomParam(map, thisForm, req, res, con);
        } else if (cmd.equals("editActionParam")) {
            log__.debug("*** アクションパラメータ編集");
            forward = __doSave(map, thisForm, req, res, con, true, "actionParam");
        } else if (cmd.equals("rng310_ok")) {
            log__.debug("*** OKボタン");
            forward = __doSave(map, thisForm, req, res, con, true, "rng090");
        } else if (cmd.equals("rng310_back")) {
            log__.debug("*** 戻るボタン");
            forward = __doSave(map, thisForm, req, res, con, false, "rng090");
            // forward = map.findForward("rng090");
        } else if (cmd.equals("getFormInfo")) {
            log__.debug("*** フォーム情報を取得");
            __getFormInfo(thisForm, req, res, con);
        } else if (cmd.equals("getPosInfo")) {
            log__.debug("*** 役職情報を取得");
            __getPosInfo(req, res, con);
        } else if (cmd.equals("getGroupList")) {
            log__.debug("*** グループ一覧を取得");
            __getGroupList(req, res, con);
        } else if (cmd.equals("getUserList")) {
            log__.debug("*** ユーザ一覧を取得");
            __getUserList(thisForm, req, res, con);
        } else if (cmd.equals("checkApiSetting")) {
            log__.debug("*** API設定 入力チェック");
            __checkApiSetting(thisForm, req, res, con);
        } else if (cmd.equals("checkAddActionParam")) {
            log__.debug("*** 実行条件追加 入力チェック");
            __checkAddActionParam(thisForm, req, res, con);
        } else if (cmd.equals("copyCondition")) {
            log__.debug("*** 既存の実行条件を複写");
            __copyCondition(thisForm, req, res, con);
        } else if (cmd.equals("copyActionParam")) {
            log__.debug("*** アクションパラメータ複写");
            __copyActionParam(thisForm, req, res, con);
        } else {
            forward = __doInit(map, thisForm, req, res, con);
        }
        return forward;
    }

    /**
     * <br>[機  能] 使用中の連携APIが存在しない or 論理削除済みの場合にcmn999への遷移先を返す
     * <br>[解  説]
     * <br>[備  考] 使用中の連携APIが正常の場合、nullを返す
     * @param map ActionMapping
     * @param form ActionForm
     * @param req リクエスト
     * @param con DB Connection
     * @return 使用中の連携APIが存在しない or 論理削除済みの場合：rng090へのActionForward, それ以外：null
     * @throws IOToolsException
     * @throws IntrospectionException
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private ActionForward __immigration(
        ActionMapping map, Rng310Form form,
        HttpServletRequest req, Connection con)
        throws SQLException, IOToolsException, IllegalAccessException,
        InvocationTargetException, NoSuchMethodException, IntrospectionException {

        int cacSid = -1;
        RequestModel reqMdl = getRequestModel(req);
        if (form.getRng090SelectActionIndex() == -1) {
            //追加状態の場合
            cacSid = form.getRng090SelectCacSid();
        } else {
            //既存のものを選択している場合
            RngTemplateActionFileBiz rtpaBiz = new RngTemplateActionFileBiz(reqMdl);
            try {
                AddRngActionModel araMdl =
                    rtpaBiz.getActionModel(form.getRng090SelectActionIndex());
                if (araMdl != null) {
                    cacSid = araMdl.getApiConnectSid();
                }
            } catch (IOToolsException e) {
                return getSubmitErrorPage(map, req);
            }
        }

        CmnApiConnectDao cacDao = new CmnApiConnectDao(con);
        CmnApiConnectModel cacMdl = cacDao.select(cacSid);
        if (cacMdl == null || cacMdl.getCacJkbn() != GSConst.JTKBN_TOROKU) {
            //指定された連携APIが存在しない or 削除済みの場合cmn999画面でrng090へ遷移するメッセージを表示
            Cmn999Form cmn999form = __getErrorForm(map, form, req);
            req.setAttribute("cmn999Form", cmn999form);
            return map.findForward("gf_msg");
        }
        return null;
    }

    /**
     * <br>[機  能] 警告画面のフォームを作成する
     * <br>[解  説]
     * <br>[備  考] 使用中の連携APIが正常の場合、nullを返す
     * @param map ActionMapping
     * @param form ActionForm
     * @param req リクエスト
     * @return 警告画面のフォーム
     * @throws IntrospectionException
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private Cmn999Form __getErrorForm(
        ActionMapping map, Rng310Form form, HttpServletRequest req)
        throws IllegalAccessException,
        InvocationTargetException, NoSuchMethodException, IntrospectionException {

        ActionForward urlForward =  map.findForward("rng090noApi");
        Cmn999Form cmn999form = new Cmn999Form();
        cmn999form.addHiddenAll(form, form.getClass(), "");
        //経路設定系サブフォームをパラメータ化
        Enumeration<String> enumParamName = (Enumeration<String>) req.getParameterNames();
        while (enumParamName.hasMoreElements()) {
            String name = enumParamName.nextElement();
            if (name.startsWith("rng090keiro.")) {
                Object prop = null;
                try {
                    prop = PropertyUtils.getProperty(form, name);
                } catch (NoSuchMethodException e) {
                    continue;
                }
                if (prop == null) {
                    continue;
                }
                if (prop.getClass().isArray()) {
                    //配列型の場合
                    Object[] objs = (Object[]) prop;
                    if (ArrayUtils.isEmpty(objs)) {
                        continue;
                    }
                    String[] arr = new String[objs.length];
                    for (int i = 0; i < arr.length; i++) {
                        if (objs[i] != null) {
                            arr[i] = objs[i].toString();
                        }
                    }
                    cmn999form.addHiddenParam(name, arr);
                } else if (prop.getClass().isAssignableFrom(Collection.class)) {
                    //List型の場合
                    @SuppressWarnings("unchecked")
                    Collection<Object> objList = (Collection<Object>) prop;
                    if (objList != null && objList.size() == 0) {
                        continue;
                    }
                    Object[] objs = objList.toArray();
                    String[] arr = new String[objs.length];
                    for (int i = 0; i < arr.length; i++) {
                        if (objs[i] != null) {
                            arr[i] = objs[i].toString();
                        }
                    }
                    cmn999form.addHiddenParam(name, arr);
                } else {
                    cmn999form.addHiddenParam(name, prop.toString());
                }
            }
        }
        cmn999form.setIcon(Cmn999Form.ICON_WARN);
        cmn999form.setWtarget(Cmn999Form.WTARGET_BODY);
        cmn999form.setType(Cmn999Form.TYPE_OK);
        cmn999form.setUrlOK(urlForward.getPath());

        GsMessage gsMsg = new GsMessage(req);
        String message;
        if (form.getRngTplCmdMode() == RngConst.RNG_CMDMODE_ADD) {
            message = gsMsg.getMessage("rng.api.none.mode.add");
        } else {
            message = gsMsg.getMessage("rng.api.none.mode.edit");
        }
        cmn999form.setMessage(message);

        return cmn999form;
    }

    /**
     * <br>[機  能] 画面を初期描画する。
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng310Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doInit(
                    ActionMapping map,
                    Rng310Form form,
                    HttpServletRequest req,
                    HttpServletResponse res,
                    Connection con) throws Exception {

        if (form.getRng090SelectActionIndex() == -1) {
            //決裁後アクションが未選択の時、リクエストに決裁後アクションモデルがあれば参照する
            if (req.getAttribute("addRngActionModel") != null) {
                AddRngActionModel araModel
                                = (AddRngActionModel) req.getAttribute("addRngActionModel");
                form.setRng090SelectActionIndex(araModel.getIndex());
            }
        }
        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        paramMdl.setParam(form);
        try {
            biz.setInitData(paramMdl);
        } catch (Exception IOToolsException) {
            //決裁後アクション登録用ファイルの読み込みに失敗
            return getSubmitErrorPage(map, req);
        }
        paramMdl.setFormData(form);

        return map.getInputForward();
    }

    /**
     * <br>[機  能] 連携APIの設定を保存する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng310Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @param allSaveFlg true:全て保存 false:名前補完のみ
     * @param forward 遷移先
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doSave(
                    ActionMapping map,
                    Rng310Form form,
                    HttpServletRequest req,
                    HttpServletResponse res,
                    Connection con,
                    boolean allSaveFlg,
                    String forward) throws Exception {

        //OKボタン/アクションパラメータ追加/アクションパラメータ編集時のみ入力チェックを行う。
        if (NullDefault.getString(req.getParameter("CMD"), "").equals("rng310_ok")
            || NullDefault.getString(req.getParameter("CMD"), "").equals("addActionParam")
            || NullDefault.getString(req.getParameter("CMD"), "").equals("editActionParam")) {
            ActionErrors errors = new ActionErrors();
            errors = form.validateCheck(getRequestModel(req), con);
            if (!errors.isEmpty()) {
                addErrors(req, errors);
                return __doInit(map, form, req, res, con);
            }
        }

        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        paramMdl.setParam(form);
        try {
            biz.saveAction(paramMdl, allSaveFlg);
        } catch (Exception IOToolsException) {
            //決裁後アクション登録用ファイルの読み込みに失敗
            return getSubmitErrorPage(map, req);
        }
        paramMdl.setFormData(form);

        return map.findForward(forward);
    }

    /**
     * <br>[機  能] アクションパラメータを追加する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng310Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __addActiomParam(
                    ActionMapping map,
                    Rng310Form form,
                    HttpServletRequest req,
                    HttpServletResponse res,
                    Connection con) throws Exception {

        //アクションパラメータ追加
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        paramMdl.setParam(form);
        AddRngActionParamModel arapModel = new AddRngActionParamModel();
        try {
            arapModel = biz.addActionParam(paramMdl);
        } catch (Exception IOToolsException) {
            //決裁後アクション登録用ファイルの読み込みに失敗
            return getSubmitErrorPage(map, req);
        }
        paramMdl.setFormData(form);

        //次の画面で使用する為、リクエストに追加した決裁後アクションモデルをセットする。
        req.setAttribute("addRngActionParamModel", arapModel);

        return __doSave(map, form, req, res, con, true, "actionParam");
    }

    /**
     * <br>[機  能] フォーム情報を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getFormInfo(
        Rng310Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        paramMdl.setParam(form);
        List<FormCell> formCellList = biz.getFormCellList(paramMdl);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("formCellList", formCellList);
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] 役職情報を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param res HttpServletResponse
     * @param req HttpServletRequest
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getPosInfo(
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("positionList", biz.getPositionList());
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] グループ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param res HttpServletResponse
     * @param req HttpServletRequest
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getGroupList(
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("groupList", biz.getGroupList());
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] ユーザ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param res HttpServletResponse
     * @param req HttpServletRequest
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getUserList(
        Rng310Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        paramMdl.setParam(form);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("userList", biz.getUserList(paramMdl));
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] 実行条件追加 入力チェック
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws SQLException
     * @throws Exception 実行時例外
     */
    public void __checkAddActionParam(
        Rng310Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con)
        throws JsonMappingException, JsonProcessingException, SQLException {

        //入力チェック
        List<String> errorMsgList =
            form.validateCheckForExecuteCondition(getRequestModel(req), con);
        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        if (errorMsgList != null && errorMsgList.size() > 0) {
            jsonData.element("success", false);
            jsonData.element("errorMsgList", errorMsgList);
        } else {
            jsonData.element("success", true);
        }
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] 既存の実行条件を複写
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws SQLException
     * @throws Exception 実行時例外
     */
    public void __copyCondition(
        Rng310Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con)
        throws JsonMappingException, JsonProcessingException, SQLException {

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);

        //複写する実行条件情報を取得
        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        paramMdl.setParam(form);
        try {
            biz.setCopyConditionInfo(paramMdl);
        } catch (IOToolsException e) {
            //決裁後アクション用ファイルの読み込みに失敗
            jsonData.element("success", false);
        }

        //編集後の実行条件をセット
        jsonData.element("paramKbn", paramMdl.getRng310CopyConditionParamKbn());
        jsonData.element("paramValue", paramMdl.getRng310CopyConditionParamValue());
        jsonData.element("compareTarget", paramMdl.getRng310CopyConditionCompareTarget());
        jsonData.element("compareTargetGroupSid",
            paramMdl.getRng310CopyConditionCompareTargetGroupSid());
        jsonData.element("compareType", paramMdl.getRng310CopyConditionCompareType());
        __writeResp(res, jsonData);
    }

    /**
     *
     * <br>[機  能] jsonレスポンスの書き込み処理
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param json jsonオブジェクト
     */
    private void __writeResp(HttpServletResponse res, JSONObject json) {
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(json);
            out.flush();
        } catch (IOException e) {
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * <br>[機  能] アクションパラメータを複写する
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng310Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __copyActionParam(
                    Rng310Form form,
                    HttpServletRequest req,
                    HttpServletResponse res,
                    Connection con) throws Exception {

        //アクションパラメータ複写
        JSONObject jsonData = new JSONObject();
        Rng310ParamModel paramMdl = new Rng310ParamModel();
        Rng310Biz biz = new Rng310Biz(getRequestModel(req), con);
        paramMdl.setParam(form);
        AddRngActionParamModel arapModel = new AddRngActionParamModel();
        try {
            arapModel = biz.copyActionParam(paramMdl);
            jsonData.element("success", true);
            jsonData.element("copyIndex", arapModel.getIndex());
            jsonData.element("copyName", arapModel.getName());
        } catch (Exception IOToolsException) {
            //決裁後アクション登録用ファイルの読み込みに失敗
            jsonData.element("success", false);
        }

        //実行結果をJSON形式で返す
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] アクションパラメータを複写する
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng310Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __checkApiSetting(
                    Rng310Form form,
                    HttpServletRequest req,
                    HttpServletResponse res,
                    Connection con) throws Exception {
        JSONObject jsonData = new JSONObject();
        String errorMsg = form.validateCheckMsg(getRequestModel(req), con);
        if (errorMsg.length() > 0) {
            jsonData.element("success", false);
            jsonData.element("errorMsg", errorMsg);
        } else {
            jsonData.element("success", true);
        }
        //実行結果をJSON形式で返す
        __writeResp(res, jsonData);
    }
}