package jp.groupsession.v2.rng.rng310;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

import org.apache.struts.util.LabelValueBean;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.dao.GroupDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.dao.base.CmnPositionDao;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormBuilder;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.formmodel.GroupComboModel;
import jp.groupsession.v2.cmn.formmodel.SimpleUserSelect;
import jp.groupsession.v2.cmn.formmodel.UserGroupSelectModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnPositionModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.rng.model.RngRapConditionJsonModel;
import jp.groupsession.v2.rng.model.RngRapConditionModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.model.UsrLabelValueBean;

/**
 * <br>[機  能] 連携API登録画面のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng310Biz {

    /** リクエストモデル */
    private RequestModel reqMdl__;
    /** コネクション */
    private Connection con__;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエストモデル
     * @param con コネクション
     */
    public Rng310Biz(RequestModel reqMdl, Connection con) {
        reqMdl__ = reqMdl;
        con__ = con;
    }

    /**
     * <br>[機  能] 初期描画用データをセットする。
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @throws IOToolsException
     */
    public void setInitData(Rng310ParamModel paramMdl) throws SQLException, IOToolsException {

        //選択値の初期化
        paramMdl.setRng310SelectActionParamIndex(-1);

        //決裁後アクション読み込み
        RngTemplateActionFileBiz rtaBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionModel araModel = rtaBiz.getActionModel(
                                                        paramMdl.getRng090SelectActionIndex());
        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        if (araModel != null) {
            //連携API情報
            CmnApiConnectDao cacDao = new CmnApiConnectDao(con__);
            CmnApiConnectModel cacModel = cacDao.select(araModel.getApiConnectSid());
            if (paramMdl.getRng310CacName() == null) {
                paramMdl.setRng310CacName(cacModel.getCacName());
            }
            if (paramMdl.getRng310CacDescription() == null) {
                paramMdl.setRng310CacDescription(cacModel.getCacDescription());
            }

            //API設定
            if (paramMdl.getRng310DspName() == null) {
                paramMdl.setRng310DspName(araModel.getName());
            }
            if (paramMdl.getRng310RepeatKbn() == -1) {
                paramMdl.setRng310RepeatKbn(araModel.getRepeatKbn());
            }

            if (paramMdl.getRng310ActionParamList() == null) {
                //アクションパラメータ
                List<AddRngActionParamModel> arapModelList = rtaBiz.getActionParamModelList(
                                                            paramMdl.getRng090SelectActionIndex());
                //表示用情報を追加
                for (AddRngActionParamModel arapModel : arapModelList) {
                    // 入力状態をチェックして警告アイコン表示区分を設定する
                    rtaBiz.checkActionParam(
                        arapModel, araModel, paramMdl.getRng090templateJSON(), con__);

                    RngRapConditionJsonModel rapConditionJsonMdl
                        = rtaBiz.getConditionJsonModel(
                            paramMdl.getRng090SelectActionIndex(),
                            arapModel.getIndex());

                    if (rapConditionJsonMdl != null) {
                        //エラーが1件以上存在する場合、表示メッセージを切り替える
                        for (RngRapConditionModel condModel
                                            : rapConditionJsonMdl.getConditionList()) {
                            if (condModel.isErrorFlg()) {
                                arapModel.setConditionErrorFlg(true);
                                break;
                            }
                        }
                        if (!arapModel.isConditionErrorFlg()) {
                            //表示用実行条件をセット
                            arapModel.setConditionMessageList(rtpBiz.getConditionStrList(
                                    rapConditionJsonMdl.getConditionList(),
                                    paramMdl.getRng090templateJSON(),
                                    false, reqMdl__, con__));
                            if (arapModel.getConditionJson().get(
                                            "conditionType") instanceof Integer) {
                                arapModel.setConditionKbn(
                                        (Integer) arapModel.getConditionJson().get(
                                                                "conditionType"));
                            } else {
                                arapModel.setConditionKbn(-1);
                            }
                        }
                    }
                }
                //アクションパラメータの並び替えが行われた時
                if (paramMdl.getRng310SortActionParamIndex().length() > 0) {
                    LinkedList<AddRngActionParamModel> sortArapModelList
                                                        = new LinkedList<AddRngActionParamModel>();
                    String[] indexList = paramMdl.getRng310SortActionParamIndex().split(",");
                    for (String index : indexList) {
                        int indexNum = NullDefault.getInt(index, -1);
                        if (indexNum != -1) {
                            AddRngActionParamModel arapModel = arapModelList.stream()
                                                            .filter(m -> m.getIndex() == indexNum)
                                                            .findFirst()
                                                            .orElse(null);
                            if (arapModel != null) {
                                sortArapModelList.addLast(arapModel);
                            }
                        }
                    }
                    arapModelList = sortArapModelList;
                }
                //アクションパラメータの削除が行われた時
                if (paramMdl.getRng310RemoveActionParamIndex() != null
                        && paramMdl.getRng310RemoveActionParamIndex().length > 0) {
                    LinkedList<Integer> indexList = new LinkedList<Integer>();
                    for (String index : paramMdl.getRng310RemoveActionParamIndex()) {
                        int indexNum = NullDefault.getInt(index, -1);
                        if (indexNum != -1) {
                            indexList.add(indexNum);
                        }
                    }
                    LinkedList<AddRngActionParamModel> removeModelList
                                                        = new LinkedList<AddRngActionParamModel>();
                    for (AddRngActionParamModel arapModel : arapModelList) {
                        if (indexList.contains(arapModel.getIndex())) {
                            removeModelList.add(arapModel);
                        }
                    }
                    for (AddRngActionParamModel removeModel : removeModelList) {
                        arapModelList.remove(removeModel);
                    }
                }
                //使用区分を設定する
                if (paramMdl.getRng310ActionParamUseIndexList().length > 0) {
                    List<String> listIndex = Arrays.asList(
                                                paramMdl.getRng310ActionParamUseIndexList());
                    for (AddRngActionParamModel arapModel : arapModelList) {
                        if (listIndex.contains(String.valueOf(arapModel.getIndex()))) {
                            arapModel.setUseKbn(RngConst.API_PARAM_USE);
                        } else {
                            arapModel.setUseKbn(RngConst.API_PARAM_NOT_USE);
                        }
                    }
                }
                paramMdl.setRng310ActionParamList(arapModelList);
            }

            //繰り返し対象要素コンボをセット
            GsMessage gsMsg = new GsMessage(reqMdl__);
            List<LabelValueBean> repeatCombo = new ArrayList<LabelValueBean>();
            repeatCombo.add(new LabelValueBean(gsMsg.getMessage("cmn.select.plz"), "-1"));

            FormBuilder formBuilder = new FormBuilder();
            formBuilder.setFormTable(paramMdl.getRng090templateJSON());
            List<FormCell> formCellList = formBuilder.getFormCellList();
            for (FormCell cell : formCellList) {
                if (cell.getType() == EnumFormModelKbn.blocklist) {
                    repeatCombo.add(
                        new LabelValueBean(
                            cell.getTitle() + " ${" + cell.getFormID() + "}",
                            "P_" + cell.getFormID()));
                } else if (cell.getType() == EnumFormModelKbn.file) {
                    repeatCombo.add(
                        new LabelValueBean(
                            cell.getTitle() + " ${" + cell.getFormID() + "}",
                            "P_" + cell.getFormID()));
                }
            }
            repeatCombo.add(
                new LabelValueBean(
                    gsMsg.getMessage("rng.rng310.69"),
                    String.valueOf(RngConst.API_REPEAT_TYPE_FILE)));
            paramMdl.setRng310RepeatElementCombo(repeatCombo);

            if (paramMdl.getRng310RepeatElement() == null) {
                if (araModel.getRepeatType() == RngConst.API_REPEAT_TYPE_FILE) {
                    paramMdl.setRng310RepeatElement(String.valueOf(araModel.getRepeatType()));
                } else {
                    paramMdl.setRng310RepeatElement("P_" + araModel.getRepeatFormId());
                }
            }

            //既存の実行条件を複写コンボ用データを取得
            paramMdl.setRng310CopyConditionCombo(
                rtpBiz.createCopyConditionCombo(
                    araModel.getActionParamList(),
                    paramMdl.getRng090SelectActionIndex(),
                    paramMdl.getRng310SelectActionParamIndex(),
                    paramMdl.getRng090template(),
                    paramMdl.getRng090templateJSON(),
                    reqMdl__,
                    con__));
        }
    }

    /**
     * <br>[機  能] 決裁後アクション情報を更新する
     * <br>[解  説] 登録用ファイルに情報を書き込む
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @param allSaveFlg true:全て保存 false:名前補完+並び替え反映のみ
     * @throws IOToolsException
     */
    public void saveAction(Rng310ParamModel paramMdl, boolean allSaveFlg)
            throws SQLException, IOToolsException, JsonProcessingException {

        //決裁後アクション情報を取得
        RngTemplateActionFileBiz rtaBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionModel araModel = rtaBiz.getActionModel(
                                                        paramMdl.getRng090SelectActionIndex());
        if (!allSaveFlg) {
            //戻るボタン押下かつ名称が未登録の場合、連携API名称をセットする。
            if (araModel.getName().length() == 0) {
                CmnApiConnectDao cacDao = new CmnApiConnectDao(con__);
                CmnApiConnectModel cacModel = cacDao.select(araModel.getApiConnectSid());
                paramMdl.setRng310DspName(cacModel.getCacName());
                araModel.setName(paramMdl.getRng310DspName());
            }
            //複写によって生成された決裁後アクションを破棄
            if (paramMdl.getRng310CopyIndexList() != null
                    && paramMdl.getRng310CopyIndexList().length > 0) {
                LinkedList<Integer> indexList = new LinkedList<Integer>();
                for (String index : paramMdl.getRng310CopyIndexList()) {
                    int indexNum = NullDefault.getInt(index, -1);
                    if (indexNum != -1) {
                        indexList.add(indexNum);
                    }
                }

                LinkedList<AddRngActionParamModel> arapModelList = araModel.getActionParamList();
                LinkedList<AddRngActionParamModel> removeModelList
                                                        = new LinkedList<AddRngActionParamModel>();
                for (AddRngActionParamModel arapModel : arapModelList) {
                    if (indexList.contains(arapModel.getIndex())) {
                        removeModelList.add(arapModel);
                    }
                }
                for (AddRngActionParamModel removeModel : removeModelList) {
                    arapModelList.remove(removeModel);
                }
                araModel.setActionParamList(arapModelList);
            }
        } else if (allSaveFlg) {
            RngTemplateBiz rtpBiz = new RngTemplateBiz();
            //名称(表示用)
            if (paramMdl.getRng310DspName().length() == 0) {
                //未入力の場合、連携API名称をセットする
                CmnApiConnectDao cacDao = new CmnApiConnectDao(con__);
                CmnApiConnectModel cacModel = cacDao.select(araModel.getApiConnectSid());
                paramMdl.setRng310DspName(cacModel.getCacName());
            }
            araModel.setName(paramMdl.getRng310DspName());

            //繰り返し実行情報をセット
            araModel.setRepeatKbn(paramMdl.getRng310RepeatKbn());
            //行番号の指定を初期化する。
            List<String> bodyList = rtpBiz.getFormCellFromBlockListBody(
                                            paramMdl.getRng090templateJSON())
                                    .stream()
                                    .map(b -> b.getFormID())
                                    .collect(Collectors.toList());
            rtaBiz.initBlockParamIndex(araModel, bodyList, RngConst.API_FORMACTION_INIT_BODY);
            rtaBiz.initConfirmFileParam(araModel, RngConst.API_FORMACTION_INIT_FILE);
            if (paramMdl.getRng310RepeatKbn() == RngConst.API_REPEAT_KBN_ON) {
                if (paramMdl.getRng310RepeatElement().equals(
                    String.valueOf(RngConst.API_REPEAT_TYPE_FILE))) {
                    //確認時添付
                    araModel.setRepeatType(RngConst.API_REPEAT_TYPE_FILE);
                    araModel.setRepeatFormId("");
                    rtaBiz.initConfirmFileParam(araModel, RngConst.API_FORMACTION_INIT_REPEATFILE);
                } else {
                    //フォーム要素
                    araModel.setRepeatType(RngConst.API_REPEAT_TYPE_FORM);
                    if (paramMdl.getRng310RepeatElement().length() > 2) {
                        String formId = paramMdl.getRng310RepeatElement().substring(2);
                        araModel.setRepeatFormId(formId);


                        FormBuilder formBuilder = new FormBuilder();
                        formBuilder.setFormTable(paramMdl.getRng090templateJSON());
                        List<FormCell> cellList = formBuilder.getFormCellList();
                        for (FormCell cell : cellList) {
                            if (cell.getFormID().equals(formId)
                                        && cell.getType() == EnumFormModelKbn.blocklist) {
                                //繰り返し実行の対象となる表要素内のパラメータを使用している場合、行番号の指定を繰り返し対象として初期化する。
                                bodyList = rtpBiz.getFormCellFromBlockListBody(
                                                                formId,
                                                                paramMdl.getRng090templateJSON())
                                                        .stream()
                                                        .map(b -> b.getFormID())
                                                        .collect(Collectors.toList());
                                rtaBiz.initBlockParamIndex(araModel, bodyList,
                                                            RngConst.API_FORMACTION_INIT_OTHER);
                            } else if (cell.getFormID().equals(formId)
                                        && cell.getType() == EnumFormModelKbn.file) {
                                bodyList = new ArrayList<String>();
                                bodyList.add(formId);
                                rtaBiz.initBlockParamIndex(araModel, bodyList,
                                                            RngConst.API_FORMACTION_INIT_OTHER);
                            }
                        }
                    }
                }
            } else {
                araModel.setRepeatType(RngConst.API_REPEAT_TYPE_FORM);
                araModel.setRepeatFormId("");
            }

            //アクションパラメータの並び替えが行われた時、登録用ファイルに反映する
            if (paramMdl.getRng310SortActionParamIndex().length() > 0) {
                LinkedList<AddRngActionParamModel> arapModelList = araModel.getActionParamList();
                LinkedList<AddRngActionParamModel> sortArapModelList
                                                    = new LinkedList<AddRngActionParamModel>();
                String[] indexList = paramMdl.getRng310SortActionParamIndex().split(",");
                for (String index : indexList) {
                    int indexNum = NullDefault.getInt(index, -1);
                    if (indexNum != -1) {
                        AddRngActionParamModel arapModel = arapModelList.stream()
                                                            .filter(m -> m.getIndex() == indexNum)
                                                            .findFirst()
                                                            .orElse(null);
                        if (arapModel != null) {
                            sortArapModelList.addLast(arapModel);
                        }
                    }
                }
                araModel.setActionParamList(sortArapModelList);
            }

            //アクションパラメータの削除が行われた時、登録用ファイルに反映する
            if (paramMdl.getRng310RemoveActionParamIndex() != null
                    && paramMdl.getRng310RemoveActionParamIndex().length > 0) {
                LinkedList<Integer> indexList = new LinkedList<Integer>();
                for (String index : paramMdl.getRng310RemoveActionParamIndex()) {
                    int indexNum = NullDefault.getInt(index, -1);
                    if (indexNum != -1) {
                        indexList.add(indexNum);
                    }
                }

                LinkedList<AddRngActionParamModel> arapModelList = araModel.getActionParamList();
                LinkedList<AddRngActionParamModel> removeModelList
                                                        = new LinkedList<AddRngActionParamModel>();
                for (AddRngActionParamModel arapModel : arapModelList) {
                    if (indexList.contains(arapModel.getIndex())) {
                        removeModelList.add(arapModel);
                    }
                }
                for (AddRngActionParamModel removeModel : removeModelList) {
                    arapModelList.remove(removeModel);
                }
                araModel.setActionParamList(arapModelList);
            }
            //使用区分を設定する
            LinkedList<AddRngActionParamModel> arapModelList = araModel.getActionParamList();
            if (paramMdl.getRng310ActionParamUseIndexList().length > 0) {
                List<String> listIndex = Arrays.asList(paramMdl.getRng310ActionParamUseIndexList());
                for (AddRngActionParamModel arapModel : arapModelList) {
                    //警告があったアクションパラメータは変更しない
                    rtaBiz.checkActionParam(
                        arapModel, araModel, paramMdl.getRng090templateJSON(), con__);
                    if (arapModel.getWarnFlg() == RngConst.ACTIONPARAM_WARN_FLG_NO) {
                        if (listIndex.contains(String.valueOf(arapModel.getIndex()))) {
                            arapModel.setUseKbn(RngConst.API_PARAM_USE);
                        } else {
                            arapModel.setUseKbn(RngConst.API_PARAM_NOT_USE);
                        }
                    }
                }
            } else {
                for (AddRngActionParamModel arapModel : arapModelList) {
                    //警告があったアクションパラメータは変更しない
                    rtaBiz.checkActionParam(
                        arapModel, araModel, paramMdl.getRng090templateJSON(), con__);
                    if (arapModel.getWarnFlg() == RngConst.ACTIONPARAM_WARN_FLG_NO) {
                        arapModel.setUseKbn(RngConst.API_PARAM_NOT_USE);
                    }
                }
            }
        }

        //決裁後アクション更新
        rtaBiz.updateAction(araModel, paramMdl.getRng090SelectActionIndex());
    }
    /**
     *
     * <br>[機  能] アクションパラメータを追加する
     * <br>[解  説] 登録用ファイルに情報を書き込む。
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return 追加した決裁後アクションモデル
     */
    public AddRngActionParamModel addActionParam(Rng310ParamModel paramMdl)
            throws SQLException, IOToolsException, JsonProcessingException {

        RngTemplateActionFileBiz rtaBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionParamModel arapModel = new AddRngActionParamModel();
        arapModel.setName(paramMdl.getRng310ActionParamName());
        arapModel.setUseKbn(RngConst.FLG_USE_ACTIONPARAM);
        arapModel.setConditionJson(new JSONObject());
        arapModel.setParamJson(new JSONObject());
        int actionParamIndex
            = rtaBiz.addActionParam(arapModel, paramMdl.getRng090SelectActionIndex());

        //実行条件JSONモデルを作成
        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        RngRapConditionJsonModel rngRapConditionJsonMdl = new RngRapConditionJsonModel();
        rngRapConditionJsonMdl.setConditionType(paramMdl.getRng310ConditionType());
        rngRapConditionJsonMdl.setConditionList(
            rtpBiz.setFormInfoToCondition(
                paramMdl.getRng310RapConditionMap().values()
                    .stream()
                    .collect(Collectors.toList()),
                paramMdl.getRng090templateJSON()));

        //決裁後アクション用ファイルに書き込み
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        fileBiz.setConditionJsonModel(
            paramMdl.getRng090SelectActionIndex(),
            actionParamIndex,
            rngRapConditionJsonMdl);
        //使用区分:使用で登録するアクションパラメータリストにIndexを追加
        List<String> useIndexList = new ArrayList<String>();
        if (paramMdl.getRng310ActionParamUseIndexList() != null) {
            useIndexList.addAll(Arrays.asList(paramMdl.getRng310ActionParamUseIndexList()));
        }
        useIndexList.add(String.valueOf(actionParamIndex));
        paramMdl.setRng310ActionParamUseIndexList(
                            useIndexList.toArray(new String[useIndexList.size()]));
        return arapModel;
    }
    /**
     *
     * <br>[機  能] アクションパラメータを複写する
     * <br>[解  説] 登録用ファイルに情報を書き込む。
     * <br>[備  考]
     * @param paramMdl パラメータモデル
     * @return 追加した決裁後アクションモデル
     */
    public AddRngActionParamModel copyActionParam(Rng310ParamModel paramMdl)
            throws SQLException, IOToolsException, JsonProcessingException {

        RngTemplateActionFileBiz rtaBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionParamModel arapModel = rtaBiz.getActionParamModel(
            paramMdl.getRng090SelectActionIndex(), paramMdl.getRng310CopyActionParamIndex());

        //新しい名前の設定
        GsMessage gsMsg = new GsMessage(reqMdl__);
        String newName = arapModel.getName() + "_" + gsMsg.getMessage("cmn.copy");
        int maxNum = 1;
        List<AddRngActionParamModel> arapModelList
                = rtaBiz.getActionParamModelList(paramMdl.getRng090SelectActionIndex());
        for (AddRngActionParamModel searchArapModel : arapModelList) {
            if (searchArapModel.getName().contains(newName)) {
                int checkNum = NullDefault.getInt(
                                    searchArapModel.getName().substring(newName.length()), -1);
                if (checkNum == maxNum) {
                    maxNum++;
                } else if (checkNum > maxNum) {
                    maxNum = checkNum + 1;
                }
            }
        }
        arapModel.setName(newName + String.valueOf(maxNum));
        if (paramMdl.getRng310CopyActionParamUseKbn() != -1) {
            arapModel.setUseKbn(paramMdl.getRng310CopyActionParamUseKbn());
        }
        rtaBiz.addActionParam(arapModel, paramMdl.getRng090SelectActionIndex());
        return arapModel;
    }

    /**
     * <br>[機  能] フォーム情報リストを取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @return フォーム要素リスト
     * @throws SQLException
     */
    public List<FormCell> getFormCellList(Rng310ParamModel paramMdl) {

        FormBuilder formBuilder = new FormBuilder();
        formBuilder.setFormTable(paramMdl.getRng090templateJSON());
        List<FormCell> formList = formBuilder.getFormCellList();
        return formList;
    }

    /**
     * <br>[機  能] 役職情報リストを取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 役職情報リスト
     * @throws SQLException
     */
    public List<CmnPositionModel> getPositionList() throws SQLException {

        CmnPositionDao cpsDao = new CmnPositionDao(con__);
        List <CmnPositionModel> posMdlList = cpsDao.getPosList(true);
        return posMdlList;
    }

    /**
     * <br>[機  能] グループ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @return グループ一覧
     * @throws SQLException
     */
    public List<LabelValueBean> getGroupList() throws SQLException {

        GroupBiz grpBiz = new GroupBiz();
        return grpBiz.getGroupCombLabelList(con__, false, null);
    }

    /**
     * <br>[機  能] ユーザ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @return ユーザ一覧
     * @throws SQLException
     */
    public List<UsrLabelValueBean> getUserList(Rng310ParamModel paramMdl) throws SQLException {

        UserBiz usrBiz = new UserBiz();
        return usrBiz.getNormalUserLabelList(
            con__, paramMdl.getRng310SelectGroupSid(), null, false, null);
    }

    /**
     * <br>[機  能] 実行条件を書き込み
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws IOToolsException
     * @throws SQLException
     */
    public void writeCondition(
        Rng310ParamModel paramMdl)
        throws JsonMappingException, JsonProcessingException, IOToolsException, SQLException {

        //実行条件JSONモデルを作成
        RngRapConditionJsonModel rngRapConditionJsonMdl = new RngRapConditionJsonModel();
        rngRapConditionJsonMdl.setConditionType(paramMdl.getRng310ConditionType());
        rngRapConditionJsonMdl.setConditionList(
            paramMdl.getRng310RapConditionMap().values().stream().collect(Collectors.toList()));

        //決裁後アクション用ファイルに書き込み
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        fileBiz.setConditionJsonModel(
            paramMdl.getRng090SelectActionIndex(),
            paramMdl.getRng310SelectActionParamIndex(),
            rngRapConditionJsonMdl);
    }

    /**
     * <br>[機  能] 実行条件を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @return 実行条件リスト
     * @throws IOToolsException
     * @throws SQLException
     */
    public List<String> getConditionList(
        Rng310ParamModel paramMdl) throws IOToolsException, SQLException {

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        List<String> ret = new ArrayList<String>();

        //実行条件を取得
        RngRapConditionJsonModel rapConditionJsonMdl
        = fileBiz.getConditionJsonModel(
            paramMdl.getRng090SelectActionIndex(),
            paramMdl.getRng310SelectActionParamIndex());

        if (rapConditionJsonMdl != null) {
            //表示用実行条件をセット
            ret = rtpBiz.getConditionStrList(
                    rapConditionJsonMdl.getConditionList(),
                    paramMdl.getRng090templateJSON(),
                    false, reqMdl__, con__);
        }
        return ret;
    }

    /**
     * <br>[機  能] 複写する実行条件の設定値をセット
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng310ParamModel
     * @throws IOToolsException
     * @throws SQLException
     */
    public void setCopyConditionInfo(
        Rng310ParamModel paramMdl) throws IOToolsException, SQLException {

        int index = paramMdl.getRng310CopyCondition().indexOf(".");
        int actionMdlIndex
            = NullDefault.getInt(paramMdl.getRng310CopyCondition().substring(0, index), -1);
        int actionParamMdlIndex
            = NullDefault.getInt(paramMdl.getRng310CopyCondition().substring(index + 1), -1);

        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        RngRapConditionJsonModel rapConditionJsonMdl
            = fileBiz.getConditionJsonModel(paramMdl.getRng090SelectActionIndex(), actionMdlIndex);
        if (rapConditionJsonMdl != null) {
            int rapConditionIndex = 0;
            for (RngRapConditionModel rapConditionMdl : rapConditionJsonMdl.getConditionList()) {
                if (rapConditionIndex == actionParamMdlIndex) {
                    if (rapConditionMdl.getParamKbn() != RngConst.API_PARAMKBN_FORM) {
                        //フォーム要素以外
                        if (rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_ADDUSER
                            || rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_LETUSER) {
                            //申請者/最終承認者の場合、比較対象のユーザ名をセット
                            __setGroupInfo(rapConditionMdl);
                        }
                        paramMdl.setRng310CopyConditionParamKbn(
                            String.valueOf(rapConditionMdl.getParamKbn()));
                    } else {
                        //フォーム要素
                        FormBuilder formBuilder = new FormBuilder();
                        formBuilder.setFormTable(paramMdl.getRng090templateJSON());
                        List<FormCell> cellList = formBuilder.getFormCellList();

                        for (FormCell cell : cellList) {
                            if (cell.getFormID().equals(rapConditionMdl.getParamFormId())) {
                                if (cell.getType() == EnumFormModelKbn.user) {
                                    //ユーザ選択の場合、比較対象のユーザ名をセット
                                    __setGroupInfo(rapConditionMdl);
                                }

                                //フォーム要素タイプをセット
                                if ((cell.getType() == EnumFormModelKbn.user
                                    && ((SimpleUserSelect) cell.getBody()).getMultiFlg()
                                        == UserGroupSelectModel.FLG_MULTI_ON)
                                    || (cell.getType() == EnumFormModelKbn.group
                                        && ((GroupComboModel) cell.getBody()).getMultiFlg()
                                        == UserGroupSelectModel.FLG_MULTI_ON)) {
                                    //ユーザ選択（複数）/グループ選択（複数）
                                    rapConditionMdl.setParamFormTypeStr(
                                        "M" + cell.getType().toString());

                                } else if (cell.getType() == EnumFormModelKbn.check) {
                                    //チェックボックス
                                    rapConditionMdl.setParamFormTypeStr(
                                        "M" + cell.getType().toString());
                                } else {
                                    rapConditionMdl.setParamFormTypeStr(cell.getType().toString());
                                }
                                break;
                            }
                        }
                        paramMdl.setRng310CopyConditionParamKbn(
                            rapConditionMdl.getParamFormTypeStr()
                            + "." + String.valueOf(rapConditionMdl.getParamFormId()));
                    }
                    paramMdl.setRng310CopyConditionParamValue(rapConditionMdl.getParamValue());
                    paramMdl.setRng310CopyConditionCompareTarget(
                        rapConditionMdl.getCompareTarget());
                    paramMdl.setRng310CopyConditionCompareTargetGroupSid(
                        rapConditionMdl.getCompareTargetGroupSid());
                    paramMdl.setRng310CopyConditionCompareType(rapConditionMdl.getCompareType());
                    break;
                }
                rapConditionIndex++;
            }
        }
    }

    /**
     * <br>[機  能] 実行条件の比較文字列に紐づくグループ情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param rapConditionMdl RngRapConditionModel
     * @throws SQLException
     */
    private void __setGroupInfo(RngRapConditionModel rapConditionMdl) throws SQLException {

        GroupDao grpDao = new GroupDao(con__);
        CmnGroupmModel grpMdl
            = grpDao.getDefaultGroup(
                NullDefault.getInt(rapConditionMdl.getCompareTarget(), -1));
        if (grpMdl != null) {
            rapConditionMdl.setCompareTargetGroupSid(grpMdl.getGrpSid());
        }
    }
}