package jp.groupsession.v2.rng.rng310;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.util.LabelValueBean;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.ValidateUtil;
import jp.groupsession.v2.cmn.GSValidateUtil;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormBuilder;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RngValidate;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.rng.model.RngRapConditionJsonModel;
import jp.groupsession.v2.rng.model.RngRapConditionModel;
import jp.groupsession.v2.rng.rng090.Rng090Form;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 連携API登録画面のフォームクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng310Form extends Rng090Form {

    /** 連携APISID */
    private int rng310CacSid__ = 0;
    /** 連携API名 */
    private String rng310CacName__ = null;
    /** 連携API説明 */
    private String rng310CacDescription__ = null;
    /** API設定 名称（表示用） */
    private String rng310DspName__ = null;
    /** API設定 繰り返し実行区分 */
    private int rng310RepeatKbn__ = -1;
    /** API設定 繰り返し対象要素*/
    private String rng310RepeatElement__ = null;
    /** API設定 繰り返し対象要素コンボ */
    private List<LabelValueBean> rng310RepeatElementCombo__ = null;
    /** アクションパラメータリスト */
    private List<AddRngActionParamModel> rng310ActionParamList__ = null;
    /** 実行条件タイプ */
    private int rng310ConditionType__ = 0;
    /** 実行条件リスト */
    private TreeMap<Integer, RngRapConditionModel> rng310RapConditionMap__ = new TreeMap<>();
    /** 選択グループSID */
    private int rng310SelectGroupSid__ = -1;
    /** アクションパラメータ名 */
    private String rng310ActionParamName__ = null;
    /** 選択決裁後アクションIndex */
    private int rng310SelectActionParamIndex__ = -1;
    /** アクションパラメータIndex並び順 */
    private String rng310SortActionParamIndex__ = "";
    /** アクションパラメータ削除済みリスト */
    private String[] rng310RemoveActionParamIndex__;
    /** 既存の実行条件を複写コンボ */
    private List<LabelValueBean> rng310CopyConditionCombo__ = null;
    /** 既存の実行条件を複写選択値 */
    private String rng310CopyCondition__ = null;
    /** 複写する実行条件の設定値区分 */
    private String rng310CopyConditionParamKbn__ = null;
    /** 複写する実行条件の設定値詳細 */
    private int rng310CopyConditionParamValue__ = 0;
    /** 複写する実行条件の比較対象 */
    private String rng310CopyConditionCompareTarget__ = null;
    /** 複写する実行条件の比較条件 */
    private int rng310CopyConditionCompareType__ = 0;
    /** 複写する実行条件の比較対象グループSID */
    private int rng310CopyConditionCompareTargetGroupSid__ = 0;
    /** アクションパラメータ使用区分リスト */
    private String[] rng310ActionParamUseIndexList__;
    /** 複写元アクションパラメータIndex */
    private int rng310CopyActionParamIndex__ = -1;
    /** 複写元アクションパラメータ使用区分 */
    private int rng310CopyActionParamUseKbn__ = -1;
    /** 複写したアクションパラメータIndexリスト */
    private String[] rng310CopyIndexList__;

    /**
     * <p>getRng310RapCondition[index] を取得します。
     * @param index 添字
     * @return getRng310RapCondition[index]
     */
    public RngRapConditionModel getRng310RapCondition(int index) {
        if (!rng310RapConditionMap__.containsKey(index)) {
            rng310RapConditionMap__.put(index, new RngRapConditionModel());
        }
        return rng310RapConditionMap__.get(index);
    }
    /**
     * @return the rng310CacName
     */
    public String getRng310CacName() {
        return rng310CacName__;
    }
    /**
     * @param rng310CacName the rng310CacName to set
     */
    public void setRng310CacName(String rng310CacName) {
        rng310CacName__ = rng310CacName;
    }
    /**
     * @return the rng310CacDescription
     */
    public String getRng310CacDescription() {
        return rng310CacDescription__;
    }
    /**
     * @param rng310CacDescription the rng310CacDescription to set
     */
    public void setRng310CacDescription(String rng310CacDescription) {
        rng310CacDescription__ = rng310CacDescription;
    }
    /**
     * @return the rng310DspName
     */
    public String getRng310DspName() {
        return rng310DspName__;
    }
    /**
     * @param rng310DspName the rng310DspName to set
     */
    public void setRng310DspName(String rng310DspName) {
        rng310DspName__ = rng310DspName;
    }
    /**
     * @return the rng310RepeatKbn
     */
    public int getRng310RepeatKbn() {
        return rng310RepeatKbn__;
    }
    /**
     * @param rng310RepeatKbn the rng310RepeatKbn to set
     */
    public void setRng310RepeatKbn(int rng310RepeatKbn) {
        rng310RepeatKbn__ = rng310RepeatKbn;
    }
    /**
     * @return the rng310RepeatElementCombo
     */
    public List<LabelValueBean> getRng310RepeatElementCombo() {
        return rng310RepeatElementCombo__;
    }
    /**
     * @param rng310RepeatElementCombo the rng310RepeatElementCombo to set
     */
    public void setRng310RepeatElementCombo(
            List<LabelValueBean> rng310RepeatElementCombo) {
        rng310RepeatElementCombo__ = rng310RepeatElementCombo;
    }
    /**
     * @return the rng310RepeatElement
     */
    public String getRng310RepeatElement() {
        return rng310RepeatElement__;
    }
    /**
     * @param rng310RepeatElement the rng310RepeatElement to set
     */
    public void setRng310RepeatElement(String rng310RepeatElement) {
        rng310RepeatElement__ = rng310RepeatElement;
    }
    /**
     * @return the rng310ActionParamList
     */
    public List<AddRngActionParamModel> getRng310ActionParamList() {
        return rng310ActionParamList__;
    }
    /**
     * @param rng310ActionParamList the rng310ActionParamList to set
     */
    public void setRng310ActionParamList(
            List<AddRngActionParamModel> rng310ActionParamList) {
        rng310ActionParamList__ = rng310ActionParamList;
    }
    /**
     * @return the rng310CacSid
     */
    public int getRng310CacSid() {
        return rng310CacSid__;
    }
    /**
     * @param rng310CacSid the rng310CacSid to set
     */
    public void setRng310CacSid(int rng310CacSid) {
        rng310CacSid__ = rng310CacSid;
    }
    /**
     * @return the rng310RapConditionMap
     */
    public TreeMap<Integer, RngRapConditionModel> getRng310RapConditionMap() {
        return rng310RapConditionMap__;
    }
    /**
     * @param rng310RapConditionMap the rng310RapConditionMap to set
     */
    public void setRng310RapConditionMap(
            TreeMap<Integer, RngRapConditionModel> rng310RapConditionMap) {
        rng310RapConditionMap__ = rng310RapConditionMap;
    }
    /**
     * @return the rng310ConditionType
     */
    public int getRng310ConditionType() {
        return rng310ConditionType__;
    }
    /**
     * @param rng310ConditionType the rng310ConditionType to set
     */
    public void setRng310ConditionType(int rng310ConditionType) {
        rng310ConditionType__ = rng310ConditionType;
    }
    /**
     * @return the rng310SelectGroupSid
     */
    public int getRng310SelectGroupSid() {
        return rng310SelectGroupSid__;
    }
    /**
     * @param rng310SelectGroupSid the rng310SelectGroupSid to set
     */
    public void setRng310SelectGroupSid(int rng310SelectGroupSid) {
        rng310SelectGroupSid__ = rng310SelectGroupSid;
    }
    /**
     * @return the rng310ActionParamName
     */
    public String getRng310ActionParamName() {
        return rng310ActionParamName__;
    }
    /**
     * @param rng310ActionParamName the rng310ActionParamName to set
     */
    public void setRng310ActionParamName(String rng310ActionParamName) {
        rng310ActionParamName__ = rng310ActionParamName;
    }
    /**
     * @return the rng310SelectActionParamIndex
     */
    public int getRng310SelectActionParamIndex() {
        return rng310SelectActionParamIndex__;
    }
    /**
     * @param rng310SelectActionParamIndex the rng310SelectActionParamIndex to set
     */
    public void setRng310SelectActionParamIndex(int rng310SelectActionParamIndex) {
        rng310SelectActionParamIndex__ = rng310SelectActionParamIndex;
    }
    /**
     * @return the rng310SortActionParamIndex
     */
    public String getRng310SortActionParamIndex() {
        return rng310SortActionParamIndex__;
    }
    /**
     * @param rng310SortActionParamIndex the rng310SortActionParamIndex to set
     */
    public void setRng310SortActionParamIndex(String rng310SortActionParamIndex) {
        rng310SortActionParamIndex__ = rng310SortActionParamIndex;
    }
    /**
     * @return the rng310RemoveActionParamIndex
     */
    public String[] getRng310RemoveActionParamIndex() {
        return rng310RemoveActionParamIndex__;
    }
    /**
     * @param rng310RemoveActionParamIndex the rng310RemoveActionParamIndex to set
     */
    public void setRng310RemoveActionParamIndex(String[] rng310RemoveActionParamIndex) {
        rng310RemoveActionParamIndex__ = rng310RemoveActionParamIndex;
    }
    /**
     * @return the rng310CopyConditionCombo
     */
    public List<LabelValueBean> getRng310CopyConditionCombo() {
        return rng310CopyConditionCombo__;
    }
    /**
     * @param rng310CopyConditionCombo the rng310CopyConditionCombo to set
     */
    public void setRng310CopyConditionCombo(
            List<LabelValueBean> rng310CopyConditionCombo) {
        rng310CopyConditionCombo__ = rng310CopyConditionCombo;
    }
    /**
     * @return the rng310CopyCondition
     */
    public String getRng310CopyCondition() {
        return rng310CopyCondition__;
    }
    /**
     * @param rng310CopyCondition the rng310CopyCondition to set
     */
    public void setRng310CopyCondition(String rng310CopyCondition) {
        rng310CopyCondition__ = rng310CopyCondition;
    }
    /**
     * @return the rng310CopyConditionParamKbn
     */
    public String getRng310CopyConditionParamKbn() {
        return rng310CopyConditionParamKbn__;
    }
    /**
     * @param rng310CopyConditionParamKbn the rng310CopyConditionParamKbn to set
     */
    public void setRng310CopyConditionParamKbn(String rng310CopyConditionParamKbn) {
        rng310CopyConditionParamKbn__ = rng310CopyConditionParamKbn;
    }
    /**
     * @return the rng310CopyConditionParamValue
     */
    public int getRng310CopyConditionParamValue() {
        return rng310CopyConditionParamValue__;
    }
    /**
     * @param rng310CopyConditionParamValue the rng310CopyConditionParamValue to set
     */
    public void setRng310CopyConditionParamValue(
            int rng310CopyConditionParamValue) {
        rng310CopyConditionParamValue__ = rng310CopyConditionParamValue;
    }
    /**
     * @return the rng310CopyConditionCompareTarget
     */
    public String getRng310CopyConditionCompareTarget() {
        return rng310CopyConditionCompareTarget__;
    }
    /**
     * @param rng310CopyConditionCompareTarget the rng310CopyConditionCompareTarget to set
     */
    public void setRng310CopyConditionCompareTarget(
            String rng310CopyConditionCompareTarget) {
        rng310CopyConditionCompareTarget__ = rng310CopyConditionCompareTarget;
    }
    /**
     * @return the rng310CopyConditionCompareType
     */
    public int getRng310CopyConditionCompareType() {
        return rng310CopyConditionCompareType__;
    }
    /**
     * @param rng310CopyConditionCompareType the rng310CopyConditionCompareType to set
     */
    public void setRng310CopyConditionCompareType(
            int rng310CopyConditionCompareType) {
        rng310CopyConditionCompareType__ = rng310CopyConditionCompareType;
    }
    /**
     * @return the rng310CopyConditionCompareTargetGroupSid
     */
    public int getRng310CopyConditionCompareTargetGroupSid() {
        return rng310CopyConditionCompareTargetGroupSid__;
    }
    /**
     * @param rng310CopyConditionCompareTargetGroupSid
     * the rng310CopyConditionCompareTargetGroupSid to set
     */
    public void setRng310CopyConditionCompareTargetGroupSid(
            int rng310CopyConditionCompareTargetGroupSid) {
        rng310CopyConditionCompareTargetGroupSid__ = rng310CopyConditionCompareTargetGroupSid;
    }
    /**
     * @return the rng310ActionParamUseIndexList
     */
    public String[] getRng310ActionParamUseIndexList() {
        return rng310ActionParamUseIndexList__;
    }
    /**
     * @param rng310ActionParamUseIndexList the rng310ActionParamUseIndexList to set
     */
    public void setRng310ActionParamUseIndexList(
        String[] rng310ActionParamUseIndexList) {
        rng310ActionParamUseIndexList__ = rng310ActionParamUseIndexList;
    }
    /**
     * @return the rng310CopyActionParamIndex
     */
    public int getRng310CopyActionParamIndex() {
        return rng310CopyActionParamIndex__;
    }
    /**
     * @param rng310CopyActionParamIndex the rng310CopyActionParamIndex to set
     */
    public void setRng310CopyActionParamIndex(int rng310CopyActionParamIndex) {
        rng310CopyActionParamIndex__ = rng310CopyActionParamIndex;
    }
    /**
     * @return the rng310CopyActionParamUseKbn
     */
    public int getRng310CopyActionParamUseKbn() {
        return rng310CopyActionParamUseKbn__;
    }
    /**
     * @param rng310CopyActionParamUseKbn the rng310CopyActionParamUseKbn to set
     */
    public void setRng310CopyActionParamUseKbn(int rng310CopyActionParamUseKbn) {
        rng310CopyActionParamUseKbn__ = rng310CopyActionParamUseKbn;
    }
    /**
     * @return the rng310CopyIndexList
     */
    public String[] getRng310CopyIndexList() {
        return rng310CopyIndexList__;
    }
    /**
     * @param rng310CopyIndexList the rng310CopyIndexList to set
     */
    public void setRng310CopyIndexList(String[] rng310CopyIndexList) {
        rng310CopyIndexList__ = rng310CopyIndexList;
    }

    /**
     * <br>[機  能] アクションパラメータ（実行条件）の入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエストモデル
     * @param con コネクション
     * @return エラーメッセージリスト
     * @throws SQLException
     */
    public List<String> validateCheckForExecuteCondition(
        RequestModel reqMdl,
        Connection con) throws SQLException {

        List<String> errors = new ArrayList<String>();
        GsMessage gsMsg = new GsMessage(reqMdl);
        //アクションパラメータ名
        if (StringUtil.isNullZeroString(rng310ActionParamName__)) {
            //スペースのみチェック
            errors.add(gsMsg.getMessage("cmn.plz.input",
                            new String[] {gsMsg.getMessage("cmn.name5")}));
        } else if (ValidateUtil.isSpace(rng310ActionParamName__)) {
            //スペースのみチェック
            errors.add(gsMsg.getMessage("cmn.error.space.only",
                            new String[] {gsMsg.getMessage("cmn.name5")}));
        } else if (ValidateUtil.isSpaceStart(rng310ActionParamName__)) {
            //先頭スペースチェック
            errors.add(gsMsg.getMessage("cmn.error.space.start",
                            new String[] {gsMsg.getMessage("cmn.name5")}));
        } else if (ValidateUtil.isTab(rng310ActionParamName__)) {
            //タブスペースチェック
            errors.add(gsMsg.getMessage("cmn.error.tab",
                            new String[] {gsMsg.getMessage("cmn.name5")}));
        } else if (rng310ActionParamName__.length() > 100) {
            //MAX桁チェック
            errors.add(gsMsg.getMessage("cmn.plz.max",
                            new String[] {gsMsg.getMessage("cmn.name5"), "100"}));
        } else if (!GSValidateUtil.isGsJapaneaseStringTextArea(rng310ActionParamName__)) {
            //利用不可能な文字を入力した場合
            String nstr = GSValidateUtil.getNotGsJapaneaseStringTextArea(rng310ActionParamName__);
            errors.add(gsMsg.getMessage("cmn.plz.input.available",
                            new String[] {gsMsg.getMessage("cmn.name5"), nstr}));
        }

        //実行条件
        RngValidate rngValidate = new RngValidate(gsMsg);
        RngRapConditionJsonModel conditionJsonMdl = new RngRapConditionJsonModel();
        conditionJsonMdl.setConditionType(rng310ConditionType__);
        conditionJsonMdl.setConditionList(
            getRng310RapConditionMap().values().stream().collect(Collectors.toList()));
        errors = rngValidate.validateCondition(
            errors, conditionJsonMdl, getRng090templateJSON(), con, reqMdl);
        return errors
            .stream()
            .distinct()
            .collect(Collectors.toList());
    }

    /**
     * <br>[機  能] 入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @return errors エラー
     * @throws SQLException SQL実行時例外
     */
    public ActionErrors validateCheck(RequestModel reqMdl, Connection con) throws SQLException {
        ActionErrors errors = new ActionErrors();
        GsMessage gsMsg = new GsMessage(reqMdl);

        //名称（表示用）
        errors = RngValidate.validateCmnFieldText(
                        errors,
                        gsMsg.getMessage("rng.rng310.3"),
                        rng310DspName__,
                        "rng310DspName__",
                        100,
                        false);

        //繰り返し実行
        if (getRng310RepeatKbn() != RngConst.API_REPEAT_KBN_OFF
                        && getRng310RepeatKbn() != RngConst.API_REPEAT_KBN_ON) {
            ActionMessage acmsg = new ActionMessage("error.select.required.text",
                    gsMsg.getMessage("rng.rng310.4"));
            errors.add("error.select.required.text", acmsg);
        }

        //繰り返し実行 対象となる要素
        if (getRng310RepeatKbn() == 1) {
            if (getRng310RepeatElement().equals("-1")) {
                //選択して下さい
                ActionMessage acmsg = new ActionMessage("error.select.required.text",
                gsMsg.getMessage("rng.rng310.4") + "_" + gsMsg.getMessage("rng.rng310.7"));
                errors.add("error.select.required.text", acmsg);
            } else if (!getRng310RepeatElement().equals("1")) {
                boolean existFlg = false;
                //選択した値が申請内容の時、存在チェック
                FormBuilder formBuilder = new FormBuilder();
                formBuilder.setFormTable(getRng090templateJSON());
                List<FormCell> formCellList = formBuilder.getFormCellList();
                for (FormCell cell : formCellList) {
                    if (cell.getType() == EnumFormModelKbn.blocklist
                                    || cell.getType() == EnumFormModelKbn.file) {
                        if (getRng310RepeatElement().equals("P_" + cell.getFormID())) {
                            existFlg = true;
                            break;
                        }
                    }
                }
                if (!existFlg) {
                    //選択した申請内容が存在しないエラー
                    ActionMessage acmsg = new ActionMessage("error.nothing.selected",
                    gsMsg.getMessage("rng.rng310.4") + "_" + gsMsg.getMessage("rng.rng310.7"));
                    errors.add("error.nothing.selected", acmsg);
                }
            }
        }
        return errors;
    }

    /**
     * <br>[機  能] 入力チェックを行う
     * <br>[解  説] 結果を文字列で返す
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @return errors エラー
     * @throws SQLException SQL実行時例外
     */
    public String validateCheckMsg(RequestModel reqMdl, Connection con) throws SQLException {
        String errorMsg = "";
        GsMessage gsMsg = new GsMessage(reqMdl);

        //名称（表示用）
        if (!StringUtil.isNullZeroString(rng310DspName__)) {
            if (ValidateUtil.isSpace(rng310DspName__)) {
                //スペースのみチェック
                errorMsg += "<br>" + gsMsg.getMessage("cmn.error.space.only",
                new String[] {gsMsg.getMessage("rng.rng310.3")});
            } else if (ValidateUtil.isSpaceStart(rng310DspName__)) {
                //先頭スペースチェック
                errorMsg += "<br>" + gsMsg.getMessage("cmn.error.space.start",
                new String[] {gsMsg.getMessage("rng.rng310.3")});
            } else if (ValidateUtil.isTab(rng310DspName__)) {
                //タブスペースチェック
                errorMsg += "<br>" + gsMsg.getMessage("cmn.error.tab",
                new String[] {gsMsg.getMessage("rng.rng310.3")});
            } else if (rng310DspName__.length() > 100) {
                //MAX桁チェック
                errorMsg += "<br>" + gsMsg.getMessage("cmn.plz.max",
                new String[] {gsMsg.getMessage("rng.rng310.3"), "100"});
            } else if (!GSValidateUtil.isGsJapaneaseStringTextArea(rng310DspName__)) {
                //利用不可能な文字を入力した場合
                String nstr = GSValidateUtil.getNotGsJapaneaseStringTextArea(rng310DspName__);
                errorMsg += "<br>" + gsMsg.getMessage("cmn.plz.input.available",
                            new String[] {gsMsg.getMessage("rng.rng310.3"), nstr});

            }
        }

        //繰り返し実行
        if (getRng310RepeatKbn() != RngConst.API_REPEAT_KBN_OFF
                        && getRng310RepeatKbn() != RngConst.API_REPEAT_KBN_ON) {
            errorMsg += "<br>" + gsMsg.getMessage("cmn.plz.specify",
                    new String[] {gsMsg.getMessage("rng.rng310.4")});
        }

        //繰り返し実行 対象となる要素
        if (getRng310RepeatKbn() == 1) {
            if (getRng310RepeatElement().equals("-1")) {
                //選択して下さい
                errorMsg += "<br>" + gsMsg.getMessage("cmn.select.4",
                        new String[] {gsMsg.getMessage("rng.rng310.4")
                                            + "_" + gsMsg.getMessage("rng.rng310.7")});
            } else if (!getRng310RepeatElement().equals("1")) {
                boolean existFlg = false;
                //選択した値が申請内容の時、存在チェック
                FormBuilder formBuilder = new FormBuilder();
                formBuilder.setFormTable(getRng090templateJSON());
                List<FormCell> formCellList = formBuilder.getFormCellList();
                for (FormCell cell : formCellList) {
                    if (cell.getType() == EnumFormModelKbn.blocklist
                                    || cell.getType() == EnumFormModelKbn.file) {
                        if (getRng310RepeatElement().equals("P_" + cell.getFormID())) {
                            existFlg = true;
                            break;
                        }
                    }
                }
                if (!existFlg) {
                    //選択した申請内容が存在しないエラー
                    errorMsg += "<br>" + gsMsg.getMessage("cmn.error.selected.notfound",
                                new String[] {gsMsg.getMessage("rng.rng310.4")
                                    + "_" + gsMsg.getMessage("rng.rng310.7")});
                }
            }
        }
        if (errorMsg.length() > 0) {
            errorMsg = gsMsg.getMessage("rng.rng310.72") + "<br>" + errorMsg;
        }
        return errorMsg;
    }
}