package jp.groupsession.v2.rng.rng320;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.json.JSONObject;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.cmn999.Cmn999Form;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.rng.AbstractRingiTemplateAction;
import jp.groupsession.v2.rng.RngCategoriCantAccessException;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RtpNotfoundException;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.rng.model.RngRapConditionJsonModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.rng090.Rng090Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] アクションパラメータ登録/編集画面のアクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng320Action extends AbstractRingiTemplateAction {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Rng320Action.class);

    /**
    * <br>[機  能] アクション実行前の事前処理 アクセス制限を行う
    * <br>[解  説]
    * <br>[備  考]
    * @param map ActionMapping
    * @param form ActionForm
    * @param req HttpServletRequest
    * @param con DB Connection
    * @return ActionForward
    * @throws Exception 実行時例外
    */
    private ActionForward __immigration(
        ActionMapping map,
        Rng320Form form,
        HttpServletRequest req,
        Connection con) throws Exception {

        RequestModel reqMdl = getRequestModel(req);
        GsMessage gsMsg = new GsMessage(reqMdl);
        CommonBiz cmnBiz = new CommonBiz();
        boolean adminUser = cmnBiz.isPluginAdmin(con, reqMdl.getSmodel(), getPluginId());

        //個人テンプレートまたはv472以前の共有テンプレートの場合、アクセス不可
        if (form.getRngTemplateMode() == RngConst.RNG_TEMPLATE_PRIVATE
            || form.getRng090rtpSpecVer() == RngConst.RNG_RTP_SPEC_VER_INIT) {
            return getSubmitErrorPage(map, req);
        }

        //エラー画面用hidden設定
        ActionForward backForward =  map.findForward("rng010");
        Cmn999Form cmn999form = new Cmn999Form();
        cmn999form.addHiddenAll(form, form.getClass(), "");

        //カテゴリアクセス権限例外用のエラー場面設定を用意
        RngCategoriCantAccessException rcaException = new RngCategoriCantAccessException();
        rcaException.setSeigenKbn(RngCategoriCantAccessException.SEIGEN_KBN_AUTH);
        rcaException.setCantActionStr(gsMsg.getMessage("cmn.edit"));
        ActionForward authError
            = getCatchExceptionPage(map, req, rcaException, backForward, cmn999form);

        //カテゴリアクセス権限チェック
        Rng090Biz rng090Biz = new Rng090Biz(con, reqMdl);
        if (!rng090Biz.categoriAuthChk(
            form.getRngTemplateMode(), form.getRng090CatSid(), adminUser)) {
            return authError;
        }

        //編集時
        if (form.getRngCmdMode() == RngConst.RNG_CMDMODE_EDIT) {
            //テンプレート存在チェック
            RngTemplateBiz rtBiz = new RngTemplateBiz();
            RngTemplateModel rtModel = rtBiz.getRtpModel(form.getRngSelectTplSid(), con);
            if (rtModel == null) {
                return getCatchExceptionPage(
                    map, req, new RtpNotfoundException(), backForward, cmn999form);
            }
            //データの不正書き換え対策
            if (form.getRng090rtpSpecVer() != rtModel.getRtpSpecVer()) {
                return getSubmitErrorPage(map, req);
            }
        }

        //連携APIの存在チェック
        String cmd = NullDefault.getString(req.getParameter("CMD"), "");
        if (Objects.equals(cmd, "validateParam")) {
            //OKボタン押下時の入力チェックはajaxで行うため、rng090画面へ遷移するためのcmn999は表示させずにその後の登録処理でcmn999へ遷移させる
            return null;
        }
        int cacSid = -1;
        RngTemplateActionFileBiz rtpaBiz = new RngTemplateActionFileBiz(reqMdl);
        try {
            AddRngActionModel araMdl = rtpaBiz.getActionModel(form.getRng090SelectActionIndex());
            if (araMdl != null) {
                cacSid = araMdl.getApiConnectSid();
            }
        } catch (IOToolsException e) {
            //決裁後アクション用ファイルの読み込みに失敗
            return getSubmitErrorPage(map, req);
        }

        CmnApiConnectDao cacDao = new CmnApiConnectDao(con);
        CmnApiConnectModel cacMdl = cacDao.select(cacSid);
        if (cacMdl == null || cacMdl.getCacJkbn() != GSConst.JTKBN_TOROKU) {
            //指定された連携APIが存在しない or 削除済みの場合cmn999画面でrng090へ遷移するメッセージを表示
            cmn999form = __getErrorForm(map, form, req);
            req.setAttribute("cmn999Form", cmn999form);
            return map.findForward("gf_msg");
        }

        return null;
    }

    /**
     * <br>[機  能] 警告画面のフォームを作成する
     * <br>[解  説]
     * <br>[備  考] 使用中の連携APIが正常の場合、nullを返す
     * @param map ActionMapping
     * @param form ActionForm
     * @param req リクエスト
     * @return 警告画面のフォーム
     * @throws IntrospectionException
     * @throws NoSuchMethodException
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private Cmn999Form __getErrorForm(
        ActionMapping map,
        Rng320Form form,
        HttpServletRequest req)
        throws IllegalAccessException, InvocationTargetException,
        NoSuchMethodException, IntrospectionException {

        ActionForward urlForward =  map.findForward("rng090noApi");
        Cmn999Form cmn999form = new Cmn999Form();
        cmn999form.addHiddenAll(form, form.getClass(), "");
        //経路設定系サブフォームをパラメータ化
        Enumeration<String> enumParamName = (Enumeration<String>) req.getParameterNames();
        while (enumParamName.hasMoreElements()) {
            String name = enumParamName.nextElement();
            if (name.startsWith("rng090keiro.")) {
                Object prop = null;
                try {
                    prop = PropertyUtils.getProperty(form, name);
                } catch (NoSuchMethodException e) {
                    continue;
                }
                if (prop == null) {
                    continue;
                }
                if (prop.getClass().isArray()) {
                    //配列型の場合
                    Object[] objs = (Object[]) prop;
                    if (ArrayUtils.isEmpty(objs)) {
                        continue;
                    }
                    String[] arr = new String[objs.length];
                    for (int i = 0; i < arr.length; i++) {
                        if (objs[i] != null) {
                            arr[i] = objs[i].toString();
                        }
                    }
                    cmn999form.addHiddenParam(name, arr);
                } else if (prop.getClass().isAssignableFrom(Collection.class)) {
                    //List型の場合
                    @SuppressWarnings("unchecked")
                    Collection<Object> objList = (Collection<Object>) prop;
                    if (objList != null && objList.size() == 0) {
                        continue;
                    }
                    Object[] objs = objList.toArray();
                    String[] arr = new String[objs.length];
                    for (int i = 0; i < arr.length; i++) {
                        if (objs[i] != null) {
                            arr[i] = objs[i].toString();
                        }
                    }
                    cmn999form.addHiddenParam(name, arr);
                } else {
                    cmn999form.addHiddenParam(name, prop.toString());
                }
            }
        }
        cmn999form.setIcon(Cmn999Form.ICON_WARN);
        cmn999form.setWtarget(Cmn999Form.WTARGET_BODY);
        cmn999form.setType(Cmn999Form.TYPE_OK);
        cmn999form.setUrlOK(urlForward.getPath());

        GsMessage gsMsg = new GsMessage(req);
        String message;
        if (form.getRngTplCmdMode() == RngConst.RNG_CMDMODE_ADD) {
            message = gsMsg.getMessage("rng.api.none.mode.add");
        } else {
            message = gsMsg.getMessage("rng.api.none.mode.edit");
        }
        cmn999form.setMessage(message);

        return cmn999form;
    }

    /**
     * <br>[機  能] アクションを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form ActionForm
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward executeAction(
        ActionMapping map,
        ActionForm form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        ActionForward forward = null;

        Rng320Form thisForm = (Rng320Form) form;

        //アクセス権限チェック
        forward = __immigration(map, thisForm, req, con);
        if (forward != null) {
            return forward;
        }

        //コマンドパラメータ取得
        String cmd = NullDefault.getString(req.getParameter("CMD"), "");
        log__.debug("CMD = " + cmd);

        if (cmd.equals("rng320_ok")) {
            log__.debug("*** OKボタン");
            forward = __doOk(map, thisForm, req, res, con);
        } else if (cmd.equals("rng320_back")) {
            log__.debug("*** パンくずリスト_連携API登録");
            forward = map.findForward("rng310");
        } else if (cmd.equals("rng320_backToRng090")) {
            log__.debug("*** パンくずリスト_共有テンプレート登録");
            forward = map.findForward("rng090");
        } else if (cmd.equals("getFormInfo")) {
            log__.debug("*** フォーム情報を取得");
            __getFormInfo(thisForm, req, res, con);
        } else if (cmd.equals("getPosInfo")) {
            log__.debug("*** 役職情報を取得");
            __getPosInfo(req, res, con);
        } else if (cmd.equals("getGroupList")) {
            log__.debug("*** グループ一覧を取得");
            __getGroupList(req, res, con);
        } else if (cmd.equals("getUserList")) {
            log__.debug("*** ユーザ一覧を取得");
            __getUserList(thisForm, req, res, con);
        } else if (cmd.equals("okActionParam")) {
            log__.debug("*** 実行条件をファイルに書き込み");
            __writeExecuteCondition(thisForm, req, res, con);
        } else if (cmd.equals("copyCondition")) {
            log__.debug("*** 既存の実行条件を複写");
            __copyCondition(thisForm, req, res, con);
        } else if (cmd.equals("validateParam")) {
            log__.debug("*** パラメータ情報の入力チェックを行う");
            __validateParam(thisForm, req, res, con);
        } else {
            forward = __doInit(map, thisForm, req, res, con);
        }
        return forward;
    }

    /**
     * <br>[機  能] 画面を初期描画する。
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doInit(
        ActionMapping map,
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        if (form.getRng310SelectActionParamIndex() == -1) {
            //アクションパラメータが未選択
            if (req.getAttribute("addRngActionParamModel") != null) {
                //リクエストにアクションパラメータモデルがあれば参照する
                AddRngActionParamModel arapModel
                    = (AddRngActionParamModel) req.getAttribute("addRngActionParamModel");
                form.setRng310SelectActionParamIndex(arapModel.getIndex());
            } else {
                //アクションパラメータが未選択の場合、不正なアクセスとしてエラーを表示
                return getSubmitErrorPage(map, req);
            }
        }
        return __doDsp(map, form, req, res, con);
    }

    /**
     * <br>[機  能] 画面を表示する。
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doDsp(
        ActionMapping map,
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {


        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
        Rng320ParamModel paramMdl = new Rng320ParamModel();
        paramMdl.setParam(form);

        //連携APIに設定されているパラメータをセット
        biz.setApiConnectParamList(paramMdl, con, getRequestModel(req));

        try {
            //表示用データをセット
            biz.setDspData(paramMdl);
        } catch (IOToolsException e) {
            //決裁後アクション用ファイルの読み込みに失敗
            return getSubmitErrorPage(map, req);
        }
        paramMdl.setFormData(form);

        return map.getInputForward();
    }

    /**
     * <br>[機  能] 連携API登録画面に遷移
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doOk(
        ActionMapping map,
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {


        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
        Rng320ParamModel paramMdl = new Rng320ParamModel();
        paramMdl.setParam(form);
        try {
            //パラメータ情報をセットする
            biz.setParamInfo(paramMdl, con, getRequestModel(req));
            biz.writeSettingParam(paramMdl);
        } catch (IOToolsException e) {
            //決裁後アクション用ファイルの読み込みに失敗
            return getSubmitErrorPage(map, req);
        }
        paramMdl.setFormData(form);

        return map.findForward("rng310");
    }

    /**
     * <br>[機  能] フォーム情報を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getFormInfo(
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
        Rng320ParamModel paramMdl = new Rng320ParamModel();
        paramMdl.setParam(form);
        List<FormCell> formCellList = biz.getFormCellList(paramMdl);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("formCellList", formCellList);
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] 役職情報を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param res HttpServletResponse
     * @param req HttpServletRequest
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getPosInfo(
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("positionList", biz.getPositionList());
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] グループ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param res HttpServletResponse
     * @param req HttpServletRequest
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getGroupList(
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("groupList", biz.getGroupList());
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] ユーザ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param res HttpServletResponse
     * @param req HttpServletRequest
     * @param con DB Connection
     * @throws Exception 実行時例外
     */
    public void __getUserList(
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
        Rng320ParamModel paramMdl = new Rng320ParamModel();
        paramMdl.setParam(form);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);
        jsonData.element("userList", biz.getUserList(paramMdl));
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] 実行条件をファイルに書き込み
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws SQLException
     * @throws Exception 実行時例外
     */
    public void __writeExecuteCondition(
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con)
        throws JsonMappingException, JsonProcessingException, SQLException {

        //入力チェック
        List<String> errorMsgList
            = form.validateCheckForExecuteCondition(getRequestModel(req), con);

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        if (errorMsgList != null && errorMsgList.size() > 0) {
            jsonData.element("success", false);
            jsonData.element("errorMsgList", errorMsgList);
        } else {
            jsonData.element("success", true);
            //実行条件JSONを決裁後アクション用ファイルに書き込み
            Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
            Rng320ParamModel paramMdl = new Rng320ParamModel();
            paramMdl.setParam(form);
            RngRapConditionJsonModel rapConditionMdl = new RngRapConditionJsonModel();
            List<String> conditionList = new ArrayList<String>();
            try {
                rapConditionMdl = biz.writeCondition(paramMdl);
                conditionList = biz.getConditionList(paramMdl);
            } catch (IOToolsException e) {
                //決裁後アクション用ファイルの読み込みに失敗
                jsonData.element("success", false);
                jsonData.element("fileError", true);
            }
            //編集後の実行条件をセット
            jsonData.element("actionParamName", paramMdl.getRng310ActionParamName());
            jsonData.element("conditionType", paramMdl.getRng310ConditionType());
            jsonData.element("conditionList", conditionList);
            jsonData.element("rapConditionMdl", rapConditionMdl);
        }
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] 既存の実行条件を複写
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws SQLException
     * @throws Exception 実行時例外
     */
    public void __copyCondition(
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con)
        throws JsonMappingException, JsonProcessingException, SQLException {

        //実行結果をJSON形式で返す
        JSONObject jsonData = new JSONObject();
        jsonData.element("success", true);

        //複写する実行条件情報を取得
        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
        Rng320ParamModel paramMdl = new Rng320ParamModel();
        paramMdl.setParam(form);
        try {
            biz.setCopyConditionInfo(paramMdl);
        } catch (IOToolsException e) {
            //決裁後アクション用ファイルの読み込みに失敗
            jsonData.element("success", false);
        }

        //編集後の実行条件をセット
        jsonData.element("paramKbn", paramMdl.getRng310CopyConditionParamKbn());
        jsonData.element("paramValue", paramMdl.getRng310CopyConditionParamValue());
        jsonData.element("compareTarget", paramMdl.getRng310CopyConditionCompareTarget());
        jsonData.element("compareTargetGroupSid",
            paramMdl.getRng310CopyConditionCompareTargetGroupSid());
        jsonData.element("compareType", paramMdl.getRng310CopyConditionCompareType());
        __writeResp(res, jsonData);
    }

    /**
     * <br>[機  能] パラメータ情報の入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param form Rng320Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @throws SQLException
     * @throws JDOMException
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     * @throws Exception 実行時例外
     */
    public void __validateParam(
        Rng320Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con)
        throws SQLException,
        ParserConfigurationException, SAXException, IOException, JDOMException {

        JSONObject jsonData = new JSONObject();

        String conditionError = "";
        String paramError = "";
        List<String> pathErrors = new ArrayList<String>();
        List<String> queryErrors = new ArrayList<String>();
        List<String> bodyErrors = new ArrayList<String>();
        Rng320Biz biz = new Rng320Biz(con, getRequestModel(req));
        GsMessage gsMsg = new GsMessage(getRequestModel(req));
        Rng320ParamModel paramMdl = new Rng320ParamModel();
        paramMdl.setParam(form);
        try {
            //パラメータ情報をセットする
            biz.setParamInfo(paramMdl, con, getRequestModel(req));
            paramMdl.setFormData(form);
            //入力チェック
            //実行条件
            List<String> errorMsgList
                = form.validateCheckForExecuteCondition(getRequestModel(req), con);
            if (conditionError != null && errorMsgList.size() > 0) {
                conditionError = gsMsg.getMessage("rng.rng320.27");
            }
            //パスパラメータ
            pathErrors = form.validateCheckForParam(
                GSConstCommon.PARAM_KBN_PATH, getRequestModel(req), con);
            //クエリパラメータ
            queryErrors = form.validateCheckForParam(
                GSConstCommon.PARAM_KBN_QUERY, getRequestModel(req), con);
            //リクエストボディ
            bodyErrors = form.validateCheckForParam(
                GSConstCommon.PARAM_KBN_BODY, getRequestModel(req), con);

            if ((pathErrors != null && pathErrors.size() > 0)
                || (queryErrors != null && queryErrors.size() > 0)
                || (bodyErrors != null && bodyErrors.size() > 0)) {
                paramError = gsMsg.getMessage("rng.rng320.25");
            }
        } catch (IOToolsException e) {
            //決裁後アクション用ファイルの読み込みに失敗
            jsonData.element("success", false);
            jsonData.element("fileError", true);
        }

        //実行結果をJSON形式で返す
        if ((paramError != null && paramError.length() > 0)
            || (conditionError != null && conditionError.length() > 0)) {
            jsonData.element("success", false);
            jsonData.element("conditionError", conditionError);
            jsonData.element("paramError", paramError);
            jsonData.element("pathErrorMsgList", pathErrors);
            jsonData.element("queryErrorMsgList", queryErrors);
            jsonData.element("bodyErrorMsgList", bodyErrors);
        } else {
            jsonData.element("success", true);
        }
        __writeResp(res, jsonData);
    }

    /**
     *
     * <br>[機  能] jsonレスポンスの書き込み処理
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param json jsonオブジェクト
     */
    private void __writeResp(HttpServletResponse res, JSONObject json) {
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(json);
            out.flush();
        } catch (IOException e) {
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }
}