package jp.groupsession.v2.rng.rng320;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import java.util.TreeMap;
import java.util.stream.Collectors;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.struts.util.LabelValueBean;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;

import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiConnectBiz;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectParamDao;
import jp.groupsession.v2.cmn.dao.base.CmnPositionDao;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormBuilder;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.formmodel.Block;
import jp.groupsession.v2.cmn.formmodel.BlockList;
import jp.groupsession.v2.cmn.formmodel.GroupComboModel;
import jp.groupsession.v2.cmn.formmodel.SimpleUserSelect;
import jp.groupsession.v2.cmn.formmodel.UserGroupSelectModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectParamModel;
import jp.groupsession.v2.cmn.model.base.CmnPositionModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RngValidate;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.biz.RngTemplateBiz;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.rng.model.ChildParamInfoModel;
import jp.groupsession.v2.rng.model.ListParamInfoModel;
import jp.groupsession.v2.rng.model.ParamInfoModel;
import jp.groupsession.v2.rng.model.RngApiConnectParamModel;
import jp.groupsession.v2.rng.model.RngRapConditionJsonModel;
import jp.groupsession.v2.rng.model.RngRapConditionModel;
import jp.groupsession.v2.rng.model.RngRapParamJsonModel;
import jp.groupsession.v2.rng.model.RngRapParamModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.model.UsrLabelValueBean;

/**
 * <br>[機  能] アクションパラメータ登録/編集画面のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng320Biz {
    /** コネクション */
    private Connection con__;
    /** リクエストモデル */
    private RequestModel reqMdl__;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param reqMdl リクエストモデル
     */
    public Rng320Biz(Connection con, RequestModel reqMdl) {
        con__ = con;
        reqMdl__  = reqMdl;
    }

    /**
     * <br>[機  能] 表示用データをセットする。
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @throws SQLException
     * @throws IOToolsException
     * @throws JDOMException
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public void setDspData(Rng320ParamModel paramMdl)
        throws SQLException, IOToolsException,
        ParserConfigurationException, SAXException, IOException, JDOMException {

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);

        //決裁後アクション情報から繰り返し実行情報を取得
        AddRngActionModel araMdl
            = fileBiz.getActionModel(paramMdl.getRng090SelectActionIndex());
        paramMdl.setRng320RepeatKbn(araMdl.getRepeatKbn());
        paramMdl.setRng320RepeatType(araMdl.getRepeatType());
        if (araMdl.getRepeatType() == RngConst.API_REPEAT_TYPE_FORM) {
            //繰り返し実行対象表要素ボディ内の要素を取得
            List<String> formIdList = new ArrayList<String>();
            FormBuilder formBuilder = new FormBuilder();
            formBuilder.setFormTable(paramMdl.getRng090templateJSON());
            List<FormCell> formCellList = formBuilder.getFormCellList();
            for (FormCell cell : formCellList) {
                if (araMdl.getRepeatFormId().equals(cell.getFormID())) {
                    if (cell.getType() == EnumFormModelKbn.blocklist) {
                        //表要素内の要素
                        for (Block block : ((BlockList) cell.getBody()).getBodyList()) {
                            for (List<FormCell> bodyFormCellList : block.getFormTable()) {
                                for (FormCell bodyFormCell : bodyFormCellList) {
                                    if (!formIdList.contains(bodyFormCell.getFormID())) {
                                        formIdList.add(bodyFormCell.getFormID());
                                    }
                                }
                            }
                        }
                    } else if (cell.getType() == EnumFormModelKbn.file
                        && !formIdList.contains(cell.getFormID())) {
                        //表要素外のファイル要素
                        formIdList.add(cell.getFormID());
                    }
                    break;
                }
            }
            paramMdl.setRng320RepeatFormIdList(formIdList);
        }

        //アクションパラメータ情報を取得
        AddRngActionParamModel arapMdl
            = fileBiz.getActionParamModel(
                paramMdl.getRng090SelectActionIndex(),
                paramMdl.getRng310SelectActionParamIndex());
        paramMdl.setRng310ActionParamName(arapMdl.getName());

        //実行条件を取得
        RngRapConditionJsonModel rapConditionJsonMdl
            = fileBiz.getConditionJsonModel(
                paramMdl.getRng090SelectActionIndex(),
                paramMdl.getRng310SelectActionParamIndex());

        //実行条件をフィールドにセット
        if (rapConditionJsonMdl != null) {

            paramMdl.setRng310ConditionType(rapConditionJsonMdl.getConditionType());
            paramMdl.setRng310RapConditionMap(
                __setConditionInfo(
                    rapConditionJsonMdl.getConditionList(),
                    paramMdl.getRng090templateJSON()));

            //実行条件に不備があるか判定
            if (__checkCondition(rapConditionJsonMdl)) {
                paramMdl.setRng320ExecuteConditionWarnFlg(RngConst.ACTIONPARAM_WARN_FLG_YES);
            } else {
                //表示用実行条件をセット
                paramMdl.setRng320ExecuteConditionList(
                    rtpBiz.getConditionStrList(
                        rapConditionJsonMdl.getConditionList(),
                        paramMdl.getRng090templateJSON(),
                        false, reqMdl__, con__));
            }
        }

        //既存の実行条件を複写コンボ用データを取得
        paramMdl.setRng310CopyConditionCombo(
            rtpBiz.createCopyConditionCombo(
                araMdl.getActionParamList(),
                paramMdl.getRng090SelectActionIndex(),
                paramMdl.getRng310SelectActionParamIndex(),
                paramMdl.getRng090template(),
                paramMdl.getRng090templateJSON(),
                reqMdl__,
                con__));

        //パラメータ情報を取得
        RngRapParamJsonModel rapParamJsonMdl
            = fileBiz.getParamJsonModel(
                paramMdl.getRng090SelectActionIndex(),
                paramMdl.getRng310SelectActionParamIndex());

        //パラメータ情報をフィールドにセット
        if (rapParamJsonMdl != null) {
            //パスパラメータ
            paramMdl.setRng320PathParamMap(
                __getParamMap(
                    paramMdl.getRng320PathParamList(),
                    rapParamJsonMdl.getPathParamList(),
                    paramMdl.getRng090templateJSON()));

            //クエリパラメータ
            paramMdl.setRng320QueryParamMap(
                __getParamMap(
                    paramMdl.getRng320QueryParamList(),
                    rapParamJsonMdl.getQueryParamList(),
                    paramMdl.getRng090templateJSON()));

            //ボディパラメータ
            paramMdl.setRng320ReqBodyParamMap(
                __getParamMap(
                    paramMdl.getRng320ReqBodyParamList(),
                    rapParamJsonMdl.getBodyParamList(),
                    paramMdl.getRng090templateJSON()));

            paramMdl.setRng320ActionParamCmdMode(RngConst.ACTIONPARAM_MODE_EDIT);
        } else {
            paramMdl.setRng320ActionParamCmdMode(RngConst.ACTIONPARAM_MODE_ADD);
        }
    }

    /**
     * <br>[機  能] 実行条件モデルに必要な情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param conditionList 実行条件モデルリスト
     * @param templateJson 申請内容JSON文字列
     * @return 実行条件MAP
     * @throws SQLException
     */
    private TreeMap<Integer, RngRapConditionModel> __setConditionInfo(
        List<RngRapConditionModel> conditionList,
        String templateJson) throws SQLException {

        RngTemplateBiz rtpBiz = new RngTemplateBiz();

        int mapKey = 0;
        TreeMap<Integer, RngRapConditionModel> ret
            = new TreeMap<Integer, RngRapConditionModel>();
        for (RngRapConditionModel rapConditionMdl : conditionList) {

            if (rapConditionMdl.isErrorFlg()) {
                //フォーム要素が変更された場合
                rapConditionMdl.setConditionStr(
                    rtpBiz.getConditionStr(
                        rapConditionMdl, templateJson, reqMdl__, con__));
            } else {
                if (rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_FORM) {
                    //フォーム要素の場合
                    FormBuilder formBuilder = new FormBuilder();
                    formBuilder.setFormTable(templateJson);
                    List<FormCell> cellList = formBuilder.getFormCellList();
                    for (FormCell cell : cellList) {
                        if (cell.getFormID().equals(rapConditionMdl.getParamFormId())) {

                            //フォーム要素情報をセット
                            rapConditionMdl.setParamFormName(cell.getTitle());
                            rapConditionMdl.setParamFormType(cell.getType().getValue());

                            if (cell.getType() == EnumFormModelKbn.user) {
                                //ユーザ選択の場合、比較対象のユーザのデフォルトグループを取得
                                rtpBiz.setGroupInfo(rapConditionMdl, con__);
                            }

                            //フォーム要素タイプをセット
                            if ((cell.getType() == EnumFormModelKbn.user
                                && ((SimpleUserSelect) cell.getBody()).getMultiFlg()
                                    == UserGroupSelectModel.FLG_MULTI_ON)
                                || (cell.getType() == EnumFormModelKbn.group
                                    && ((GroupComboModel) cell.getBody()).getMultiFlg()
                                    == UserGroupSelectModel.FLG_MULTI_ON)) {
                                //ユーザ選択（複数）/グループ選択（複数）
                                rapConditionMdl.setParamFormTypeStr(
                                    "M" + cell.getType().toString());
                            } else if (cell.getType() == EnumFormModelKbn.check) {
                                //チェックボックス
                                rapConditionMdl.setParamFormTypeStr(
                                    "M" + cell.getType().toString());
                            } else {
                                rapConditionMdl.setParamFormTypeStr(cell.getType().toString());
                            }
                            break;
                        }
                    }
                } else if (rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_ADDUSER
                    || rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_LETUSER) {
                    //申請者/最終承認者の場合、比較対象のユーザのデフォルトグループを取得
                    rtpBiz.setGroupInfo(rapConditionMdl, con__);
                }
            }
            ret.put(mapKey, rapConditionMdl);
            mapKey++;
        }
        return ret;
    }

    /**
     * <br>[機  能] 実行条件に不備があるかを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @param rapConditionJsonMdl 実行条件JSONモデル
     * @return 判定結果（true:不備あり, false:不備なし）
     */
    private boolean __checkCondition(
        RngRapConditionJsonModel rapConditionJsonMdl) {

        boolean warnFlg = false;
        for (RngRapConditionModel rapConditionMdl : rapConditionJsonMdl.getConditionList()) {
            if (rapConditionMdl.isErrorFlg()) {
                warnFlg = true;
                break;
            }
        }
        return warnFlg;
    }

    /**
     * <br>[機  能] 連携APIに設定されているパラメータを元にアクションパラメータ（パラメータ情報）を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramList 連携APIパラメータ情報リスト
     * @param rapParamMdlList パラメータ情報リスト
     * @param rngTemplateJson フォーム情報JSON文字列
     * @return パラメータ情報MAP
     * @throws SQLException
     */
    private TreeMap<Integer, RngRapParamModel> __getParamMap(
        List<RngApiConnectParamModel> paramList,
        List<RngRapParamModel> rapParamMdlList,
        String rngTemplateJson) {

        int mapKey = 0;
        TreeMap<Integer, RngRapParamModel> ret
            = new TreeMap<Integer, RngRapParamModel>();
        List<String> childParamNameList = new ArrayList<String>();
        int racIndex = 0;
        for (RngApiConnectParamModel racMdl : paramList) {
            //連携APIに設定されているパラメータでループ

            //パラメータ情報が設定されていない場合
            if (rapParamMdlList.isEmpty()) {
                RngRapParamModel newRapParamMdl = new RngRapParamModel();
                newRapParamMdl.setUseKbn(RngConst.API_PARAM_USE);
                if (racMdl.getCacpRequiredKbn() == GSConstCommon.PARAM_REQUIRE_ON
                    && racMdl.getCacpMdlKbn() != RngConst.API_PARAM_MODEL_PARENT) {
                    racMdl.setParamTypeWarnFlg(true);
                }
                ret.put(mapKey, newRapParamMdl);
                mapKey++;
            }

            int rapParamCnt = 0;
            for (RngRapParamModel rapParamMdl : rapParamMdlList) {
                //アクションパラメータ（パラメータ情報）に登録されたパラメータでループ
                rapParamCnt++;

                if (racMdl.getCacpName().equals(rapParamMdl.getName())
                    && racMdl.getCacpMdlKbn() != RngConst.API_PARAM_MODEL_CHILD) {
                    //パラメータ名が一致する場合

                    //パラメータ形式（通常/配列/モデル）
                    String paramType;
                    if (racMdl.getCacpListKbn() == GSConstCommon.PARAM_LIST_ON) {
                        paramType = RngConst.API_PARAMTYPE_LIST;
                    } else if (racMdl.getCacpMdlKbn() == RngConst.API_PARAM_MODEL_PARENT) {
                        paramType = RngConst.API_PARAMTYPE_MODEL;
                    } else {
                        paramType = RngConst.API_PARAMTYPE_PARAMETER;
                    }
                    if (!rapParamMdl.getParamType().equals(paramType)) {
                        //パラメータのタイプが違う場合は警告アイコンを表示
                        racMdl.setParamTypeWarnFlg(true);
                        RngRapParamModel newRapParamMdl = new RngRapParamModel();
                        newRapParamMdl.setUseKbn(RngConst.API_PARAM_USE);

                        ParamInfoModel paramInfoMdl = new ParamInfoModel();
                        paramInfoMdl.setErrorFlg(true);
                        paramInfoMdl.setParamKbn(-1);
                        TreeMap<Integer, ParamInfoModel> paramInfoMap = new TreeMap<>();
                        paramInfoMap.put(0, paramInfoMdl);

                        if (paramType.equals(RngConst.API_PARAMTYPE_LIST)) {
                            ListParamInfoModel listParamModel = new ListParamInfoModel();
                            listParamModel.setParamInfoMap(paramInfoMap);
                            TreeMap<Integer, ListParamInfoModel> listMap = new TreeMap<>();
                            listMap.put(0, listParamModel);
                            newRapParamMdl.setListParamInfoMap(listMap);
                        } else if (paramType.equals(RngConst.API_PARAMTYPE_PARAMETER)) {
                            newRapParamMdl.setParamInfoMap(paramInfoMap);
                        }
                        ret.put(mapKey, newRapParamMdl);
                        mapKey++;
                        break;
                    }

                    //パラメータ必須区分
                    boolean requiredFlg = false;
                    if (racMdl.getCacpRequiredKbn() == GSConstCommon.PARAM_REQUIRE_ON) {
                        requiredFlg = true;
                    }

                    RngValidate rngValidate = new RngValidate(new GsMessage(reqMdl__));
                    if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_LIST)) {
                        //配列パラメータ

                        //必須チェック
                        if (requiredFlg && rapParamMdl.getListParamInfoMap().size() < 1) {
                            racMdl.setParamTypeWarnFlg(true);
                        }

                        int listParamMapKey = 0;
                        TreeMap<Integer, ListParamInfoModel> listParamMap
                            = new TreeMap<Integer, ListParamInfoModel>();
                        boolean isError = false;
                        for (Entry<Integer, ListParamInfoModel> entry
                            : rapParamMdl.getListParamInfoMap().entrySet()) {
                            int useKbn = rapParamMdl.getUseKbn();
                            //パラメータ形式チェック（テキスト/ファイル）
                            List<String> paramTypeError = rngValidate.checkParamType(
                                racMdl.getCacpParamType(),
                                entry.getValue().getParamInfoMap().values()
                                    .stream()
                                    .collect(Collectors.toList()),
                                rngTemplateJson,
                                racMdl.getCacpName(), 1, useKbn);
                            if (!paramTypeError.isEmpty()) {
                                isError = true;
                                break;
                            } else {
                                //形式が一致する場合
                                ListParamInfoModel listInfoMdl = new ListParamInfoModel();
                                listInfoMdl.setParamInfoMap(
                                    __createParamInfo(
                                        entry.getValue().getParamInfoMap(),
                                        rngTemplateJson));
                                listParamMap.put(listParamMapKey, listInfoMdl);
                                listParamMapKey++;
                            }
                        }

                        if (!isError) {
                            //形式が一致する場合
                            rapParamMdl.setListParamInfoMap(listParamMap);
                            ret.put(mapKey, rapParamMdl);
                        } else {
                            //形式が一致しない場合
                            RngRapParamModel newRapParamMdl = new RngRapParamModel();
                            racMdl.setParamTypeWarnFlg(true);

                            //再設定を促すエラーメッセージが表示され、"選択してください。"が選択されている行を作成
                            ParamInfoModel paramInfoMdl = new ParamInfoModel();
                            paramInfoMdl.setErrorFlg(true);
                            paramInfoMdl.setParamKbn(-1);
                            TreeMap<Integer, ParamInfoModel> paramListMap = new TreeMap<>();
                            paramListMap.put(0, paramInfoMdl);
                            ListParamInfoModel listParamModel = new ListParamInfoModel();
                            listParamModel.setParamInfoMap(paramListMap);

                            TreeMap<Integer, ListParamInfoModel> listMap = new TreeMap<>();
                            listMap.put(0, listParamModel);
                            newRapParamMdl.setListParamInfoMap(listMap);
                            newRapParamMdl.setUseKbn(RngConst.API_PARAM_USE);
                            ret.put(mapKey, newRapParamMdl);
                        }
                        mapKey++;
                        break;

                    } else if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_MODEL)) {
                        //モデルパラメータ

                        ret.put(mapKey, rapParamMdl);
                        mapKey++;

                        int childRacpIndex = racIndex;
                        for (Entry<Integer, ChildParamInfoModel> entry
                            : rapParamMdl.getChildParamInfoMap().entrySet()) {

                            childRacpIndex++;

                            RngRapParamModel rapParamMdlForChild = new RngRapParamModel();
                            rapParamMdlForChild.setName(entry.getValue().getName());
                            rapParamMdlForChild.setUseKbn(entry.getValue().getUseKbn());
                            rapParamMdlForChild.setParamType(entry.getValue().getParamType());

                            RngApiConnectParamModel childRacpMdl = paramList.get(childRacpIndex);
                            childParamNameList.add(childRacpMdl.getCacpName());

                            //パラメータ形式
                            String childParamType;
                            if (childRacpMdl.getCacpListKbn() == GSConstCommon.PARAM_LIST_ON) {
                                childParamType = RngConst.API_PARAMTYPE_LIST;
                            } else {
                                childParamType = RngConst.API_PARAMTYPE_PARAMETER;
                            }
                            if (!entry.getValue().getParamType().equals(childParamType)) {
                                paramList.get(childRacpIndex).setParamTypeWarnFlg(true);
                                rapParamMdlForChild.setUseKbn(RngConst.API_PARAM_USE);
                            }

                            //パラメータ必須区分
                            //親パラメータが必須または「使用する」かつ 子パラメータが必須の場合、必須とする
                            boolean childRequiredFlg = false;
                            if (childRacpMdl.getCacpRequiredKbn()
                                == GSConstCommon.PARAM_REQUIRE_ON
                                && (rapParamMdl.getUseKbn() == RngConst.API_PARAM_USE
                                    || requiredFlg)) {
                                childRequiredFlg = true;
                            }

                            if (entry.getValue().getParamType().equals(
                                RngConst.API_PARAMTYPE_LIST)) {
                                //配列パラメータ

                                //必須チェック
                                if (childRequiredFlg
                                    && entry.getValue().getListParamInfoMap().size() < 1) {
                                    paramList.get(childRacpIndex).setParamTypeWarnFlg(true);
                                }

                                int listParamMapKey = 0;
                                TreeMap<Integer, ListParamInfoModel> listParamMap
                                    = new TreeMap<Integer, ListParamInfoModel>();
                                for (Entry<Integer, ListParamInfoModel> listEntry
                                    : entry.getValue().getListParamInfoMap().entrySet()) {

                                    ListParamInfoModel listInfoMdl = new ListParamInfoModel();
                                    listInfoMdl.setParamInfoMap(
                                        __createParamInfo(
                                            listEntry.getValue().getParamInfoMap(),
                                            rngTemplateJson));
                                    listParamMap.put(listParamMapKey, listInfoMdl);
                                    listParamMapKey++;
                                }
                                rapParamMdlForChild.setListParamInfoMap(listParamMap);
                                ret.put(mapKey, rapParamMdlForChild);
                                mapKey++;

                            } else {
                                //通常パラメータ

                                //必須チェック
                                if (childRequiredFlg
                                    && entry.getValue().getParamInfoMap().size() < 1) {
                                    paramList.get(childRacpIndex).setParamTypeWarnFlg(true);
                                }

                                rapParamMdlForChild.setParamInfoMap(
                                    __createParamInfo(
                                        entry.getValue().getParamInfoMap(),
                                        rngTemplateJson));
                                ret.put(mapKey, rapParamMdlForChild);
                                mapKey++;
                            }
                        }
                        break;

                    } else {
                        //通常パラメータ

                        //必須チェック
                        if (requiredFlg && rapParamMdl.getParamInfoMap().size() < 1) {
                            racMdl.setParamTypeWarnFlg(true);
                        }

                        int useKbn = rapParamMdl.getUseKbn();
                        //パラメータ形式チェック（テキスト/ファイル）
                        List<String> paramTypeError = rngValidate.checkParamType(
                            racMdl.getCacpParamType(),
                            rapParamMdl.getParamInfoMap().values()
                                .stream()
                                .collect(Collectors.toList()),
                            rngTemplateJson,
                            racMdl.getCacpName(), -1, useKbn);

                        if (!paramTypeError.isEmpty()) {
                            //形式が一致しない場合
                            RngRapParamModel newRapParamMdl = new RngRapParamModel();
                            racMdl.setParamTypeWarnFlg(true);

                            //再設定を促すエラーメッセージが表示され、"選択してください。"が選択されている行を作成
                            ParamInfoModel paramInfoMdl = new ParamInfoModel();
                            paramInfoMdl.setErrorFlg(true);
                            paramInfoMdl.setParamKbn(-1);
                            TreeMap<Integer, ParamInfoModel> paramInfoMap = new TreeMap<>();
                            paramInfoMap.put(0, paramInfoMdl);
                            newRapParamMdl.setParamInfoMap(paramInfoMap);
                            newRapParamMdl.setUseKbn(RngConst.API_PARAM_USE);
                            ret.put(mapKey, newRapParamMdl);
                        } else {
                            //形式が一致する場合
                            rapParamMdl.setParamInfoMap(
                                __createParamInfo(
                                    rapParamMdl.getParamInfoMap(),
                                    rngTemplateJson));
                            ret.put(mapKey, rapParamMdl);
                        }
                        mapKey++;
                        break;
                    }

                } else if (rapParamMdlList.size() <= rapParamCnt
                    && !childParamNameList.contains(racMdl.getCacpName())) {

                    //一致するパラメータ名が存在しない場合
                    RngRapParamModel newRapParamMdl = new RngRapParamModel();
                    newRapParamMdl.setUseKbn(RngConst.API_PARAM_USE);
                    if (racMdl.getCacpRequiredKbn() == GSConstCommon.PARAM_REQUIRE_ON
                        && racMdl.getCacpMdlKbn() != RngConst.API_PARAM_MODEL_PARENT) {
                        racMdl.setParamTypeWarnFlg(true);
                    }
                    ret.put(mapKey, newRapParamMdl);
                    mapKey++;
                    break;
                }
            }
            racIndex++;
        }
        return ret;
    }

    /**
     * <br>[機  能] 1行分のパラメータ情報を生成
     * <br>[解  説]
     * <br>[備  考]
     * @param paramInfoMap パラメータ情報マップ
     * @param rngTemplateJson フォーム情報JSON文字列
     * @return パラメータ情報MAP
     * @throws SQLException
     */
    private TreeMap<Integer, ParamInfoModel> __createParamInfo(
        TreeMap<Integer, ParamInfoModel> paramInfoMap,
        String rngTemplateJson) {

        RngTemplateBiz rtpBiz = new RngTemplateBiz();

        int paramMapKey = 0;
        TreeMap<Integer, ParamInfoModel> ret
            = new TreeMap<Integer, ParamInfoModel>();
        for (Entry<Integer, ParamInfoModel> entry
            : paramInfoMap.entrySet()) {
            if (entry.getValue().getParamKbn() == RngConst.API_PARAMKBN_FORM) {
                //フォーム要素の場合

                if (entry.getValue().isErrorFlg()) {
                    //削除されたフォーム要素
                    ParamInfoModel paramInfo = entry.getValue();
                    paramInfo.setParamValueStr(
                        rtpBiz.getParamValueStr(entry.getValue().getParamValue(), reqMdl__));
                    ret.put(paramMapKey, paramInfo);
                    paramMapKey++;
                } else {
                    //削除されていないフォーム要素
                    FormBuilder formBuilder = new FormBuilder();
                    formBuilder.setFormTable(rngTemplateJson);
                    List<FormCell> cellList = formBuilder.getFormCellList();

                    //表要素ボディ内の要素を取得
                    List<String> bodyList
                        = rtpBiz.getFormCellFromBlockListBody(
                            rngTemplateJson)
                            .stream()
                            .map(b -> b.getFormID())
                            .collect(Collectors.toList());

                    for (FormCell cell : cellList) {
                        if (cell.getFormID().equals(
                            entry.getValue().getParamFormId())) {
                            //フォームIDが存在する場合

                            ParamInfoModel paramInfoMdl = entry.getValue();

                            //フォーム要素タイプをセット
                            if ((cell.getType() == EnumFormModelKbn.user
                                && ((SimpleUserSelect) cell.getBody()).getMultiFlg()
                                    == UserGroupSelectModel.FLG_MULTI_ON)
                                || (cell.getType() == EnumFormModelKbn.group
                                    && ((GroupComboModel) cell.getBody())
                                        .getMultiFlg()
                                            == UserGroupSelectModel.FLG_MULTI_ON)) {
                                //ユーザ選択（複数）/グループ選択（複数）
                                paramInfoMdl.setParamFormTypeStr(
                                    "M" + cell.getType().toString());
                            } else if (cell.getType() == EnumFormModelKbn.check) {
                                //チェックボックス
                                paramInfoMdl.setParamFormTypeStr(
                                    "M" + cell.getType().toString());
                            } else {
                                paramInfoMdl.setParamFormTypeStr(
                                    cell.getType().toString());
                            }

                            //表要素ボディ内の要素場合
                            if (bodyList.contains(cell.getFormID())) {
                                paramInfoMdl.setParamFormTypeStr(
                                    "B" + paramInfoMdl.getParamFormTypeStr());
                            }

                            ret.put(paramMapKey, paramInfoMdl);
                            paramMapKey++;
                            break;
                        }
                    }
                }
            } else {
                //フォーム要素以外の場合
                ret.put(paramMapKey, entry.getValue());
                paramMapKey++;
            }
        }
        return ret;
    }

    /**
     * <br>[機  能] パラメータ情報を決裁後アクション用ファイルに書き込む
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @throws IOToolsException
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws SQLException
     */
    public void writeSettingParam(
        Rng320ParamModel paramMdl)
        throws IOToolsException, JsonMappingException, JsonProcessingException, SQLException {

        //パラメータ情報にフォーム情報をセット
        __setFormInfoToParam(paramMdl);

        //パラメータ情報JSONモデルを作成
        RngRapParamJsonModel rapParamJsonMdl = new RngRapParamJsonModel();
        rapParamJsonMdl.setPathParamList(
            paramMdl.getRng320PathParamMap().values().stream().collect(Collectors.toList()));
        rapParamJsonMdl.setQueryParamList(
            paramMdl.getRng320QueryParamMap().values().stream().collect(Collectors.toList()));
        rapParamJsonMdl.setBodyParamList(
            paramMdl.getRng320ReqBodyParamMap().values().stream().collect(Collectors.toList()));

        //決裁後アクション用ファイルに書き込み
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        fileBiz.setParamJsonModel(
            paramMdl.getRng090SelectActionIndex(),
            paramMdl.getRng310SelectActionParamIndex(),
            rapParamJsonMdl);
    }

    /**
     * <br>[機  能] フォーム情報リストを取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @return フォーム要素リスト
     * @throws SQLException
     */
    public List<FormCell> getFormCellList(Rng320ParamModel paramMdl) {

        FormBuilder formBuilder = new FormBuilder();
        formBuilder.setFormTable(paramMdl.getRng090templateJSON());
        List<FormCell> cellList = formBuilder.getFormCellList();
        return cellList;
    }

    /**
     * <br>[機  能] 役職情報リストを取得
     * <br>[解  説]
     * <br>[備  考]
     * @return 役職情報リスト
     * @throws SQLException
     */
    public List<CmnPositionModel> getPositionList() throws SQLException {

        CmnPositionDao cpsDao = new CmnPositionDao(con__);
        List <CmnPositionModel> posMdlList = cpsDao.getPosList(true);
        return posMdlList;
    }

    /**
     * <br>[機  能] グループ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @return グループ一覧
     * @throws SQLException
     */
    public List<LabelValueBean> getGroupList() throws SQLException {

        GroupBiz grpBiz = new GroupBiz();
        return grpBiz.getGroupCombLabelList(con__, false, null);
    }

    /**
     * <br>[機  能] ユーザ一覧を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @return ユーザ一覧
     * @throws SQLException
     */
    public List<UsrLabelValueBean> getUserList(Rng320ParamModel paramMdl) throws SQLException {

        UserBiz usrBiz = new UserBiz();
        return usrBiz.getNormalUserLabelList(
            con__, paramMdl.getRng310SelectGroupSid(), null, false, null);
    }

    /**
     * <br>[機  能] 実行条件を書き込み
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @return 実行条件JSONモデル
     * @throws JsonProcessingException
     * @throws JsonMappingException
     * @throws IOToolsException
     * @throws SQLException
     */
    public RngRapConditionJsonModel writeCondition(
        Rng320ParamModel paramMdl)
        throws JsonMappingException, JsonProcessingException, IOToolsException, SQLException {

        //実行条件JSONモデルを作成
        RngRapConditionJsonModel rngRapConditionJsonMdl = new RngRapConditionJsonModel();
        rngRapConditionJsonMdl.setConditionType(paramMdl.getRng310ConditionType());
        rngRapConditionJsonMdl.setConditionList(
            __setConditionInfo(
                paramMdl.getRng310RapConditionMap().values()
                    .stream()
                    .collect(Collectors.toList()),
                paramMdl.getRng090templateJSON())
                .values().stream().collect(Collectors.toList()));

        //決裁後アクション用ファイルに書き込み
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionParamModel arapMdl = fileBiz.getActionParamModel(
            paramMdl.getRng090SelectActionIndex(),
            paramMdl.getRng310SelectActionParamIndex());
        arapMdl.setName(paramMdl.getRng310ActionParamName());
        //アクションパラメータを更新
        fileBiz.updateActionParam(
            arapMdl,
            paramMdl.getRng090SelectActionIndex(),
            paramMdl.getRng310SelectActionParamIndex());
        //実行条件JSONを更新
        fileBiz.setConditionJsonModel(
            paramMdl.getRng090SelectActionIndex(),
            paramMdl.getRng310SelectActionParamIndex(),
            rngRapConditionJsonMdl);

        return rngRapConditionJsonMdl;
    }

    /**
     * <br>[機  能] 実行条件を取得
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @return 実行条件リスト
     * @throws IOToolsException
     * @throws SQLException
     */
    public List<String> getConditionList(
        Rng320ParamModel paramMdl) throws IOToolsException, SQLException {

        RngTemplateBiz rtpBiz = new RngTemplateBiz();
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        List<String> ret = new ArrayList<String>();

        //実行条件を取得
        RngRapConditionJsonModel rapConditionJsonMdl
            = fileBiz.getConditionJsonModel(
                paramMdl.getRng090SelectActionIndex(),
                paramMdl.getRng310SelectActionParamIndex());

        if (rapConditionJsonMdl != null) {
            //表示用実行条件をセット
            ret = rtpBiz.getConditionStrList(
                    rapConditionJsonMdl.getConditionList(),
                    paramMdl.getRng090templateJSON(),
                    false, reqMdl__, con__);
        }
        return ret;
    }

    /**
     * <br>[機  能] 複写する実行条件の設定値をセット
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @throws IOToolsException
     * @throws SQLException
     */
    public void setCopyConditionInfo(
        Rng320ParamModel paramMdl) throws IOToolsException, SQLException {

        RngTemplateBiz rtpBiz = new RngTemplateBiz();

        int index = paramMdl.getRng310CopyCondition().indexOf(".");
        int actionMdlIndex
            = NullDefault.getInt(paramMdl.getRng310CopyCondition().substring(0, index), -1);
        int actionParamMdlIndex
            = NullDefault.getInt(paramMdl.getRng310CopyCondition().substring(index + 1), -1);

        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl__);
        RngRapConditionJsonModel rapConditionJsonMdl
            = fileBiz.getConditionJsonModel(paramMdl.getRng090SelectActionIndex(), actionMdlIndex);
        if (rapConditionJsonMdl != null) {
            int rapConditionIndex = 0;
            for (RngRapConditionModel rapConditionMdl : rapConditionJsonMdl.getConditionList()) {
                if (rapConditionIndex == actionParamMdlIndex) {
                    if (rapConditionMdl.getParamKbn() != RngConst.API_PARAMKBN_FORM) {
                        //フォーム要素以外
                        if (rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_ADDUSER
                            || rapConditionMdl.getParamKbn() == RngConst.API_PARAMKBN_LETUSER) {
                            //申請者/最終承認者の場合、比較対象のユーザ名をセット
                            rtpBiz.setGroupInfo(rapConditionMdl, con__);
                        }
                        paramMdl.setRng310CopyConditionParamKbn(
                            String.valueOf(rapConditionMdl.getParamKbn()));
                    } else {
                        //フォーム要素
                        FormBuilder formBuilder = new FormBuilder();
                        formBuilder.setFormTable(paramMdl.getRng090templateJSON());
                        List<FormCell> cellList = formBuilder.getFormCellList();

                        for (FormCell cell : cellList) {
                            if (cell.getFormID().equals(rapConditionMdl.getParamFormId())) {
                                if (cell.getType() == EnumFormModelKbn.user) {
                                    //ユーザ選択の場合、比較対象のユーザ名をセット
                                    rtpBiz.setGroupInfo(rapConditionMdl, con__);
                                }

                                //フォーム要素タイプをセット
                                if ((cell.getType() == EnumFormModelKbn.user
                                    && ((SimpleUserSelect) cell.getBody()).getMultiFlg()
                                        == UserGroupSelectModel.FLG_MULTI_ON)
                                    || (cell.getType() == EnumFormModelKbn.group
                                        && ((GroupComboModel) cell.getBody()).getMultiFlg()
                                        == UserGroupSelectModel.FLG_MULTI_ON)) {
                                    //ユーザ選択（複数）/グループ選択（複数）
                                    rapConditionMdl.setParamFormTypeStr(
                                        "M" + cell.getType().toString());

                                } else if (cell.getType() == EnumFormModelKbn.check) {
                                    //チェックボックス
                                    rapConditionMdl.setParamFormTypeStr(
                                        "M" + cell.getType().toString());
                                } else {
                                    rapConditionMdl.setParamFormTypeStr(cell.getType().toString());
                                }
                                break;
                            }
                        }
                        paramMdl.setRng310CopyConditionParamKbn(
                            rapConditionMdl.getParamFormTypeStr()
                            + "." + String.valueOf(rapConditionMdl.getParamFormId()));
                    }
                    paramMdl.setRng310CopyConditionParamValue(rapConditionMdl.getParamValue());
                    paramMdl.setRng310CopyConditionCompareTarget(
                        rapConditionMdl.getCompareTarget());
                    paramMdl.setRng310CopyConditionCompareTargetGroupSid(
                        rapConditionMdl.getCompareTargetGroupSid());
                    paramMdl.setRng310CopyConditionCompareType(rapConditionMdl.getCompareType());
                    break;
                }
                rapConditionIndex++;
            }
        }
    }

    /**
     * <br>[機  能] 連携APIに設定されている各パラメータリストをセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @param con コネクション
     * @param reqMdl リクエストモデル
     * @throws SQLException
     * @throws IOToolsException
     * @throws JDOMException
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public void setApiConnectParamList(
        Rng320ParamModel paramMdl,
        Connection con,
        RequestModel reqMdl) throws SQLException, IOToolsException,
        ParserConfigurationException, SAXException, IOException, JDOMException {

        //パラメータリストを取得
        int cacSid = 0;
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl);
        AddRngActionModel addActionMdl
            = fileBiz.getActionModel(paramMdl.getRng090SelectActionIndex());
        if (addActionMdl != null) {
            cacSid = addActionMdl.getApiConnectSid();
        }
        CmnApiConnectDao cacDao = new CmnApiConnectDao(con);
        CmnApiConnectModel cacMdl = cacDao.select(cacSid);
        CmnApiConnectParamDao cacpDao = new CmnApiConnectParamDao(con);
        List<CmnApiConnectParamModel> cacpMdlList = cacpDao.select(cacSid);

        if (cacMdl != null) {
            ApiConnectBiz apiBiz = new ApiConnectBiz();
            //パスパラメータ
            List<RngApiConnectParamModel> pathParamMdlList
                = new ArrayList<RngApiConnectParamModel>();
            List<CmnApiConnectParamModel> pathCacpMdlList
                = cacpMdlList.stream()
                    .filter(c -> c.getCacpKbn() == GSConstCommon.PARAM_KBN_PATH)
                    .collect(Collectors.toList());
            List<String> pathParam = apiBiz.getPathParameterName(cacMdl.getCacUrl());
            for (String paramName : pathParam) {
                for (CmnApiConnectParamModel cacpMdl : pathCacpMdlList) {
                    if (cacpMdl.getCacpName().equals(paramName)) {
                        pathParamMdlList.add(__copyApiConnectParam(cacpMdl));
                        break;
                    }
                }
            }
            paramMdl.setRng320PathParamList(pathParamMdlList);

            //クエリパラメータ
            List<RngApiConnectParamModel> queryParamMdlList
                = new ArrayList<RngApiConnectParamModel>();
            List<CmnApiConnectParamModel> queryCacpMdlList
                = cacpMdlList.stream()
                    .filter(c -> c.getCacpKbn() == GSConstCommon.PARAM_KBN_QUERY)
                    .collect(Collectors.toList());
            List<String> queryParam = apiBiz.getQueryParameterName(cacMdl.getCacUrl());
            for (String paramName : queryParam) {
                for (CmnApiConnectParamModel cacpMdl : queryCacpMdlList) {
                    if (cacpMdl.getCacpName().equals(paramName)) {
                        queryParamMdlList.add(__copyApiConnectParam(cacpMdl));
                        break;
                    }
                }
            }
            paramMdl.setRng320QueryParamList(queryParamMdlList);

            //リクエストボディ
            List<CmnApiConnectParamModel> bodyCacpMdlList
                = cacpMdlList.stream()
                    .filter(c -> c.getCacpKbn() == GSConstCommon.PARAM_KBN_BODY)
                    .collect(Collectors.toList());
            TreeMap<Integer, CmnApiConnectParamModel> bodyMap
                = apiBiz.getBodyMap(
                    bodyCacpMdlList,
                    cacMdl.getCacBody(),
                    cacMdl.getCacContentKbn());
            List<RngApiConnectParamModel> bodyList = new ArrayList<RngApiConnectParamModel>();
            for (CmnApiConnectParamModel cacpMdl : bodyMap.values()) {
                bodyList.add(__copyApiConnectParam(cacpMdl));
            }
            TreeMap<Integer, RngApiConnectParamModel> bodyParamMdlMap
                = new TreeMap<Integer, RngApiConnectParamModel>();
            int key = 0;
            for (RngApiConnectParamModel cacpMdl : bodyList) {

                if (cacpMdl.getCacpName().contains(".")) {
                    cacpMdl.setCacpMdlKbn(RngConst.API_PARAM_MODEL_CHILD);
                    String cacpName = cacpMdl.getCacpName();
                    int index = cacpName.indexOf(".");
                    String childCacpName = cacpName.substring(index + 1);
                    cacpMdl.setCacpNameNoParent(childCacpName);
                    String parentCacpName = cacpName.substring(0, index);

                    for (Entry<Integer, RngApiConnectParamModel> entry
                        : bodyParamMdlMap.entrySet()) {
                        if (entry.getValue().getCacpName().equals(parentCacpName)
                            && entry.getValue().getCacpMdlKbn() != RngConst.API_PARAM_MODEL_CHILD) {
                            entry.getValue().setCacpMdlKbn(RngConst.API_PARAM_MODEL_PARENT);
                        }
                    }
                }
                bodyParamMdlMap.put(key, cacpMdl);
                key++;
            }
            paramMdl.setRng320ReqBodyParamList(
                bodyParamMdlMap.values().stream().collect(Collectors.toList()));
        }
    }

    /**
     * <br>[機  能] 連携APIパラメータ情報をコピーする
     * <br>[解  説]
     * <br>[備  考]
     * @param cacpMdl 連携APIパラメータ情報
     * @return 稟議用連携APIパラメータ情報
     */
    private RngApiConnectParamModel __copyApiConnectParam(CmnApiConnectParamModel cacpMdl) {

        RngApiConnectParamModel ret = new RngApiConnectParamModel();
        ret.setCacSid(cacpMdl.getCacSid());
        ret.setCacpKbn(cacpMdl.getCacpKbn());
        ret.setCacpParamType(cacpMdl.getCacpParamType());
        ret.setCacpName(cacpMdl.getCacpName());
        ret.setCacpNameDisp(cacpMdl.getCacpNameDisp());
        ret.setCacpBiko(cacpMdl.getCacpBiko());
        ret.setCacpRequiredKbn(cacpMdl.getCacpRequiredKbn());
        ret.setCacpListKbn(cacpMdl.getCacpListKbn());
        ret.setCacpNameNoParent(cacpMdl.getCacpName());
        return ret;
    }

    /**
     * <br>[機  能] パラメータ情報をセットする
     * <br>[解  説] パス/クエリのパラメータタイプをセットする。リクエストボディのモデル構造を配置し直す。
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @param con コネクション
     * @param reqMdl リクエストモデル
     * @throws SQLException
     * @throws IOToolsException
     * @throws JDOMException
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    public void setParamInfo(
        Rng320ParamModel paramMdl,
        Connection con,
        RequestModel reqMdl)
        throws SQLException, IOToolsException,
        ParserConfigurationException, SAXException, IOException, JDOMException {

        //連携APIに設定されている各パラメータをセット
        setApiConnectParamList(paramMdl, con, reqMdl);
        //パスパラメータ
        int pathIndex = 0;
        TreeMap<Integer, RngRapParamModel> pathMap = new TreeMap<Integer, RngRapParamModel>();
        for (RngRapParamModel rapParamMdl
            : paramMdl.getRng320PathParamMap().values()) {
            rapParamMdl.setParamType(RngConst.API_PARAMTYPE_PARAMETER);
            pathMap.put(pathIndex, rapParamMdl);
            pathIndex++;
        }
        paramMdl.setRng320PathParamMap(pathMap);
        //クエリパラメータ
        int queryIndex = 0;
        TreeMap<Integer, RngRapParamModel> queryMap = new TreeMap<Integer, RngRapParamModel>();
        for (RngRapParamModel rapParamMdl
            : paramMdl.getRng320QueryParamMap().values()) {
            if (paramMdl.getRng320QueryParamList().get(queryIndex).getCacpListKbn()
                == GSConstCommon.PARAM_LIST_ON) {
                rapParamMdl.setParamType(RngConst.API_PARAMTYPE_LIST);
            } else if (paramMdl.getRng320QueryParamList().get(queryIndex).getCacpListKbn()
                == GSConstCommon.PARAM_LIST_OFF) {
                rapParamMdl.setParamType(RngConst.API_PARAMTYPE_PARAMETER);
            }
            queryMap.put(queryIndex, rapParamMdl);
            queryIndex++;
        }
        paramMdl.setRng320QueryParamMap(queryMap);
        //リクエストボディ
        __setReqBodyParamList(paramMdl, con, reqMdl);
    }

    /**
     * <br>[機  能] リクエストボディパラメータ情報をセットする
     * <br>[解  説] 通常パラメータとしてリクエスト送信された子パラメータを親パラメータの子要素として配置し直す。
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     * @param con コネクション
     * @param reqMdl リクエストモデル
     * @throws SQLException
     * @throws IOToolsException
     * @throws JDOMException
     * @throws IOException
     * @throws SAXException
     * @throws ParserConfigurationException
     */
    private void __setReqBodyParamList(
        Rng320ParamModel paramMdl,
        Connection con,
        RequestModel reqMdl)
        throws SQLException, IOToolsException,
        ParserConfigurationException, SAXException, IOException, JDOMException {

        int index = 0;
        TreeMap<Integer, RngRapParamModel> reqBodyMap = new TreeMap<Integer, RngRapParamModel>();
        for (Entry<Integer, RngRapParamModel> entry
            : paramMdl.getRng320ReqBodyParamMap().entrySet()) {

            if (paramMdl.getRng320ReqBodyParamList().get(index).getCacpMdlKbn()
                    == RngConst.API_PARAM_MODEL_PARENT) {

                //親パラメータの場合
                RngRapParamModel rapParamMdl = new RngRapParamModel();
                rapParamMdl.setName(entry.getValue().getName());
                rapParamMdl.setUseKbn(entry.getValue().getUseKbn());
                rapParamMdl.setParamType(RngConst.API_PARAMTYPE_MODEL);
                int childMapKey = 0;
                TreeMap<Integer, ChildParamInfoModel> childMap
                    = new TreeMap<Integer, ChildParamInfoModel>();

                int childIndex = index + 1;
                while (childIndex < paramMdl.getRng320ReqBodyParamList().size()
                    && paramMdl.getRng320ReqBodyParamList().get(childIndex).getCacpMdlKbn()
                        == RngConst.API_PARAM_MODEL_CHILD) {

                    //子パラメータ情報をセット
                    ChildParamInfoModel childMdl = new ChildParamInfoModel();
                    childMdl.setName(
                        paramMdl.getRng320ReqBodyParamList().get(childIndex).getCacpNameNoParent());
                    childMdl.setUseKbn(paramMdl.getRng320ReqBodyParam(childIndex).getUseKbn());

                    if (paramMdl.getRng320ReqBodyParamList().get(childIndex).getCacpListKbn()
                        == GSConstCommon.PARAM_LIST_ON) {
                        //子パラメータが配列パラメータ
                        childMdl.setParamType(RngConst.API_PARAMTYPE_LIST);

                        int listParamMapKey = 0;
                        TreeMap<Integer, ListParamInfoModel> listParamMap
                            = new TreeMap<Integer, ListParamInfoModel>();
                        for (Entry<Integer, ListParamInfoModel> listParamEntry
                            : paramMdl.getRng320ReqBodyParam(childIndex)
                                .getListParamInfoMap().entrySet()) {

                            ListParamInfoModel listParamMdl = new ListParamInfoModel();
                            int paramMapKey = 0;
                            TreeMap<Integer, ParamInfoModel> paramMap
                                = new TreeMap<Integer, ParamInfoModel>();
                            for (Entry<Integer, ParamInfoModel> paramEntry
                                : listParamEntry.getValue().getParamInfoMap().entrySet()) {

                                ParamInfoModel paramInfo = new ParamInfoModel();
                                paramInfo.setParamKbn(paramEntry.getValue().getParamKbn());
                                if (paramEntry.getValue().getParamKbn()
                                    == RngConst.API_PARAMKBN_FORM) {
                                    paramInfo.setParamFormId(
                                        paramEntry.getValue().getParamFormId());
                                }
                                paramInfo.setParamValue(paramEntry.getValue().getParamValue());
                                if (paramEntry.getValue().getParamKbn()
                                    == RngConst.API_PARAMKBN_MANUAL) {
                                    paramInfo.setParamValueManual(
                                        paramEntry.getValue().getParamValueManual());
                                }
                                paramInfo.setParamIndex(paramEntry.getValue().getParamIndex());
                                paramMap.put(paramMapKey, paramInfo);
                                paramMapKey++;
                            }
                            listParamMdl.setParamInfoMap(paramMap);
                            listParamMap.put(listParamMapKey, listParamMdl);
                            listParamMapKey++;
                        }
                        childMdl.setListParamInfoMap(listParamMap);
                        childMap.put(childMapKey, childMdl);
                        childMapKey++;
                        childIndex++;

                    } else if (paramMdl.getRng320ReqBodyParamList().get(childIndex).getCacpListKbn()
                        == GSConstCommon.PARAM_LIST_OFF) {
                        //子パラメータが通常パラメータ
                        childMdl.setParamType(RngConst.API_PARAMTYPE_PARAMETER);
                        childMdl.setParamInfoMap(
                            paramMdl.getRng320ReqBodyParam(childIndex).getParamInfoMap());
                        childMap.put(childMapKey, childMdl);
                        childMapKey++;
                        childIndex++;
                    }
                }
                rapParamMdl.setChildParamInfoMap(childMap);
                reqBodyMap.put(index, rapParamMdl);

            } else if (paramMdl.getRng320ReqBodyParamList().get(index).getCacpMdlKbn()
                == RngConst.API_PARAM_MODEL_NORMAL) {

                //通常/配列パラメータの場合
                RngRapParamModel rapParamMdl = entry.getValue();
                if (paramMdl.getRng320ReqBodyParamList().get(index).getCacpListKbn()
                    == GSConstCommon.PARAM_LIST_ON) {
                    rapParamMdl.setParamType(RngConst.API_PARAMTYPE_LIST);
                } else if (paramMdl.getRng320ReqBodyParamList().get(index).getCacpListKbn()
                    == GSConstCommon.PARAM_LIST_OFF) {
                    rapParamMdl.setParamType(RngConst.API_PARAMTYPE_PARAMETER);
                }
                reqBodyMap.put(index, rapParamMdl);
            }
            index++;
        }
        paramMdl.setRng320ReqBodyParamMap(reqBodyMap);
    }

    /**
     * <br>[機  能] パラメータ情報にフォーム情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng320ParamModel
     */
    private void __setFormInfoToParam(
        Rng320ParamModel paramMdl) {

        //フォーム要素リストを取得
        FormBuilder formBuilder = new FormBuilder();
        formBuilder.setFormTable(paramMdl.getRng090templateJSON());
        List<FormCell> cellList = formBuilder.getFormCellList();

        //パスパラメータ
        for (RngRapParamModel rapParamMdl : paramMdl.getRng320PathParamMap().values()) {
            __setFormInfoToParamInfo(
                rapParamMdl.getParamInfoMap().values()
                    .stream()
                    .collect(Collectors.toList()),
                cellList);
        }

        //クエリパラメータ
        for (RngRapParamModel rapParamMdl : paramMdl.getRng320QueryParamMap().values()) {
            if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_LIST)) {
                //配列パラメータ
                for (ListParamInfoModel listParam : rapParamMdl.getListParamInfoMap().values()) {
                    __setFormInfoToParamInfo(
                        listParam.getParamInfoMap().values()
                            .stream()
                            .collect(Collectors.toList()),
                        cellList);
                }
            } else if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_PARAMETER)) {
                //通常パラメータ
                __setFormInfoToParamInfo(
                    rapParamMdl.getParamInfoMap().values()
                        .stream()
                        .collect(Collectors.toList()),
                    cellList);
            }
        }

        //リクエストボディ
        for (RngRapParamModel rapParamMdl : paramMdl.getRng320ReqBodyParamMap().values()) {
            if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_LIST)) {
                //配列パラメータ
                for (ListParamInfoModel listParam : rapParamMdl.getListParamInfoMap().values()) {
                    __setFormInfoToParamInfo(
                        listParam.getParamInfoMap().values()
                            .stream()
                            .collect(Collectors.toList()),
                        cellList);
                }
            } else if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_MODEL)) {
                //モデルパラメータ
                for (ChildParamInfoModel childParam : rapParamMdl.getChildParamInfoMap().values()) {
                    if (childParam.getParamType().equals(RngConst.API_PARAMTYPE_LIST)) {
                        //配列子パラメータ
                        for (ListParamInfoModel listParam
                            : childParam.getListParamInfoMap().values()) {
                            __setFormInfoToParamInfo(
                                listParam.getParamInfoMap().values()
                                    .stream()
                                    .collect(Collectors.toList()),
                                cellList);
                        }
                    } else if (childParam.getParamType().equals(RngConst.API_PARAMTYPE_PARAMETER)) {
                        //通常子パラメータ
                        __setFormInfoToParamInfo(
                            childParam.getParamInfoMap().values()
                                .stream()
                                .collect(Collectors.toList()),
                            cellList);
                    }
                }
            } else if (rapParamMdl.getParamType().equals(RngConst.API_PARAMTYPE_PARAMETER)) {
                //通常パラメータ
                __setFormInfoToParamInfo(
                    rapParamMdl.getParamInfoMap().values()
                        .stream()
                        .collect(Collectors.toList()),
                    cellList);
            }
        }
    }

    /**
     * <br>[機  能] 1つの要素に設定されているパラメータ情報にフォーム情報をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param paramInfoList パラメータ情報リスト
     * @param cellList フォーム要素リスト
     */
    private void __setFormInfoToParamInfo(
        List<ParamInfoModel> paramInfoList,
        List<FormCell> cellList) {

        for (ParamInfoModel paramInfo : paramInfoList) {
            if (paramInfo.getParamKbn() == RngConst.API_PARAMKBN_FORM) {
                //フォーム要素の場合
                for (FormCell cell : cellList) {
                    if (paramInfo.getParamFormId().equals(cell.getFormID())) {
                        paramInfo.setParamFormName(cell.getTitle());
                        paramInfo.setParamFormType(cell.getType().getValue());
                    }
                }
            }
        }
    }
}