package jp.groupsession.v2.rng.rng320;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;

import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.RngValidate;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.RngApiConnectParamModel;
import jp.groupsession.v2.rng.model.RngRapParamModel;
import jp.groupsession.v2.rng.rng310.Rng310Form;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] アクションパラメータ登録/編集画面のフォームクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng320Form extends Rng310Form {

    /** アクションパラメータ名称 */
    private String rng320ActionParamName__ = null;
    /** 実行条件区分（0: 全てを満たす, 1:　いずれかを満たす）*/
    private int rng320ExecuteConditionKbn__ = RngConst.EXECUTE_CONDITION_AND;
    /** 実行条件リスト */
    private List<String> rng320ExecuteConditionList__ = null;
    /** 実行条件不備フラグ（0:不備なし, 1:不備あり） */
    private int rng320ExecuteConditionWarnFlg__ = RngConst.ACTIONPARAM_WARN_FLG_NO;
    /** パスパラメータ情報リスト */
    private List<RngApiConnectParamModel> rng320PathParamList__ = null;
    /** パスパラメータ設定値マップ */
    private TreeMap<Integer, RngRapParamModel> rng320PathParamMap__ = new TreeMap<>();
    /** クエリパラメータ情報リスト */
    private List<RngApiConnectParamModel> rng320QueryParamList__ = null;
    /** クエリパラメータ設定値マップ */
    private TreeMap<Integer, RngRapParamModel> rng320QueryParamMap__ = new TreeMap<>();
    /** リクエストボディパラメータ情報リスト */
    private List<RngApiConnectParamModel> rng320ReqBodyParamList__ = null;
    /** リクエストボディパラメータ設定値マップ */
    private TreeMap<Integer, RngRapParamModel> rng320ReqBodyParamMap__ = new TreeMap<>();
    /** 繰り返し実行区分 */
    private int rng320RepeatKbn__ = RngConst.API_REPEAT_KBN_OFF;
    /** 繰り返し実行種別 */
    private int rng320RepeatType__ = RngConst.API_REPEAT_TYPE_FORM;
    /** 繰り返し実行対象表要素内フォームID */
    private List<String> rng320RepeatFormIdList__ = null;
    /** アクションパラメータ処理モード */
    private int rng320ActionParamCmdMode__ = RngConst.ACTIONPARAM_MODE_ADD;

    /**
     * <p>getRng320PathParam[index] を取得します。
    * @param index 添字
    * @return getRng320PathParam[index]
    */
    public RngRapParamModel getRng320PathParam(int index) {
        if (!rng320PathParamMap__.containsKey(index)) {
            rng320PathParamMap__.put(index, new RngRapParamModel());
        }
        return rng320PathParamMap__.get(index);
    }
    /**
     * <p>getRng320QueryParam[index] を取得します。
    * @param index 添字
    * @return getRng320QueryParam[index]
    */
    public RngRapParamModel getRng320QueryParam(int index) {
        if (!rng320QueryParamMap__.containsKey(index)) {
            rng320QueryParamMap__.put(index, new RngRapParamModel());
        }
        return rng320QueryParamMap__.get(index);
    }
    /**
     * <p>getRng320ReqBodyParam[index] を取得します。
    * @param index 添字
    * @return getRng320ReqBodyParam[index]
    */
    public RngRapParamModel getRng320ReqBodyParam(int index) {
        if (!rng320ReqBodyParamMap__.containsKey(index)) {
            rng320ReqBodyParamMap__.put(index, new RngRapParamModel());
        }
        return rng320ReqBodyParamMap__.get(index);
    }
    /**
     * @return the rng320ActionParamName
    */
    public String getRng320ActionParamName() {
        return rng320ActionParamName__;
    }
    /**
     * @param rng320ActionParamName the rng320ActionParamName to set
    */
    public void setRng320ActionParamName(String rng320ActionParamName) {
        rng320ActionParamName__ = rng320ActionParamName;
    }
    /**
     * @return the rng320ExecuteConditionKbn
    */
    public int getRng320ExecuteConditionKbn() {
        return rng320ExecuteConditionKbn__;
    }
    /**
     * @param rng320ExecuteConditionKbn the rng320ExecuteConditionKbn to set
    */
    public void setRng320ExecuteConditionKbn(int rng320ExecuteConditionKbn) {
        rng320ExecuteConditionKbn__ = rng320ExecuteConditionKbn;
    }
    /**
     * @return the rng320ExecuteConditionList
    */
    public List<String> getRng320ExecuteConditionList() {
        return rng320ExecuteConditionList__;
    }
    /**
     * @param rng320ExecuteConditionList the rng320ExecuteConditionList to set
    */
    public void setRng320ExecuteConditionList(
            List<String> rng320ExecuteConditionList) {
        rng320ExecuteConditionList__ = rng320ExecuteConditionList;
    }

    /**
     * @return the rng320QueryParamList
    */
    public List<RngApiConnectParamModel> getRng320QueryParamList() {
        return rng320QueryParamList__;
    }
    /**
     * @param rng320QueryParamList the rng320QueryParamList to set
    */
    public void setRng320QueryParamList(
            List<RngApiConnectParamModel> rng320QueryParamList) {
        rng320QueryParamList__ = rng320QueryParamList;
    }
    /**
     * @return the rng320ReqBodyParamList
    */
    public List<RngApiConnectParamModel> getRng320ReqBodyParamList() {
        return rng320ReqBodyParamList__;
    }
    /**
     * @param rng320ReqBodyParamList the rng320ReqBodyParamList to set
    */
    public void setRng320ReqBodyParamList(
            List<RngApiConnectParamModel> rng320ReqBodyParamList) {
        rng320ReqBodyParamList__ = rng320ReqBodyParamList;
    }
    /**
     * @return the rng320PathParamList
    */
    public List<RngApiConnectParamModel> getRng320PathParamList() {
        return rng320PathParamList__;
    }
    /**
     * @param rng320PathParamList the rng320PathParamList to set
    */
    public void setRng320PathParamList(
            List<RngApiConnectParamModel> rng320PathParamList) {
        rng320PathParamList__ = rng320PathParamList;
    }
    /**
     * @return the rng320PathParamMap
    */
    public TreeMap<Integer, RngRapParamModel> getRng320PathParamMap() {
        return rng320PathParamMap__;
    }
    /**
     * @param rng320PathParamMap the rng320PathParamMap to set
    */
    public void setRng320PathParamMap(
            TreeMap<Integer, RngRapParamModel> rng320PathParamMap) {
        rng320PathParamMap__ = rng320PathParamMap;
    }
    /**
     * @return the rng320QueryParamMap
    */
    public TreeMap<Integer, RngRapParamModel> getRng320QueryParamMap() {
        return rng320QueryParamMap__;
    }
    /**
     * @param rng320QueryParamMap the rng320QueryParamMap to set
    */
    public void setRng320QueryParamMap(
            TreeMap<Integer, RngRapParamModel> rng320QueryParamMap) {
        rng320QueryParamMap__ = rng320QueryParamMap;
    }
    /**
     * @return the rng320ReqBodyParamMap
    */
    public TreeMap<Integer, RngRapParamModel> getRng320ReqBodyParamMap() {
        return rng320ReqBodyParamMap__;
    }
    /**
     * @param rng320ReqBodyParamMap the rng320ReqBodyParamMap to set
    */
    public void setRng320ReqBodyParamMap(
            TreeMap<Integer, RngRapParamModel> rng320ReqBodyParamMap) {
        rng320ReqBodyParamMap__ = rng320ReqBodyParamMap;
    }
    /**
     * @return the rng320RepeatKbn
    */
    public int getRng320RepeatKbn() {
        return rng320RepeatKbn__;
    }
    /**
     * @param rng320RepeatKbn the rng320RepeatKbn to set
    */
    public void setRng320RepeatKbn(int rng320RepeatKbn) {
        rng320RepeatKbn__ = rng320RepeatKbn;
    }
    /**
     * @return the rng320RepeatType
    */
    public int getRng320RepeatType() {
        return rng320RepeatType__;
    }
    /**
     * @param rng320RepeatType the rng320RepeatType to set
    */
    public void setRng320RepeatType(int rng320RepeatType) {
        rng320RepeatType__ = rng320RepeatType;
    }
    /**
     * @return the rng320RepeatFormIdList
    */
    public List<String> getRng320RepeatFormIdList() {
        return rng320RepeatFormIdList__;
    }
    /**
     * @param rng320RepeatFormIdList the rng320RepeatFormIdList to set
    */
    public void setRng320RepeatFormIdList(List<String> rng320RepeatFormIdList) {
        rng320RepeatFormIdList__ = rng320RepeatFormIdList;
    }
    /**
     * @return the rng320ActionParamCmdMode
    */
    public int getRng320ActionParamCmdMode() {
        return rng320ActionParamCmdMode__;
    }
    /**
     * @param rng320ActionParamCmdMode the rng320ActionParamCmdMode to set
    */
    public void setRng320ActionParamCmdMode(int rng320ActionParamCmdMode) {
        rng320ActionParamCmdMode__ = rng320ActionParamCmdMode;
    }
    /**
     * @return the rng320ExecuteConditionWarnFlg
    */
    public int getRng320ExecuteConditionWarnFlg() {
        return rng320ExecuteConditionWarnFlg__;
    }
    /**
     * @param rng320ExecuteConditionWarnFlg the rng320ExecuteConditionWarnFlg to set
    */
    public void setRng320ExecuteConditionWarnFlg(
            int rng320ExecuteConditionWarnFlg) {
        rng320ExecuteConditionWarnFlg__ = rng320ExecuteConditionWarnFlg;
    }

    /**
     * <br>[機  能] パラメータの入力チェックを行う
     * <br>[解  説]
     * <br>[備  考]
     * @param paramKbn パラメータ区分（0:パスパラメータ, 1:クエリパラメータ, 2:リクエストボディ）
     * @param reqMdl リクエスト情報
     * @param con コネクション
     * @return エラー文字列リスト
     * @throws SQLException
     * @throws IOToolsException
     */
    public List<String> validateCheckForParam(
        int paramKbn,
        RequestModel reqMdl,
        Connection con) throws SQLException, IOToolsException {

        RngValidate rngValidate = new RngValidate(new GsMessage(reqMdl));
        List<String> errors = new ArrayList<String>();
        List<RngRapParamModel> rapParamMdlList = new ArrayList<RngRapParamModel>();
        if (paramKbn == GSConstCommon.PARAM_KBN_PATH) {
            rapParamMdlList
                = getRng320PathParamMap().values().stream().collect(Collectors.toList());
        } else if (paramKbn == GSConstCommon.PARAM_KBN_QUERY) {
            rapParamMdlList
                = getRng320QueryParamMap().values().stream().collect(Collectors.toList());
        } else if (paramKbn == GSConstCommon.PARAM_KBN_BODY) {
            rapParamMdlList
                = getRng320ReqBodyParamMap().values().stream().collect(Collectors.toList());
        }
        RngTemplateActionFileBiz fileBiz = new RngTemplateActionFileBiz(reqMdl);
        AddRngActionModel araMdl = fileBiz.getActionModel(getRng090SelectActionIndex());
        errors = rngValidate.validateParam(
                errors,
                rapParamMdlList,
                araMdl,
                getRng090templateJSON(),
                paramKbn,
                con,
                reqMdl);

        return errors
            .stream()
            .distinct()
            .collect(Collectors.toList());
    }
}