package jp.groupsession.v2.rng.rng330;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;

import jp.co.sjts.util.Encoding;
import jp.co.sjts.util.NullDefault;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.http.TempFileUtil;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.groupsession.v2.cmn.GSConstLog;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.GroupSession;
import jp.groupsession.v2.cmn.biz.CommonBiz;
import jp.groupsession.v2.cmn.cmn999.Cmn999Form;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.dao.RngTemplateDao;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.rng.rng020.Rng020Action;
import jp.groupsession.v2.rng.rng020.Rng020Biz;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 連携API実行テスト画面のアクションクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng330Action extends Rng020Action {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(Rng330Action.class);
    /** 添付ファイルディレクトリID*/
    public static final String TEMPDIRID = "rng330";
    /** 添付ファイル サブディレクトリID 経路*/
    public static final String TEMPDIRID_SUB_KEIRO = "keiro";
    /** 添付ファイル サブディレクトリID リクエスト実行用*/
    public static final String TEMPDIRID_SUB_REQUEST = "request";

    /**
     * <br>[機  能] ディレクトリIDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return ディレクトリID
     */
    @Override
    protected String _getTempDirId() {
        return TEMPDIRID;
    }

    /**
     * <br>[機  能] アクションを実行する
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form ActionForm
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward executeAction(
        ActionMapping map,
        ActionForm form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

         ActionForward forward = null;

        Rng330Form thisForm = (Rng330Form) form;

        //コマンドパラメータ取得
        String cmd = NullDefault.getString(req.getParameter("CMD"), "");
        log__.debug("CMD = " + cmd);

        if (cmd.equals("reload")) {
            log__.debug("再読み込み");
            forward = __doDsp(map, thisForm, req, res, con);
        } else if (cmd.equals("templateFileDownload")) {
            log__.debug("添付ファイルダウンロード");
            forward = __doDownLoad(map, thisForm, req, res, con);
        } else if (cmd.equals("closeWindow")) {
            log__.debug("閉じるボタン");
            __delTempDir(req, res);
        } else if (cmd.equals("changeSinseisyaGroup")) {
            //申請者のグループコンボ変更
            __changeSinseisyaGroup(thisForm, req, res, con);
        } else if (cmd.equals("changeSyouninsyaGroup")) {
            //承認者のグループコンボ変更
            __changeSyouninsyaGroup(thisForm, req, res, con);
        } else if (cmd.equals("createRequest")) {
            //リクエスト情報を作成を押下
            __createRequest(thisForm, req, res, con);
        } else if (cmd.equals("doTest")) {
            //実行ボタンを押下
            __doTest(thisForm, req, res, con);
        } else {
            forward = __doInit(map, thisForm, req, res, con);
        }
        return forward;
    }

    /**
     * <br>[機  能] 画面を初期描画する。
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng330Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doInit(
        ActionMapping map,
        Rng330Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        //テンポラリディレクトリの削除
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.deleteTempPath(getRequestModel(req), getPluginId(), "rng330");

        tempUtil.createTempDir(getRequestModel(req), getPluginId(), "rng330", TEMPDIRID_SUB_KEIRO);
        tempUtil.createTempDir(
            getRequestModel(req), getPluginId(), "rng330", TEMPDIRID_SUB_REQUEST);

        Rng330Biz biz = new Rng330Biz(getRequestModel(req));
        Rng330ParamModel paramMdl = new Rng330ParamModel();
        paramMdl.setParam(form);
        //初期表示時のみ設定を行う
        biz.setInitData(paramMdl, con);
        //表示情報を設定
        biz.setDspData(
            paramMdl, getAppRootPath(), _getRingiDir(req), con, true, getSessionUserModel(req));
        if (paramMdl.getRng330RenkeiApiCombo() == null) {
            return __displayNoApi(map, req);
        }
        paramMdl.setFormData(form);

        return map.getInputForward();
    }

    /**
     * <br>[機  能] 画面を表示する。
     * <br>[解  説]
     * <br>[備  考]
     * @param map ActionMapping
     * @param form Rng330Form
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @param con DB Connection
     * @return ActionForward
     * @throws Exception 実行時例外
     */
    public ActionForward __doDsp(
        ActionMapping map,
        Rng330Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws Exception {

        Rng330Biz biz = new Rng330Biz(getRequestModel(req));
        Rng330ParamModel paramMdl = new Rng330ParamModel();
        paramMdl.setParam(form);
        biz.setDspData(
            paramMdl, getAppRootPath(), _getRingiDir(req), con, false, getSessionUserModel(req));
        if (paramMdl.getRng330RenkeiApiCombo() == null) {
            return __displayNoApi(map, req);
        }
        paramMdl.setFormData(form);

        return map.getInputForward();
    }

    /**
     * <br>[機  能] 実行可能な連携APIが存在しない旨をcmn999画面で表示する
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param req リクエスト
     * @return アクションフォワード
     * @throws Exception 実行時例外
     */
    private ActionForward __displayNoApi(
        ActionMapping map, HttpServletRequest req) throws Exception {

        Cmn999Form cmn999Form = null;
        cmn999Form = new Cmn999Form("javascript:window.close();");
        cmn999Form.setWtarget(Cmn999Form.WTARGET_SELF);
        cmn999Form.setType_popup(Cmn999Form.POPUP_TRUE);
        cmn999Form.setType(Cmn999Form.TYPE_OK);
        cmn999Form.setIcon(Cmn999Form.ICON_INFO);

        // メッセージのセット
        GsMessage gsMsg = new GsMessage(getRequestModel(req));
        cmn999Form.setMessage(gsMsg.getMessage("rng.rng330.9"));

        // 画面パラメータをセット
        req.setAttribute("cmn999Form", cmn999Form);
        ActionForward forward = map.findForward("gf_msg");
        return forward;
    }

    /**
     * <br>[機  能] 添付ファイルダウンロードの処理
     * <br>[解  説]
     * <br>[備  考]
     * @param map アクションマッピング
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws SQLException SQL実行例外
     * @throws Exception 実行時例外
     * @return ActionForward
     */
    private ActionForward __doDownLoad(
        ActionMapping map,
        Rng330Form form,
        HttpServletRequest req,
        HttpServletResponse res,
        Connection con) throws SQLException, Exception {

        RequestModel reqMdl = getRequestModel(req);
        CommonBiz cmnBiz = new CommonBiz();
        Rng020Biz biz = new Rng020Biz(con, reqMdl);
        RngBiz rngBiz = new RngBiz(con);

        Long binSid = Long.valueOf(NullDefault.getLong(form.getRng020TemplateFileId(), -1));
        int  rtpSid = form.getRng020rtpSid();

        // 添付ファイルがダウンロード可能かチェックする
        if (biz.isCheckDLSampleTemp(rtpSid, binSid)) {
            CmnBinfModel cbMdl = cmnBiz.getBinInfo(con, binSid,
                    GroupSession.getResourceManager().getDomain(req));
            if (cbMdl != null) {
                GsMessage gsMsg = new GsMessage(getRequestModel(req));
                String msg = gsMsg.getMessage("cmn.download");
                //ログ出力処理
                StringBuilder sb = new StringBuilder();
                // ファイル名
                sb.append("[" + gsMsg.getMessage("cmn.file.name") + "] ");
                sb.append(cbMdl.getBinFileName());
                sb.append(System.getProperty("line.separator"));
                // 使用テンプレート
                RngTemplateDao rngTempDao = new RngTemplateDao(con);
                RngTemplateModel rngTempModel = rngTempDao.select(rtpSid);
                if (rngTempModel == null) {
                    rngTempModel = new RngTemplateModel();
                }
                sb.append("[" + gsMsg.getMessage("cmn.template") + "] ");
                sb.append(rngTempModel.getRtpTitle());
                rngBiz.outPutLog(
                        map,
                        msg, GSConstLog.LEVEL_INFO, sb.toString(),
                        getRequestModel(req));
                //時間のかかる処理の前にコネクションを破棄
                JDBCUtil.closeConnectionAndNull(con);
                //ファイルをダウンロードする
                TempFileUtil.downloadAtachment(req, res, cbMdl, getAppRootPath(),
                        Encoding.UTF_8);
            }
        } else {
            return getSubmitErrorPage(map, req);
        }
        return null;
    }

    /**
     * <br>[機  能] 閉じるボタン押下時、テンポラリディレクトリを削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param req リクエスト
     * @param res レスポンス
     * @throws IOException
     */
    private void __delTempDir(
        HttpServletRequest req,
        HttpServletResponse res) {

        //テンポラリディレクトリの削除
        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();
        tempUtil.deleteTempPath(getRequestModel(req), getPluginId(), "rng330");

        //実行結果をJSON形式で返す
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode json = mapper.createObjectNode();
        json.put("success", true);
        //jsonData.element("success", true);
        __writeResp(res, json.toString());
    }

    /**
     * <br>[機  能] 申請者のグループコンボを変更時、そのグループに所属するユーザ情報を返す
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws SQLException
     * @throws JsonProcessingException
     * @throws IOException
     */
    private void __changeSinseisyaGroup(
        Rng330Form form, HttpServletRequest req,
        HttpServletResponse res, Connection con) throws SQLException, JsonProcessingException {

        //実行結果をJSON形式で返す
        Rng330Biz biz = new Rng330Biz(getRequestModel(req));
        String userJson = biz.getUserJson(form.getRng330ApplicantGroup(), con);
        __writeResp(res, userJson);
    }

    /**
     * <br>[機  能] 承認者のグループコンボを変更時、そのグループに所属するユーザ情報を返す
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws SQLException
     * @throws JsonProcessingException
     * @throws IOException
     */
    private void __changeSyouninsyaGroup(
        Rng330Form form, HttpServletRequest req,
        HttpServletResponse res, Connection con) throws SQLException, JsonProcessingException {

        //実行結果をJSON形式で返す
        Rng330Biz biz = new Rng330Biz(getRequestModel(req));
        String userJson = biz.getUserJson(form.getRng330ApproverGroup(), con);
        __writeResp(res, userJson);
    }

    /**
     * <br>[機  能] 入力された情報から、リクエスト情報を作成する
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws TempFileException
     * @throws IOToolsException
     * @throws SQLException
     * @throws JsonProcessingException
     * @throws IOException
     * @throws TransformerException
     * @throws InterruptedException
     * @throws EncryptionException
     */
    private void __createRequest(
        Rng330Form form, HttpServletRequest req,
        HttpServletResponse res, Connection con)
        throws SQLException, IOException, IOToolsException,
        TempFileException, EncryptionException, InterruptedException, TransformerException {

        RequestModel reqMdl = getRequestModel(req);
        List<String> errors = form.validateCheck(reqMdl, getResources(req));
        if (!errors.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("success", true);
            String errorMessage = String.join("<br>", errors);
            node.put("errorMessage", errorMessage);
            __writeResp(res, node.toString());
            return;
        }

        //実行結果をJSON形式で返す
        Rng330ParamModel paramMdl = new Rng330ParamModel();
        paramMdl.setParam(form);

        GSTemporaryPathUtil tempUtil = GSTemporaryPathUtil.getInstance();

        tempUtil.deleteTempPath(reqMdl, getPluginId(), "rng330", TEMPDIRID_SUB_REQUEST);
        tempUtil.createTempDir(reqMdl, getPluginId(), "rng330", TEMPDIRID_SUB_REQUEST);

        Rng330Biz biz = new Rng330Biz(reqMdl);
        List<File> dirList = IOTools.getDirs(_getRingiDir(req).getTempPath());

        GSTemporaryPathModel tempMdl = _getRingiDir(req);
        String path = tempMdl.getTempPath() + "request" + File.separator;
        if (dirList != null && !dirList.isEmpty()) {
            for (File dir : dirList) {
                if (Objects.equals(TEMPDIRID_SUB_REQUEST, dir.getName())) {
                    continue;
                }
                IOTools.copyDir(dir, new File(path + dir.getName()));
            }
        }

        GSTemporaryPathModel tempDir = GSTemporaryPathModel.getInstance(
            reqMdl, getPluginId(), _getTempDirId(), TEMPDIRID_SUB_REQUEST);
        String json = biz.createRequest(paramMdl, getAppRootPath(), tempDir, con);
        __writeResp(res, json);
    }

    /**
     * <br>[機  能] APIを実行する
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param form アクションフォーム
     * @param req リクエスト
     * @param res レスポンス
     * @param con コネクション
     * @throws TempFileException
     * @throws IOToolsException
     * @throws SQLException
     * @throws JsonProcessingException
     * @throws IOException
     * @throws TransformerException
     * @throws InterruptedException
     * @throws EncryptionException
     */
    private void __doTest(
        Rng330Form form, HttpServletRequest req,
        HttpServletResponse res, Connection con)
        throws SQLException, IOException, IOToolsException,
        TempFileException, EncryptionException, InterruptedException, TransformerException {

        //実行結果をJSON形式で返す
        Rng330ParamModel paramMdl = new Rng330ParamModel();
        paramMdl.setParam(form);
        RequestModel reqMdl = getRequestModel(req);
        Rng330Biz biz = new Rng330Biz(reqMdl);
        GSTemporaryPathModel tempDir = GSTemporaryPathModel.getInstance(
            reqMdl, getPluginId(), _getTempDirId(), TEMPDIRID_SUB_REQUEST);
        String apiResult = biz.executeTest(paramMdl, tempDir.getTempPath());

        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("success", true);
        node.put("response", apiResult);
        __writeResp(res, node.toPrettyString());
    }

    /**
     *
     * <br>[機  能] jsonレスポンスの書き込み処理
     * <br>[解  説]
     * <br>[備  考]
     * @param res レスポンス
     * @param json json文字列
     */
    private void __writeResp(HttpServletResponse res, String json) {
        PrintWriter out = null;
        try {
            res.setHeader("Cache-Control", "no-cache");
            res.setContentType("application/json;charset=UTF-8");
            out = res.getWriter();
            out.print(json);
            out.flush();
        } catch (IOException e) {
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }
}
