package jp.groupsession.v2.rng.rng330;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.http.HttpTimeoutException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import javax.xml.transform.TransformerException;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.LabelValueBean;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.StringUtilHtml;
import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.date.UDate;
import jp.co.sjts.util.date.UDateUtil;
import jp.co.sjts.util.encryption.EncryptionException;
import jp.co.sjts.util.io.IOTools;
import jp.co.sjts.util.io.IOToolsException;
import jp.co.sjts.util.io.ObjectFile;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.GSConstCommon;
import jp.groupsession.v2.cmn.GSTemporaryPathUtil;
import jp.groupsession.v2.cmn.biz.GroupBiz;
import jp.groupsession.v2.cmn.biz.UserBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiConnectBiz;
import jp.groupsession.v2.cmn.biz.apiconnect.ApiExecuter;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumContentType;
import jp.groupsession.v2.cmn.biz.apiconnect.EnumMethod;
import jp.groupsession.v2.cmn.cmn110.Cmn110FileModel;
import jp.groupsession.v2.cmn.dao.BaseUserModel;
import jp.groupsession.v2.cmn.dao.GroupDao;
import jp.groupsession.v2.cmn.dao.base.CmnApiConnectDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmDao;
import jp.groupsession.v2.cmn.dao.base.CmnUsrmInfDao;
import jp.groupsession.v2.cmn.exception.TempFileException;
import jp.groupsession.v2.cmn.formbuilder.EnumFormModelKbn;
import jp.groupsession.v2.cmn.formbuilder.FormAccesser;
import jp.groupsession.v2.cmn.formbuilder.FormCell;
import jp.groupsession.v2.cmn.formbuilder.FormInputBuilder;
import jp.groupsession.v2.cmn.formbuilder.FormInputInitPrefarence;
import jp.groupsession.v2.cmn.formmodel.Block;
import jp.groupsession.v2.cmn.formmodel.BlockList;
import jp.groupsession.v2.cmn.formmodel.Temp;
import jp.groupsession.v2.cmn.http.HttpPart;
import jp.groupsession.v2.cmn.http.HttpResponseModel;
import jp.groupsession.v2.cmn.model.GSTemporaryPathModel;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.cmn.model.base.CmnApiConnectModel;
import jp.groupsession.v2.cmn.model.base.CmnBinfModel;
import jp.groupsession.v2.cmn.model.base.CmnGroupmModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmInfModel;
import jp.groupsession.v2.cmn.model.base.CmnUsrmModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.apiconnect.RngApiExecuteBiz;
import jp.groupsession.v2.rng.biz.RngBiz;
import jp.groupsession.v2.rng.biz.RngTemplateActionFileBiz;
import jp.groupsession.v2.rng.model.AddRngActionModel;
import jp.groupsession.v2.rng.model.AddRngActionParamModel;
import jp.groupsession.v2.rng.model.RingiIdModel;
import jp.groupsession.v2.rng.model.RingiRequestModel;
import jp.groupsession.v2.rng.model.RngActionparamModel;
import jp.groupsession.v2.rng.model.RngFormdataModel;
import jp.groupsession.v2.rng.model.RngRndataModel;
import jp.groupsession.v2.rng.model.RngTemplateActionModel;
import jp.groupsession.v2.rng.model.RngTemplateModel;
import jp.groupsession.v2.struts.msg.GsMessage;
import jp.groupsession.v2.usr.model.UsrLabelValueBean;

/**
 * <br>[機  能] 連携API実行テスト画面のビジネスロジッククラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng330Biz {

    /** ログ */
    private static Log log__ = LogFactory.getLog(Rng330Biz.class);
    /** サンプル用添付ファイルダウンロードURL */
    private static final String TEMPFILE_DOWNLOAD_URL =
        "../ringi/rng330.do?CMD=templateFileDownload&rng330TemplateFileId={binSid}&rng020rtpSid=";
    /** リクエスト情報 */
    protected RequestModel reqMdl__ = null;

    /**
     * <br>[機  能] コンストラクタ
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     */
    public Rng330Biz(RequestModel reqMdl) {
        reqMdl__ = reqMdl;
    }

    /**
     * <br>[機  能] 初期描画時にデータをセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng330ParamModel
     * @param con コネクション
     * @throws IOToolsException
     * @throws SQLException
     */
    public void setInitData(Rng330ParamModel paramMdl, Connection con) throws SQLException {
        //タイトル初期値の反映
        paramMdl.setRng020Title(paramMdl.getRng330rngTitle());

        //申請, 承認ユーザの初期値設定
        int usrSid = reqMdl__.getSmodel().getUsrsid();
        paramMdl.setRng330ApplicantUser(usrSid);
        paramMdl.setRng330ApproverUser(usrSid);
        GroupBiz groupBiz = new GroupBiz();
        int groupSid = groupBiz.getDefaultGroupSid(usrSid, con);
        paramMdl.setRng330ApplicantGroup(groupSid);
        paramMdl.setRng330ApproverGroup(groupSid);

        //申請，承認日時の初期値設定
        UDate now = new UDate();
        String sinseiDateStr = UDateUtil.getSlashYYMD(now);
        paramMdl.setRng330ApplicationDate(sinseiDateStr);

        UDate syouninDate = new UDate();
        syouninDate.addDay(3);
        String syouninDateStr = UDateUtil.getSlashYYMD(syouninDate);
        paramMdl.setRng330ApprovalDate(syouninDateStr);

        String timeStr = UDateUtil.getSeparateHM(now);
        paramMdl.setRng330ApplicationTime(timeStr);
        paramMdl.setRng330ApprovalTime(timeStr);
    }

    /**
     * <br>[機  能] 描画用データをセットする。
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng330ParamModel
     * @param appRoot アプリケーションのルートパス
     * @param tempDir テンポラリディレクトリパス
     * @param con コネクション
     * @param first 初期描画フラグ
     * @param userMdl ユーザ情報モデル
     * @throws IOToolsException
     * @throws SQLException
     */
    public void setDspData(
        Rng330ParamModel paramMdl,
        String appRoot,
        GSTemporaryPathModel tempDir,
        Connection con,
        boolean first,
        BaseUserModel userMdl) throws SQLException, IOToolsException {

        GsMessage gsMsg = new GsMessage(reqMdl__);

        //連携APIコンボをセット
        RngTemplateActionFileBiz templateBiz = new RngTemplateActionFileBiz(reqMdl__);
        List<AddRngActionModel> actionList = templateBiz.getActionModelList();
        CmnApiConnectDao cacDao = new CmnApiConnectDao(con);
        List<CmnApiConnectModel> apiList = cacDao.selectExist();
        Map<Integer, CmnApiConnectModel> apiMap = apiList.stream()
            .collect(Collectors.toMap(
                CmnApiConnectModel::getCacSid,
                mdl -> mdl,
                (mdl1, mdl2) -> mdl2)
            );
        //決裁後アクションが未使用 もしくは全てのアクションパラメータが未使用/警告ありの場合は表示対象に入れない
        actionList = actionList.stream()
            .filter(actionMdl -> actionMdl.getUseKbn() == RngConst.API_PARAM_USE)
            .filter(actionMdl -> {
                CmnApiConnectModel apiMdl = apiMap.get(actionMdl.getApiConnectSid());
                if (apiMdl == null || apiMdl.getCacJkbn() == GSConst.JTKBN_DELETE) {
                    return false;
                }
                List<AddRngActionParamModel> paramList = actionMdl.getActionParamList();
                if (paramList == null || paramList.isEmpty()) {
                    return false;
                }
                for (AddRngActionParamModel actionParamMdl : paramList) {
                    try {
                        templateBiz.checkActionParam(
                            actionParamMdl, actionMdl, paramMdl.getRng330templateJSON(), con);
                    } catch (SQLException e) {
                        return false;
                    }
                    if (actionParamMdl.getUseKbn() == RngConst.API_PARAM_USE
                        && actionParamMdl.getWarnFlg() == RngConst.ACTIONPARAM_WARN_FLG_NO) {
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList());
        List<LabelValueBean> renkeiApiCombo = new ArrayList<>();
        for (AddRngActionModel actionMdl : actionList) {
            renkeiApiCombo.add(
                new LabelValueBean(actionMdl.getName(), String.valueOf(actionMdl.getIndex())));
        }
        if (renkeiApiCombo.isEmpty()) {
            //選択可能な連携APIが存在しない場合は処理を終了
            return;
        }
        paramMdl.setRng330RenkeiApiCombo(renkeiApiCombo);

        //経路情報 最終承認者グループコンボ
        GroupBiz groupBiz = new GroupBiz();

        List<LabelValueBean> groupCombo = groupBiz.getGroupCombLabelList(con, true, gsMsg);
        paramMdl.setRng330ApproverGroupCombo(groupCombo);

        //経路情報 最終承認者ユーザコンボをセット
        List<LabelValueBean> approverUsrCombo = new ArrayList<>();
        UserBiz userBiz = new UserBiz();
        List<UsrLabelValueBean> syouninUserList
            = userBiz.getUserLabelListNoSysUser(
                con, new GsMessage(reqMdl__), paramMdl.getRng330ApproverGroup());
        approverUsrCombo.addAll(syouninUserList);
        paramMdl.setRng330ApproverUserCombo(approverUsrCombo);

        //オプション 申請者グループコンボをセット
        paramMdl.setRng330ApplicantGroupCombo(groupCombo);

        //オプション 申請者ユーザコンボをセット（選択してくださいのみ）
        List<LabelValueBean> applicantUsrCombo = new ArrayList<>();
        List<UsrLabelValueBean> sinseiUserList
                = userBiz.getUserLabelListNoSysUser(
                    con, new GsMessage(reqMdl__), paramMdl.getRng330ApplicantGroup());
        applicantUsrCombo.addAll(sinseiUserList);
        paramMdl.setRng330ApplicantUserCombo(applicantUsrCombo);

        // 申請ID 手動入力チェックボックス表示あり
        if (paramMdl.getIdPrefManualEditable() > 0) {
            if (paramMdl.getRng330idPrefManual() == RngConst.RAR_SINSEI_NOT_KYOKA) {
                paramMdl.setIdPrefManualEditable(0);
            }
        }

        String planId = __getSinseiId(con, paramMdl);
        paramMdl.setRng020PlanID(planId);
        paramMdl.setRng020ID(planId);

        //フォーム情報
        paramMdl.setRng020requestUser(userMdl.getUsiseimei());
        paramMdl.setRng020requestUserId(String.valueOf(userMdl.getUsrsid()));
        __setFormInput(paramMdl, appRoot, tempDir, con, first);
    }

    /**
     * <br>[機  能] 発行予定の申請IDを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param con コネクション
     * @param paramMdl パラメータ情報
     * @return 発行予定の申請ID
     * @throws SQLException
     */
    private String __getSinseiId(Connection con, Rng330ParamModel paramMdl) throws SQLException {

        RngBiz rngBiz = new RngBiz(con);
        RingiIdModel idModel = null;
        idModel = rngBiz.getRngidModel(paramMdl.getRng330idSid());
        int idEditable = RngConst.RAR_SINSEI_NOT_KYOKA;
        //稟議ID情報がnullの場合（稟議IDを使用しない場合のみnullが帰る）、稟議IDを使用しない
        if (idModel != null) {
            paramMdl.setIdUseFlg(1);
            idEditable = idModel.getRngManual();
            if (idEditable == RngConst.RAR_SINSEI_MANUAL_TEMPLATE) {
                idEditable = paramMdl.getRng330idPrefManual();
            }
        }
        paramMdl.setIdPrefManualEditable(idEditable);

        // 発行予定の申請ID
        String planId = rngBiz.getNewRngid(
            idModel, null, false, paramMdl.getRngSid(), reqMdl__);
        return planId;
    }

    /**
     * <br>[機  能] フォーム入力情報用の設定を行う
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl Rng330ParamModel
     * @param appRoot アプリケーションのルートパス
     * @param tempDir テンポラリディレクトリパス
     * @param con コネクション
     * @param first 初期描画フラグ
     * @throws IOToolsException
     * @throws SQLException
     */
    private void __setFormInput(
        Rng330ParamModel paramMdl, String appRoot, GSTemporaryPathModel tempDir,
        Connection con, boolean first) throws SQLException, IOToolsException {

        FormInputBuilder builder = paramMdl.getRng020input();
        builder.setFormTable(paramMdl.getRng330templateJSON());

        FormInputInitPrefarence pref = new FormInputInitPrefarence();
        pref.setAppRoot(appRoot);
        pref.setMode(FormInputBuilder.INITMODE_INPUT);
        pref.setUrl(TEMPFILE_DOWNLOAD_URL + paramMdl.getRng020rtpSid());
        pref.setTempDir(tempDir);
        if (first) {
            pref.setLoad(true);
            builder.setInitPrefarence(pref);
            builder.defaultInit();
            builder.dspInit(reqMdl__, con);
        } else {
            pref.setLoad(false);
            builder.setInitPrefarence(pref);
            builder.dspInit(reqMdl__, con);
        }
    }

    /**
     * <br>[機  能] 指定されたグループに所属するユーザを取得する
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param groupSid グループSID
     * @param con コネクション
     * @return 指定されたグループに所属するユーザのJSON
     * @throws SQLException
     * @throws JsonProcessingException
     */
    public String getUserJson(int groupSid, Connection con)
        throws SQLException, JsonProcessingException {

        UserBiz userBiz = new UserBiz();
        List<UsrLabelValueBean> userList
            = userBiz.getUserLabelListNoSysUser(con, new GsMessage(reqMdl__), groupSid);
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.set("userList", mapper.valueToTree(userList));
        node.put("success", true);

        return node.toString();
    }

    /**
     * <br>[機  能] リクエスト情報を作成する
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param paramMdl パラメータ情報
     * @param appRoot アプリケーションルートパス
     * @param tempDir テンポラリディレクトリ
     * @param con コネクション
     * @return 指定されたグループに所属するユーザのJSON
     * @throws SQLException
     * @throws TempFileException
     * @throws IOToolsException
     * @throws IOException
     * @throws TransformerException
     * @throws InterruptedException
     * @throws EncryptionException
     */
    public String createRequest(
        Rng330ParamModel paramMdl, String appRoot, GSTemporaryPathModel tempDir, Connection con)
        throws SQLException, IOException, IOToolsException,
        TempFileException, EncryptionException, InterruptedException, TransformerException {

        log__.info("リクエスト作成処理の開始");
        RngTemplateActionFileBiz templateBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionModel templateActionMdl
            = templateBiz.getActionModel(paramMdl.getRng330RenkeiApi());
        //指定した連携APIが取得できない場合
        if (templateActionMdl == null) {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("success", true);
            node.set("result", mapper.createArrayNode());
            GsMessage gsMsg = new GsMessage(reqMdl__);
            node.put("errorMessage", gsMsg.getMessage("rng.rng330.13"));
            return node.toString();
        }

        Map<FormAccesser, FormCell> formMap = new HashMap<FormAccesser, FormCell>();
        FormInputBuilder fb = paramMdl.getRng020input();
        __setFormInput(paramMdl, appRoot, tempDir, con, false);
        Map<String, Integer> formTypeMap = new HashMap<>();
        fb.makeFormMap(formMap, 0);
        Map<String, List<CmnBinfModel>> kakuninTempMap = __getTestFileMap(reqMdl__, "keiro");

        //繰り返し対象が未入力かを確認
        String repeatNoneJsonText = __createRepeatNoneText(templateActionMdl, fb, kakuninTempMap);
        if (repeatNoneJsonText != null) {
            return repeatNoneJsonText;
        }

        Set<String> childFormSet = new HashSet<>();
        for (Entry<FormAccesser, FormCell> entry : formMap.entrySet()) {
            FormAccesser access = entry.getKey();
            fb.getFormCell(access);
            if (access.getRowNo() > 1) {
                continue;
            }
            FormCell cell = entry.getValue();
            //フォームIDがどのフォームタイプなのかを取得
            formTypeMap.put(cell.getFormID(), cell.getType().getValue());
            if (templateActionMdl.getRepeatKbn() == RngConst.API_REPEAT_KBN_ON
                && templateActionMdl.getRepeatType() == RngConst.API_REPEAT_TYPE_FORM
                && Objects.equals(cell.getFormID(), templateActionMdl.getRepeatFormId())
                && Objects.equals(
                    cell.getType().getValue(), EnumFormModelKbn.blocklist.getValue())) {

                //繰り返し対象の表の中にあるフォームIDを取得
                List<Block> bodyForm = ((BlockList) cell.getBody()).getBodyList();
                bodyForm.stream()
                    .flatMap(block -> block.getFormTable().stream())
                    .flatMap(mdl -> mdl.stream())
                    .forEach(formCell -> {
                        childFormSet.add(formCell.getFormID());
                    });
            }
        }

        String repeatTargetMessage = __getRepeatTargetText(templateActionMdl, formMap);

        RingiRequestModel rngReqMdl = new RingiRequestModel();
        rngReqMdl.setRngSid(-1);
        rngReqMdl.setRngTitle(paramMdl.getRng020Title());
        rngReqMdl.setRngContent("");
        rngReqMdl.setAppRootPath(appRoot);
        rngReqMdl.setTempDir(tempDir.getTempPath());
        rngReqMdl.setUserSid(paramMdl.getRng330ApplicantUser());
        rngReqMdl.setDate(new UDate());

        RngBiz rngBiz = new RngBiz(con);
        List<RngFormdataModel> formList = rngBiz.createTemplateFormList(
            rngReqMdl, paramMdl.getRng020input(), new UDate(), false);

        //決裁後アクション情報の作成
        RngTemplateActionModel rtpaMdl = new RngTemplateActionModel();
        //条件判定などで使用するため、SIDに一意な値を設定
        rtpaMdl.setRtpaSid(templateActionMdl.getIndex());
        rtpaMdl.setCacSid(templateActionMdl.getApiConnectSid());
        rtpaMdl.setRftId(templateActionMdl.getRepeatFormId());
        rtpaMdl.setRtpaName(templateActionMdl.getName());
        rtpaMdl.setRtpaRepeatKbn(templateActionMdl.getRepeatKbn());
        rtpaMdl.setRtpaRepeatType(templateActionMdl.getRepeatType());
        rtpaMdl.setRtpaUseKbn(templateActionMdl.getUseKbn());
        rtpaMdl.setRtpaSort(templateActionMdl.getIndex());

        List<RngActionparamModel> actionParamList = new ArrayList<>();
        templateActionMdl.getActionParamList().stream()
            .forEach(mdl -> {
                RngActionparamModel actionParamMdl = new RngActionparamModel();
                actionParamMdl.setRapConditionJson(mdl.getConditionJson().toString());
                actionParamMdl.setRapName(mdl.getName());
                actionParamMdl.setRapParamJson(mdl.getParamJson().toString());
                //条件判定などでrapSidを使うため、一意な値を設定
                actionParamMdl.setRapSid(mdl.getIndex());
                actionParamMdl.setRtpaSid(rtpaMdl.getRtpaSid());
                actionParamMdl.setRapSort(mdl.getIndex());
                actionParamMdl.setRapUseKbn(mdl.getUseKbn());
                actionParamList.add(actionParamMdl);
            });

        //繰り返し実行対象の中にあるフォームの取得
        Map<String, Set<String>> repeatChildFormMap = new HashMap<>();
        if (templateActionMdl.getRepeatKbn() == 1
            && templateActionMdl.getRepeatType() == 0
            && !StringUtil.isNullZeroString(templateActionMdl.getRepeatFormId())) {
            repeatChildFormMap.put(templateActionMdl.getRepeatFormId(), childFormSet);
        }

        //申請者，承認者，確認時添付，添付ファイルフォームの値を取得
        RngApiExecuteBiz apiBiz = new RngApiExecuteBiz(reqMdl__.getDomain());
        RngRndataModel rngMdl = __createRngModelForTest(paramMdl, con);
        apiBiz.setRngMdl(rngMdl);
        CmnUsrmInfDao cuiDao = new CmnUsrmInfDao(con);
        CmnUsrmDao cuDao = new CmnUsrmDao(con);
        GroupDao groupDao = new GroupDao(con);
        int sinseiUsrSid = paramMdl.getRng330ApplicantUser();
        if (sinseiUsrSid != -1) {
            CmnUsrmInfModel sinseiUsrInfMdl = cuiDao.select(sinseiUsrSid);
            CmnUsrmModel sinseiUsrMdl = cuDao.select(sinseiUsrSid);
            CmnGroupmModel sinseiGroupMdl = groupDao.getDefaultGroup(sinseiUsrSid);
            apiBiz.setSinseiUsrInfMdl(sinseiUsrInfMdl);
            apiBiz.setSinseiUsrMdl(sinseiUsrMdl);
            apiBiz.setGroupMdl(sinseiGroupMdl);
        }
        int syouninUsrSid = paramMdl.getRng330ApproverUser();
        if (syouninUsrSid != -1) {
            CmnUsrmInfModel syouninUsrInfMdl = cuiDao.select(syouninUsrSid);
            CmnUsrmModel syouninUsrMdl = cuDao.select(syouninUsrSid);
            CmnGroupmModel syouninGroupMdl = groupDao.getDefaultGroup(syouninUsrSid);
            apiBiz.setSyouninUsrInfMdl(syouninUsrInfMdl);
            apiBiz.setSyouninUsrMdl(syouninUsrMdl);
            apiBiz.setSyouninGroupMdl(syouninGroupMdl);
        }
        List<CmnBinfModel> kakuninTempList = kakuninTempMap.get("keiro");
        if (kakuninTempList != null) {
            kakuninTempList = kakuninTempList.stream()
                .sorted(Comparator.comparing(mdl -> mdl.getBinFileName().toLowerCase()))
                .collect(Collectors.toList());
        }
        apiBiz.setKakuninTempList(kakuninTempList);

        List<CmnBinfModel> formTempList = new ArrayList<>();
        Map<String, List<CmnBinfModel>> formTempMap = __getTestFileMap(reqMdl__, null);
        for (Entry<String, List<CmnBinfModel>> formTempEntry : formTempMap.entrySet()) {
            formTempList.addAll(formTempEntry.getValue());
        }
        if (formTempList != null) {
            formTempList = formTempList.stream()
                .sorted(Comparator.comparing(mdl -> mdl.getBinFileName().toLowerCase()))
                .collect(Collectors.toList());
        }
        apiBiz.setFormTempList(formTempList);

        RngTemplateModel templateModel = new RngTemplateModel();
        templateModel.setRtpForm(paramMdl.getRng330templateJSON());
        apiBiz.setTemplateModel(templateModel);

        List<RngFormdataModel> fileList = __createFileFormList(rngReqMdl, fb, formTempMap);
        formList.addAll(fileList);

        //入力された情報からリクエスト情報を取得
        List<ApiExecuter> executerList = apiBiz.getTestApiExecuter(
            con, reqMdl__, rtpaMdl, actionParamList,
            formList, formTypeMap, repeatChildFormMap);

        return __getRequestJsonText(paramMdl, executerList, templateActionMdl, repeatTargetMessage);
    }

    /**
     * <br>[機  能] 繰り返し実行対象の表示用文字列を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param templateActionMdl 決裁後アクション情報
     * @param formMap フォーム情報
     * @return 繰り返し対象が未入力の場合：JSON文字列, 繰り返し対象が入力されている場合：null
     * @throws SQLException
     */
    private String __getRepeatTargetText(
        AddRngActionModel templateActionMdl, Map<FormAccesser, FormCell> formMap) {

        if (templateActionMdl.getRepeatKbn() == RngConst.API_REPEAT_KBN_OFF) {
            return null;
        }

        GsMessage gsMsg = new GsMessage(reqMdl__);
        if (templateActionMdl.getRepeatType() == RngConst.API_REPEAT_TYPE_FILE) {
            return gsMsg.getMessage("rng.rng330.12");
        }

        if (formMap == null || formMap.isEmpty()) {
            return null;
        }

        for (Entry<FormAccesser, FormCell> entry : formMap.entrySet()) {
            if (!Objects.equals(
                templateActionMdl.getRepeatFormId(), entry.getValue().getFormID())) {
                continue;
            }
            if (entry.getValue().getType() == EnumFormModelKbn.blocklist) {
                return gsMsg.getMessage("rng.rng330.10");
            } else if (entry.getValue().getType() == EnumFormModelKbn.file) {
                return gsMsg.getMessage("rng.rng330.11");
            }
        }

        return null;
    }

    /**
     * <br>[機  能] 繰り返し対象が未入力の際のJSON文字列を取得する
     * <br>[解  説]
     * <br>[備  考] 繰り返し対象が未入力ではない場合nullを返す
     * @param templateActionMdl 決裁後アクション情報
     * @param fb フォーム入力情報
     * @param kakuninTempMap 確認時添付ファイル情報
     * @return 繰り返し対象が未入力の場合：JSON文字列, 繰り返し対象が入力されている場合：null
     * @throws SQLException
     */
    private String __createRepeatNoneText(
        AddRngActionModel templateActionMdl,
        FormInputBuilder fb, Map<String, List<CmnBinfModel>> kakuninTempMap) {

        if (templateActionMdl.getRepeatKbn() != RngConst.API_REPEAT_KBN_ON) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("success", true);
        node.set("result", mapper.createArrayNode());
        GsMessage gsMsg = new GsMessage(reqMdl__);
        if (templateActionMdl.getRepeatType() == RngConst.API_REPEAT_TYPE_FORM) {
            for (Entry<FormAccesser, FormCell> entry : fb.getFormMap().entrySet()) {
                FormCell formCell = entry.getValue();
                if (formCell == null) {
                    continue;
                }
                if (!Objects.equals(
                    formCell.getFormID(), templateActionMdl.getRepeatFormId())) {
                    continue;
                }
                String repeatTaget =
                    gsMsg.getMessage("rng.rng330.6") + " " + formCell.getTitle();

                if (formCell.getType() == EnumFormModelKbn.blocklist) {
                    BlockList blockList = (BlockList) formCell.getBody();
                    if (blockList.getLength() == 0) {
                        node.put("errorMessage",
                            gsMsg.getMessage("rng.rng330.18", new String[] {repeatTaget}));
                        return node.toString();
                    }
                } else if (formCell.getType() == EnumFormModelKbn.file) {
                    Temp temp = (Temp) formCell.getBody();
                    if (temp.getBinFiles() == null || temp.getBinFiles().isEmpty()) {
                        node.put("errorMessage",
                            gsMsg.getMessage("rng.rng330.18", new String[] {repeatTaget}));
                        return node.toString();
                    }
                }
            }
        } else if (templateActionMdl.getRepeatType() == RngConst.API_REPEAT_TYPE_FILE
            && kakuninTempMap.getOrDefault("keiro", new ArrayList<>()).isEmpty()) {
            String repeatTaget =
                gsMsg.getMessage("rng.27") + " " + gsMsg.getMessage("rng.rng330.4");
            node.put("errorMessage",
                gsMsg.getMessage("rng.rng330.18", new String[] {repeatTaget}));
            return node.toString();
        }
        return null;
    }

    /**
     * <br>[機  能] 実行テストに使用する稟議情報データを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param con コネクション
     * @return 稟議情報データ
     * @throws SQLException
     */
    private RngRndataModel __createRngModelForTest(
        Rng330ParamModel paramMdl, Connection con) throws SQLException {

        RngRndataModel rngMdl = new RngRndataModel();
        rngMdl.setRngTitle(paramMdl.getRng020Title());
        UDate rngAdate = new UDate();
        rngAdate.setZeroHhMmSs();

        String sinseiDateStr = paramMdl.getRng330ApplicationDate();
        if (sinseiDateStr != null
            && ValidateUtil.isSlashDateFormat(sinseiDateStr)
            && ValidateUtil.isExistDateYyyyMMdd(sinseiDateStr.replaceAll("/", ""))) {
            rngAdate = UDate.getInstanceStr(sinseiDateStr);
            rngAdate.setZeroHhMmSs();
        }
        String sinseiTimeStr = paramMdl.getRng330ApplicationTime();
        if (sinseiTimeStr != null
            && ValidateUtil.isTimeFormat(sinseiTimeStr)) {
            String[] sinseiTime = sinseiTimeStr.split(":");
            rngAdate.setHour(Integer.parseInt(sinseiTime[0]));
            rngAdate.setMinute(Integer.parseInt(sinseiTime[1]));
        }
        rngMdl.setRngAdate(rngAdate);

        UDate rngEdate = new UDate();
        rngEdate.setZeroHhMmSs();
        String syouninDateStr = paramMdl.getRng330ApprovalDate();
        if (sinseiDateStr != null
            && ValidateUtil.isSlashDateFormat(sinseiDateStr)
            && ValidateUtil.isExistDateYyyyMMdd(sinseiDateStr.replaceAll("/", ""))) {
            rngEdate = UDate.getInstanceStr(syouninDateStr);
            rngEdate.setZeroHhMmSs();
        }
        String syouninTimeStr = paramMdl.getRng330ApprovalTime();
        if (syouninTimeStr != null
            && ValidateUtil.isTimeFormat(syouninTimeStr)) {
            String[] syouninTime = syouninTimeStr.split(":");
            rngEdate.setHour(Integer.parseInt(syouninTime[0]));
            rngEdate.setMinute(Integer.parseInt(syouninTime[1]));
        }
        rngMdl.setRngEdate(rngEdate);

        if (paramMdl.getRng330ApplicantUser() > -1) {
            rngMdl.setRngApplicate(paramMdl.getRng330ApplicantUser());
        } else {
            rngMdl.setRngApplicate(-1);
        }
        if (paramMdl.getRng330ApproverUser() > -1) {
            rngMdl.setRngEuid(paramMdl.getRng330ApproverUser());
        } else {
            rngMdl.setRngEuid(-1);
        }

        if (paramMdl.getRng020ID() != null) {
            rngMdl.setRngId(paramMdl.getRng020ID());
        } else {
            String sinseiId = __getSinseiId(con, paramMdl);
            rngMdl.setRngId(sinseiId);
        }

        return rngMdl;
    }

    /**
     * <br>[機  能] 実行テストに使用する稟議情報データを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param executerList リクエスト情報一覧
     * @param templateActionMdl 決裁後アクション情報
     * @param repeatTargetMessage 繰り返し実行対象表示文字列
     * @return 稟議情報データ
     * @throws SQLException
     */
    private String __getRequestJsonText(
        Rng330ParamModel paramMdl, List<ApiExecuter> executerList,
        AddRngActionModel templateActionMdl, String repeatTargetMessage) {

        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("success", true);
        ArrayNode arrayNode = mapper.createArrayNode();

        for (ApiExecuter executer : executerList) {
            ObjectNode bodyNode = mapper.createObjectNode();
            bodyNode.put("url", executer.getUrl());
            int methodKbn = executer.getReqMethod();
            bodyNode.put("method", EnumMethod.valueOf(methodKbn).toString());
            bodyNode.put("methodKbn", methodKbn);

            if (executer.getPartList() != null && !executer.getPartList().isEmpty()) {
                ArrayNode partNodeArray = mapper.valueToTree(executer.getPartList());
                bodyNode.set("partList", partNodeArray);
            }

            ArrayNode headerArray = mapper.createArrayNode();
            StringBuilder sb = new StringBuilder();
            for (Entry<String, String> entry : executer.getReqHeader().entrySet()) {
                sb.append(entry.getKey());
                sb.append(": ");
                sb.append(entry.getValue());
                sb.append("\r\n");
                headerArray.add(entry.getKey() + ":" + entry.getValue());
            }
            bodyNode.set("headerList", headerArray);
            if (methodKbn == EnumMethod.POST.getValue()
                || methodKbn == EnumMethod.PUT.getValue()
                || methodKbn == EnumMethod.DELETE.getValue()) {
                sb.append("Content-Type: ");
                sb.append(executer.getContentType());
            }
            bodyNode.put("reqHeader", sb.toString());

            bodyNode.put("contentType", executer.getContentType());

            if (Objects.equals(executer.getContentType(),
                EnumContentType.MULTIPART_FORM_DATA.getLabel())) {
                List<HttpPart> partList = executer.getPartList();
                ArrayNode partArrayNode = mapper.createArrayNode();
                for (HttpPart part : partList) {
                    ObjectNode partNode = mapper.createObjectNode();
                    if (part.getCharset() != null) {
                        partNode.put("charSet", part.getCharset());
                    }
                    if (part.getFileContentType() != null) {
                        partNode.put("fileContentType", part.getFileContentType());
                    }
                    if (part.getFile() != null) {
                        if (part.getFile().getName() != null) {
                            partNode.put("numberFileName", part.getFile().getName());
                        }
                        if (part.getFile().getParentFile() != null) {
                            partNode.put("folderName", part.getFile().getParentFile().getName());
                        }
                    }
                    if (part.getParamName() != null) {
                        partNode.put("paramName", part.getParamName());
                    }
                    if (part.getStrValue() != null) {
                        partNode.put("strValue", part.getStrValue());
                    }
                    partArrayNode.add(partNode);
                }
                bodyNode.set("partList", partArrayNode);

                bodyNode.put("reqBody", __getTempBody(partList));
            } else {
                bodyNode.put("reqBody", executer.getReqBody());
            }

            bodyNode.put("title", paramMdl.getRng020Title());
            bodyNode.put("syouninUsr", paramMdl.getRng330ApproverUser());
            bodyNode.put("syouninDate", paramMdl.getRng330ApprovalDate());
            bodyNode.put("sinseiUsr", paramMdl.getRng330ApplicantUser());
            bodyNode.put("sinseiDate", paramMdl.getRng330ApplicationDate());

            arrayNode.add(bodyNode);
        }
        node.set("result", arrayNode);
        node.put("repeatKbn", templateActionMdl.getRepeatKbn());
        node.put("message", repeatTargetMessage);
        if (arrayNode.isEmpty()) {
            GsMessage gsMsg = new GsMessage(reqMdl__);
            node.put("errorMessage", gsMsg.getMessage("rng.rng330.13"));
        }

        return node.toString();
    }

    /**
     * <br>[機  能] 連携APIを実行する
     * <br>[解  説]
     * <br>[備  考] JSON形式で返す
     * @param paramMdl パラメータ情報
     * @param tempDir テンポラリディレクトリ
     * @return 実行結果文字列
     * @throws InterruptedException
     * @throws IOException
     * @throws SQLException
     * @throws EncryptionException
     * @throws IOToolsException
     */
    public String executeTest(Rng330ParamModel paramMdl, String tempDir)
        throws EncryptionException, SQLException,
        IOException, InterruptedException, IOToolsException {

        String url = paramMdl.getRng330TestUrl();
        int method = paramMdl.getRng330TestMethodKbn();
        Map<String, String> reqMap = null;
        if (paramMdl.getRng330TestHeader() != null) {
            reqMap = Arrays.stream(paramMdl.getRng330TestHeader())
                .map(s -> s.split(":"))
                .collect(Collectors.toMap(header -> header[0], header -> header[1]));
        }
        String contentType = paramMdl.getRng330TestContentType();
        String body = paramMdl.getRng330TestBody();

        List<HttpPart> partList = __getPartList(paramMdl, tempDir);
        ApiExecuter executer = new ApiExecuter(
            url, method, reqMap, contentType, partList, body);

        try {
            HttpResponseModel resMdl = executer.execute();
            ApiConnectBiz apiBiz = new ApiConnectBiz();
            return apiBiz.getApiResultText(resMdl, reqMdl__);
        } catch (HttpTimeoutException e) {
            GsMessage gsMessage = new GsMessage(reqMdl__);
            StringBuilder sb = new StringBuilder();
            sb.append(gsMessage.getMessage("cmn.api.error"));
            sb.append("\r\n");
            sb.append(gsMessage.getMessage("cmn.api.error.timeout"));
            return sb.toString();
        } catch (Exception e) {
            GsMessage gsMessage = new GsMessage(reqMdl__);
            StringBuilder sb = new StringBuilder();
            sb.append(gsMessage.getMessage("cmn.api.error"));
            return sb.toString();
        }
    }

    /**
     * <br>[機  能] 接続テスト用の添付ファイルデータを設定する
     * <br>[解  説]
     * <br>[備  考] APIの実行時に添付ファイルSIDが必要になるため、仮のSIDを割り振る
     * @param rngReqMdl 稟議リクエスト情報
     * @param formModel 入力されたフォーム情報
     * @param formTempMap キー：配置先フォルダ名, 値：添付ファイル一覧
     * @return 添付ファイル情報一覧
     * @throws InvocationTargetException
     * @throws IllegalAccessException
     */
    private List<RngFormdataModel> __createFileFormList(
        RingiRequestModel rngReqMdl, FormInputBuilder formModel,
        Map<String, List<CmnBinfModel>> formTempMap)
        throws SQLException, IOException, IOToolsException,
            TempFileException {

        int rngSid = rngReqMdl.getRngSid();
        int usrSid = rngReqMdl.getUserSid();

        RngFormdataModel rfdModel = null;
        List<RngFormdataModel> rfdMdlList = new ArrayList<RngFormdataModel>();
        UDate now = new UDate();

        //フォームモデル作成
        Map<FormAccesser, FormCell> inputedForm = formModel.getFormMap();
        long binSid = 1;
        for (Map.Entry<FormAccesser, FormCell> entry : inputedForm.entrySet()) {
            rfdModel = new RngFormdataModel();
            FormAccesser accesser = entry.getKey();
            FormCell cell = entry.getValue();

            //稟議SID
            rfdModel.setRngSid(rngSid);
            //フォームSID
            rfdModel.setRfdSid(accesser.getFormSid());
            //フォームID
            rfdModel.setRfdId(cell.getFormID());
            //行番号
            rfdModel.setRfdRowno(accesser.getRowNo());
            //登録者ID
            rfdModel.setRfdAuid(usrSid);
            //登録日
            rfdModel.setRfdAdate(now);
            //更新者ID
            rfdModel.setRfdEuid(usrSid);
            //更新日
            rfdModel.setRfdEdate(now);

            //入力内容
            if (entry.getValue().getType() != null) {
                EnumFormModelKbn type = cell.getType();
                switch (type) {
                    case file:
                        String tempDir = accesser.getFormSid() + "_" + accesser.getRowNo();
                        List<CmnBinfModel> binList = formTempMap.get(tempDir);
                        for (CmnBinfModel binMdl : binList) {
                            RngFormdataModel addMdl = new RngFormdataModel();
                            try {
                                BeanUtils.copyProperties(addMdl, rfdModel);
                            } catch (IllegalAccessException | InvocationTargetException e) {

                            }
                            addMdl.setRfdValue(String.valueOf(binSid));
                            rfdMdlList.add(addMdl);
                            binMdl.setBinSid(binSid);
                            binSid++;
                        }
                        break;
                    default:
                        break;
                }
            }
        }

        return rfdMdlList;
    }

    /**
     * <br>[機  能] 接続テストに使用する添付ファイル情報を取得する
     * <br>[解  説]
     * <br>[備  考] multipart/formdata時のみ実行される
     * @param tempDir テンポラリディレクトリ
     * @return 添付ファイル情報一覧
     * @throws IOToolsException
     */
    private List<CmnBinfModel> __getTestFiles(String tempDir) {

        List<CmnBinfModel> ret = new ArrayList<>();
        try {
            //テンポラリディレクトリにあるファイルを取得
            File[] fileList = IOTools.search(new File(tempDir), null);
            if (fileList != null) {
                for (File file : fileList) {
                    if (file.isDirectory()) {
                        continue;
                    }
                    String fileName = file.getName();
                    if (!fileName.endsWith(GSConstCommon.ENDSTR_SAVEFILE)) {
                        continue;
                    }
                    String filePath = IOTools.replaceFileSep(tempDir + "/" + fileName);
                    CmnBinfModel binMdl = new CmnBinfModel();
                    binMdl.setBinFilePath(filePath);
                    String fileNum = fileName.substring(
                        0, fileName.indexOf(GSConstCommon.ENDSTR_SAVEFILE));

                    //ファイル名を保存しているobjファイルからファイル名を取得
                    ObjectFile objFile = new ObjectFile(
                        tempDir, fileNum + GSConstCommon.ENDSTR_OBJFILE);
                    Object fObj = objFile.load();

                    if (fObj == null) {
                        continue;
                    }
                    Cmn110FileModel fMdl = (Cmn110FileModel) fObj;
                    String name = fMdl.getFileName();
                    binMdl.setBinFileName(
                        StringUtilHtml.transToHTmlPlusAmparsant(name));
                    binMdl.setBinFileExtension(name.substring(name.lastIndexOf(".")));
                    ret.add(binMdl);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    /**
     * <br>[機  能] 接続テストに使用する添付ファイル情報を取得する
     * <br>[解  説]
     * <br>[備  考] multipart/formdata時のみ実行される
     * @param reqMdl リクエスト情報
     * @param subDir サブディレクトリ
     * @return 添付ファイル情報一覧
     * @throws IOToolsException
     */
    private Map<String, List<CmnBinfModel>> __getTestFileMap(
        RequestModel reqMdl, String subDir) throws IOToolsException {

        Map<String, List<CmnBinfModel>> ret = new HashMap<>();
        GSTemporaryPathUtil temp = GSTemporaryPathUtil.getInstance();
        //確認時添付
        if (Objects.equals(subDir, "keiro")) {
            String tempDir = temp.getTempPath(
                reqMdl, RngConst.PLUGIN_ID_RINGI, "rng330", "request", subDir);
            ret.put("keiro", __getTestFiles(tempDir));
            return ret;
        }

        //フォーム形式
        String tempDir = temp.getTempPath(reqMdl, RngConst.PLUGIN_ID_RINGI, "rng330", "request");
        //File[] fileList = IOTools.search(new File(tempDir), null);
        List<File> fileList = IOTools.getDirs(tempDir);
        for (File file : fileList) {
            if (Objects.equals(file.getName(), "keiro")) {
                continue;
            }
            String formTempDir = temp.getTempPath(
                reqMdl, RngConst.PLUGIN_ID_RINGI, "rng330", "request", file.getName());
            ret.put(file.getName(), __getTestFiles(formTempDir));
        }
        return ret;
    }

    /**
     * <br>[機  能] パラメータからmultipart/form-data用のデータを作成する
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param tempDir テンポラリディレクトリ
     * @return 添付ファイル情報一覧
     * @throws IOToolsException
     */
    private List<HttpPart> __getPartList(
        Rng330ParamModel paramMdl, String tempDir) throws IOToolsException {
        Map<Integer, Rng330PartModel> partMap = paramMdl.getRng330partMap();
        if (partMap == null || partMap.isEmpty()) {
            return null;
        }

        List<HttpPart> ret = new ArrayList<>();
        for (Entry<Integer, Rng330PartModel> entrySet : partMap.entrySet()) {
            Rng330PartModel part = entrySet.getValue();
            //テキスト形式の場合
            if (part.getNumberFileName() == null) {
                ret.add(part);
                continue;
            }

            //ファイル形式の場合
            String folderName = part.getFolderName();
            String numberFileName = part.getNumberFileName();
            String path = IOTools.replaceFileSep(tempDir + "/" + folderName);
            part.setFile(new File(IOTools.replaceFileSep(path + "/" + numberFileName)));
            String fileNum = numberFileName.substring(
                0, numberFileName.indexOf(GSConstCommon.ENDSTR_SAVEFILE));

            ObjectFile objFile = new ObjectFile(
                path, fileNum + GSConstCommon.ENDSTR_OBJFILE);
            Object fObj = objFile.load();

            if (fObj == null) {
                continue;
            }
            Cmn110FileModel fMdl = (Cmn110FileModel) fObj;
            part.setFileName(fMdl.getFileName());
            ret.add(part);
        }
        return ret;
    }

    /**
     * <br>[機  能] 添付ファイルのリクエストボディ情報を取得する
     * <br>[解  説]
     * <br>[備  考] multipart/formdata時のみ実行される
     * @param partList HttpPart一覧
     * @return コンテントタイプ文字列
     */
    private String __getTempBody(List<HttpPart> partList) {

        if (partList == null || partList.isEmpty()) {
            return null;
        }
        StringBuilder bodyBuilder = new StringBuilder();
        int idx = 0;
        String boundary = "GroupSessionSeparator";
        GsMessage gsMsg = new GsMessage(reqMdl__);

        for (HttpPart part : partList) {
            if (bodyBuilder.length() > 0) {
                bodyBuilder.append("\r\n");
            }
            bodyBuilder.append("--").append(boundary);
            bodyBuilder.append("\r\n");
            bodyBuilder.append("Content-Disposition: form-data; name=");
            bodyBuilder.append(part.getParamName());

            String charset = "UTF-8";
            if (part.getStrValue() != null) {
                bodyBuilder.append("\r\n");
                bodyBuilder.append("Content-Type: text/plain; charset=");
                if (part.getCharset() != null) {
                    charset = part.getCharset();
                }
                bodyBuilder.append(charset);
                bodyBuilder.append("\r\n\r\n");
                bodyBuilder.append(part.getStrValue());
            } else {
                bodyBuilder.append("; filename=" + part.getFileName());
                bodyBuilder.append("\r\n");
                bodyBuilder.append("Content-Type: ");
                bodyBuilder.append(part.getFileContentType());
                bodyBuilder.append(";");
                bodyBuilder.append("\r\n\r\n");
                bodyBuilder.append("[" + gsMsg.getMessage("cmn.cmn340.86") + "]");
            }
            idx++;
            if (idx == partList.size()) {
                bodyBuilder.append("\r\n" + "--" + boundary + "--");
            }
        }

        return bodyBuilder.toString();
    }

    /**
     * <br>[機  能] 申請者，承認者，タイトルを使用しているかを保持するマップを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param renkeiApi 実行対象の連携APIのSID
     * @return 申請者，承認者，タイトルを使用しているかを保持するマップ
     * @throws JsonProcessingException
     * @throws IOToolsException
     */
    public Map<String, Boolean> getUseFlg(int renkeiApi)
        throws JsonProcessingException, IOToolsException {

        Map<String, Boolean> ret = new HashMap<>();
        ObjectMapper mapper = new ObjectMapper();
        RngTemplateActionFileBiz templateBiz = new RngTemplateActionFileBiz(reqMdl__);
        AddRngActionModel templateActionMdl
            = templateBiz.getActionModel(renkeiApi);
        for (AddRngActionParamModel actionParamMdl : templateActionMdl.getActionParamList()) {
            if (actionParamMdl.getUseKbn() == RngConst.FLG_NOTUSE_ACTIONPARAM) {
                continue;
            }
            JsonNode conditionJson = mapper.readTree(actionParamMdl.getConditionJson().toString());
            __checkUseKbn(conditionJson, ret);
            if (ret.getOrDefault("syouninUsr", false)
                && ret.getOrDefault("sinseiUsr", false)
                && ret.getOrDefault("title", false)) {
                //申請者，承認者，タイトルをすべて使用している場合はその先を確認しない
                return ret;
            }

            JsonNode paramJson = mapper.readTree(actionParamMdl.getParamJson().toString());
            __checkUseKbn(paramJson, ret);
            if (ret.getOrDefault("syouninUsr", false)
                && ret.getOrDefault("sinseiUsr", false)
                && ret.getOrDefault("title", false)) {
                //申請者，承認者，タイトルをすべて使用している場合はその先を確認しない
                return ret;
            }
        }
        return ret;
    }


    /**
     * <br>[機  能] 申請者，承認者，タイトルを使用しているかをチェックし、マップに保存する
     * <br>[解  説]
     * <br>[備  考]
     * @param node json情報
     * @param useFlgMap 申請者，承認者，タイトルを使用しているかを保持するマップ
     * @author JTS
     */
    private void __checkUseKbn(JsonNode node, Map<String, Boolean> useFlgMap) {

        if (node.get("paramKbn") != null) {
            int paramKbn = node.get("paramKbn").asInt();
            if (paramKbn == RngConst.API_PARAMKBN_LETUSER) {
                useFlgMap.put("syouninUsr", true);
            } else if (paramKbn == RngConst.API_PARAMKBN_ADDUSER) {
                useFlgMap.put("sinseiUsr", true);
            } else if (paramKbn == RngConst.API_PARAMKBN_RINGIINFO) {
                if (node.get("paramValue") != null) {
                    int paramValue = node.get("paramValue").asInt();
                    if (paramValue == RngConst.API_PARAMVALUE_TITLE) {
                        useFlgMap.put("title", true);
                    }
                }
            }
        }
        if (useFlgMap.getOrDefault("syouninUsr", false)
            && useFlgMap.getOrDefault("sinseiUsr", false)
            && useFlgMap.getOrDefault("title", false)) {
            //申請者，承認者，タイトルをすべて使用している場合はその先を確認しない
            return;
        }

        if (node.isObject() || node.isArray()) {
            Iterator<JsonNode> elements = node.elements();
            while (elements.hasNext()) {
                JsonNode childNode = elements.next();
                __checkUseKbn(childNode, useFlgMap);
            }
        }
    }
}