package jp.groupsession.v2.rng.rng330;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts.util.LabelValueBean;
import org.apache.struts.util.MessageResources;

import com.fasterxml.jackson.core.JsonProcessingException;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.ValidateUtil;
import jp.co.sjts.util.io.IOToolsException;
import jp.groupsession.v2.cmn.GSConst;
import jp.groupsession.v2.cmn.model.RequestModel;
import jp.groupsession.v2.rng.RngConst;
import jp.groupsession.v2.rng.rng020.Rng020Form;
import jp.groupsession.v2.struts.msg.GsMessage;

/**
 * <br>[機  能] 連携API実行テスト画面のフォームクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author JTS
 */
public class Rng330Form extends Rng020Form {

    /** 稟議タイトル */
    private String rng330rngTitle__ = null;
    /** 申請IDSID*/
    private int rng330idSid__ = 0;
    /** 申請ID 手動入力設定*/
    private int rng330idPrefManual__ = RngConst.RAR_SINSEI_NOT_KYOKA;
    /**
     * @return the rng330rngTitle
     */
    public String getRng330rngTitle() {
        return rng330rngTitle__;
    }
    /**
     * @param rng330rngTitle the rng330rngTitle to set
     */
    public void setRng330rngTitle(String rng330rngTitle) {
        rng330rngTitle__ = rng330rngTitle;
    }
    /**
     * @return the rng330idSid
     */
    public int getRng330idSid() {
        return rng330idSid__;
    }
    /**
     * @param rng330idSid the rng330idSid to set
     */
    public void setRng330idSid(int rng330idSid) {
        rng330idSid__ = rng330idSid;
    }
    /**
     * @return the rng330idPrefManual
     */
    public int getRng330idPrefManual() {
        return rng330idPrefManual__;
    }
    /**
     * @param rng330idPrefManual the rng330idPrefManual to set
     */
    public void setRng330idPrefManual(int rng330idPrefManual) {
        rng330idPrefManual__ = rng330idPrefManual;
    }

    /** 経路情報 最終承認者グループコンボ */
    private List<LabelValueBean> rng330ApproverGroupCombo__ = null;
    /** 経路情報 最終承認者グループ */
    private int rng330ApproverGroup__ = -1;
    /** 経路情報 最終承認者ユーザコンボ */
    private List<LabelValueBean> rng330ApproverUserCombo__ = null;
    /** 経路情報 最終承認者ユーザ */
    private int rng330ApproverUser__ = -1;
    /** 経路情報 最終承認日時 日付 */
    private String rng330ApprovalDate__ = null;
    /** 経路情報 経路情報 最終承認日時 時間*/
    private String rng330ApprovalTime__ = null;

    /** オプション 申請者グループコンボ */
    private List<LabelValueBean> rng330ApplicantGroupCombo__ = null;
    /** オプション請者 申請者グループ */
    private int rng330ApplicantGroup__ = -1;
    /** オプション 申請者ユーザコンボ */
    private List<LabelValueBean> rng330ApplicantUserCombo__ = null;
    /** オプション 申請者ユーザ */
    private int rng330ApplicantUser__ = -1;
    /** オプション 申請日時 日付 */
    private String rng330ApplicationDate__ = null;
    /** オプション 申請日時 時間*/
    private String rng330ApplicationTime__ = null;

    /** 連携APIコンボ */
    private List<LabelValueBean> rng330RenkeiApiCombo__ = null;
    /** 連携API */
    private int rng330RenkeiApi__ = -1;

    /** 入力フォームJSON文字列(共有テンプレート＋新式テンプレートのみ) */
    private String rng330templateJSON__ = null;

    /** 実行テスト URL */
    private String rng330TestUrl__ = null;
    /** 実行テスト リクエストメソッド */
    private int rng330TestMethodKbn__;
    /** 実行テスト コンテントタイプ */
    private String rng330TestContentType__ = null;
    /** 実行テスト リクエストヘッダ */
    private String[] rng330TestHeader__ = null;
    /** 実行テスト リクエストボディ */
    private String rng330TestBody__ = null;

    /** テストに実行する情報を保持するマップ キー：何回目の実行か */
    private Map<Integer, Rng330TestModel> rng330testMap__ = new HashMap<>();
    /** 繰り返し実行か */
    private int rng330testRepeatKbn__ = RngConst.API_REPEAT_KBN_OFF;
    /** 繰り返し実行 何回目の実行か(index) */
    private int rng330testTarget__ = 0;
    /** 繰り返し実行対象の名前 */
    private String rng330testRepeatName__ = null;
    /** マルチパート情報 */
    private Map<Integer, Rng330PartModel> rng330partMap__ = new HashMap<>();

    /** 実行テスト リクエスト情報表示フラグ */
    private int rng330RequestDspFlg__ = GSConst.DSP_NOT;
    /** 実行テスト 実行結果情報 */
    private String rng330TestResult__ = null;

    /**
     * <br>[機  能] 実行対象の連携APIにて申請者，承認者，タイトルが使用されていて、それらが入力されているかをチェックする
     * <br>[解  説]
     * <br>[備  考]
     * @param reqMdl リクエスト情報
     * @param msgRes メッセージリソース
     * @return 入力チェックエラー
     * @throws IOToolsException
     * @throws JsonProcessingException
     */
    public List<String> validateCheck(RequestModel reqMdl, MessageResources msgRes)
        throws IOToolsException, JsonProcessingException {

        List<String> ret = new ArrayList<>();
        if (rng330ApplicantUser__ > -1
            && rng330ApproverGroup__ > -1
            && !StringUtil.isNullZeroString(rng330rngTitle__)) {
            //申請者，承認者，タイトルが全て入力されている場合は使用されているかを確認しない
            return ret;
        }

        GsMessage gsMsg = new GsMessage(reqMdl);
        if (!StringUtil.isNullZeroString(rng330ApprovalDate__)
            && !ValidateUtil.isSlashDateFormat(rng330ApprovalDate__)) {
            ret.add(msgRes.getMessage(
                "error.input.comp.text",
                gsMsg.getMessage("rng.rng330.3") + " " + gsMsg.getMessage("cmn.date2"),
                gsMsg.getMessage("cmn.format.date2")));
        }
        if (!StringUtil.isNullZeroString(rng330ApprovalTime__)
            && !ValidateUtil.isTimeFormat(rng330ApprovalTime__)) {
            ret.add(msgRes.getMessage(
                "error.input.comp.text",
                gsMsg.getMessage("rng.rng330.3") + " " + gsMsg.getMessage("cmn.time"),
                gsMsg.getMessage("cmn.format.time.colon") + gsMsg.getMessage("cmn.format")));
        }
        if (!StringUtil.isNullZeroString(rng330ApplicationDate__)
            && !ValidateUtil.isSlashDateFormat(rng330ApplicationDate__)) {
            ret.add(msgRes.getMessage(
                "error.input.comp.text",
                gsMsg.getMessage("rng.application.date") + " " + gsMsg.getMessage("cmn.date2"),
                gsMsg.getMessage("cmn.format.date2")));
        }
        if (!StringUtil.isNullZeroString(rng330ApplicationTime__)
            && !ValidateUtil.isTimeFormat(rng330ApplicationTime__)) {
            ret.add(msgRes.getMessage(
                "error.input.comp.text",
                gsMsg.getMessage("rng.application.date") + " " + gsMsg.getMessage("cmn.time"),
                gsMsg.getMessage("cmn.format.time.colon") + gsMsg.getMessage("cmn.format")));
        }

        Rng330Biz biz = new Rng330Biz(reqMdl);
        Map<String, Boolean> useMap = biz.getUseFlg(rng330RenkeiApi__);

        if (useMap.getOrDefault("title", false)
            && StringUtil.isNullZeroString(getRng020Title())) {
            ret.add(gsMsg.getMessage("rng.rng330.17"));
        }
        if (useMap.getOrDefault("syouninUsr", false)
            && rng330ApproverUser__ < 0) {
            ret.add(gsMsg.getMessage("rng.rng330.16"));
        }
        if (useMap.getOrDefault("sinseiUsr", false)
            && rng330ApplicantUser__ < 0) {
            ret.add(gsMsg.getMessage("rng.rng330.15"));
        }

        return ret;
    }

    /**
     * @return the rng330ApproverGroupCombo
     */
    public List<LabelValueBean> getRng330ApproverGroupCombo() {
        return rng330ApproverGroupCombo__;
    }

    /**
     * @param rng330ApproverGroupCombo the rng330ApproverGroupCombo to set
     */
    public void setRng330ApproverGroupCombo(
            List<LabelValueBean> rng330ApproverGroupCombo) {
        rng330ApproverGroupCombo__ = rng330ApproverGroupCombo;
    }

    /**
     * @return the rng330ApproverGroup
     */
    public int getRng330ApproverGroup() {
        return rng330ApproverGroup__;
    }

    /**
     * @param rng330ApproverGroup the rng330ApproverGroup to set
     */
    public void setRng330ApproverGroup(int rng330ApproverGroup) {
        rng330ApproverGroup__ = rng330ApproverGroup;
    }

    /**
     * @return the rng330ApproverUserCombo
     */
    public List<LabelValueBean> getRng330ApproverUserCombo() {
        return rng330ApproverUserCombo__;
    }

    /**
     * @param rng330ApproverUserCombo the rng330ApproverUserCombo to set
     */
    public void setRng330ApproverUserCombo(
            List<LabelValueBean> rng330ApproverUserCombo) {
        rng330ApproverUserCombo__ = rng330ApproverUserCombo;
    }

    /**
     * @return the rng330ApproverUser
     */
    public int getRng330ApproverUser() {
        return rng330ApproverUser__;
    }

    /**
     * @param rng330ApproverUser the rng330ApproverUser to set
     */
    public void setRng330ApproverUser(int rng330ApproverUser) {
        rng330ApproverUser__ = rng330ApproverUser;
    }

    /**
     * @return the rng330ApprovalDate
     */
    public String getRng330ApprovalDate() {
        return rng330ApprovalDate__;
    }

    /**
     * @param rng330ApprovalDate the rng330ApprovalDate to set
     */
    public void setRng330ApprovalDate(String rng330ApprovalDate) {
        rng330ApprovalDate__ = rng330ApprovalDate;
    }

    /**
     * @return the rng330ApprovalTime
     */
    public String getRng330ApprovalTime() {
        return rng330ApprovalTime__;
    }

    /**
     * @param rng330ApprovalTime the rng330ApprovalTime to set
     */
    public void setRng330ApprovalTime(String rng330ApprovalTime) {
        rng330ApprovalTime__ = rng330ApprovalTime;
    }

    /**
     * @return the rng330ApplicantGroupCombo
     */
    public List<LabelValueBean> getRng330ApplicantGroupCombo() {
        return rng330ApplicantGroupCombo__;
    }

    /**
     * @param rng330ApplicantGroupCombo the rng330ApplicantGroupCombo to set
     */
    public void setRng330ApplicantGroupCombo(
            List<LabelValueBean> rng330ApplicantGroupCombo) {
        rng330ApplicantGroupCombo__ = rng330ApplicantGroupCombo;
    }

    /**
     * @return the rng330ApplicantGroup
     */
    public int getRng330ApplicantGroup() {
        return rng330ApplicantGroup__;
    }

    /**
     * @param rng330ApplicantGroup the rng330ApplicantGroup to set
     */
    public void setRng330ApplicantGroup(int rng330ApplicantGroup) {
        rng330ApplicantGroup__ = rng330ApplicantGroup;
    }

    /**
     * @return the rng330ApplicantUserCombo
     */
    public List<LabelValueBean> getRng330ApplicantUserCombo() {
        return rng330ApplicantUserCombo__;
    }

    /**
     * @param rng330ApplicantUserCombo the rng330ApplicantUserCombo to set
     */
    public void setRng330ApplicantUserCombo(
            List<LabelValueBean> rng330ApplicantUserCombo) {
        rng330ApplicantUserCombo__ = rng330ApplicantUserCombo;
    }

    /**
     * @return the rng330ApplicantUser
     */
    public int getRng330ApplicantUser() {
        return rng330ApplicantUser__;
    }

    /**
     * @param rng330ApplicantUser the rng330ApplicantUser to set
     */
    public void setRng330ApplicantUser(int rng330ApplicantUser) {
        rng330ApplicantUser__ = rng330ApplicantUser;
    }

    /**
     * @return the rng330RenkeiApiCombo
     */
    public List<LabelValueBean> getRng330RenkeiApiCombo() {
        return rng330RenkeiApiCombo__;
    }

    /**
     * @param rng330RenkeiApiCombo the rng330RenkeiApiCombo to set
     */
    public void setRng330RenkeiApiCombo(List<LabelValueBean> rng330RenkeiApiCombo) {
        rng330RenkeiApiCombo__ = rng330RenkeiApiCombo;
    }

    /**
     * @return the rng330ApplicationDate
     */
    public String getRng330ApplicationDate() {
        return rng330ApplicationDate__;
    }

    /**
     * @param rng330ApplicationDate the rng330ApplicationDate to set
     */
    public void setRng330ApplicationDate(String rng330ApplicationDate) {
        rng330ApplicationDate__ = rng330ApplicationDate;
    }

    /**
     * @return the rng330ApplicationTime
     */
    public String getRng330ApplicationTime() {
        return rng330ApplicationTime__;
    }

    /**
     * @param rng330ApplicationTime the rng330ApplicationTime to set
     */
    public void setRng330ApplicationTime(String rng330ApplicationTime) {
        rng330ApplicationTime__ = rng330ApplicationTime;
    }

    /**
     * @return the rng330RenkeiApi
     */
    public int getRng330RenkeiApi() {
        return rng330RenkeiApi__;
    }

    /**
     * @param rng330RenkeiApi the rng330RenkeiApi to set
     */
    public void setRng330RenkeiApi(int rng330RenkeiApi) {
        rng330RenkeiApi__ = rng330RenkeiApi;
    }

    /**
     * @return the rng330templateJSON
     */
    public String getRng330templateJSON() {
        return rng330templateJSON__;
    }

    /**
     * @param rng330templateJSON the rng330templateJSON to set
     */
    public void setRng330templateJSON(String rng330templateJSON) {
        rng330templateJSON__ = rng330templateJSON;
    }

    /**
     * @return the rng330TestUrl
     */
    public String getRng330TestUrl() {
        return rng330TestUrl__;
    }

    /**
     * @param rng330TestUrl the rng330TestUrl to set
     */
    public void setRng330TestUrl(String rng330TestUrl) {
        rng330TestUrl__ = rng330TestUrl;
    }

    /**
     * @return the rng330TestMethodKbn
     */
    public int getRng330TestMethodKbn() {
        return rng330TestMethodKbn__;
    }

    /**
     * @param rng330TestMethodKbn the rng330TestMethodKbn to set
     */
    public void setRng330TestMethodKbn(int rng330TestMethodKbn) {
        rng330TestMethodKbn__ = rng330TestMethodKbn;
    }

    /**
     * @return the rng330TestContentType
     */
    public String getRng330TestContentType() {
        return rng330TestContentType__;
    }

    /**
     * @param rng330TestContentType the rng330TestContentType to set
     */
    public void setRng330TestContentType(String rng330TestContentType) {
        rng330TestContentType__ = rng330TestContentType;
    }

    /**
     * @return the rng330TestHeader
     */
    public String[] getRng330TestHeader() {
        return rng330TestHeader__;
    }

    /**
     * @param rng330TestHeader the rng330TestHeader to set
     */
    public void setRng330TestHeader(String[] rng330TestHeader) {
        rng330TestHeader__ = rng330TestHeader;
    }

    /**
     * @return the rng330TestBody
     */
    public String getRng330TestBody() {
        return rng330TestBody__;
    }

    /**
     * @param rng330TestBody the rng330TestBody to set
     */
    public void setRng330TestBody(String rng330TestBody) {
        rng330TestBody__ = rng330TestBody;
    }

    /**
     * @return the rng330testMap
     */
    public Map<Integer, Rng330TestModel> getRng330testMap() {
        return rng330testMap__;
    }
    /**
     * @param rng330testMap the rng330testMap to set
     */
    public void setRng330testMap(Map<Integer, Rng330TestModel> rng330testMap) {
        rng330testMap__ = rng330testMap;
    }

    /**
     * <br>[機  能] 指定されたインデックスのマルチパート情報を返す
     * <br>[解  説]
     * <br>[備  考]
     * @param index
     * @return 指定されたインデックスのマルチパート情報
     */
    public Rng330TestModel getRng330Test(int index) {
        if (!rng330testMap__.containsKey(index)) {
            rng330testMap__.put(index, new Rng330TestModel());
        }
        return rng330testMap__.get(index);
    }

    /**
     * @return the rng330testRepeatKbn
     */
    public int getRng330testRepeatKbn() {
        return rng330testRepeatKbn__;
    }
    /**
     * @param rng330testRepeatKbn the rng330testRepeatKbn to set
     */
    public void setRng330testRepeatKbn(int rng330testRepeatKbn) {
        rng330testRepeatKbn__ = rng330testRepeatKbn;
    }

    /**
     * @return the rng330testTarget
     */
    public int getRng330testTarget() {
        return rng330testTarget__;
    }
    /**
     * @param rng330testTarget the rng330testTarget to set
     */
    public void setRng330testTarget(int rng330testTarget) {
        this.rng330testTarget__ = rng330testTarget;
    }

    /**
     * @return the rng330testRepeatName
     */
    public String getRng330testRepeatName() {
        return rng330testRepeatName__;
    }
    /**
     * @param rng330testRepeatName the rng330testRepeatName to set
     */
    public void setRng330testRepeatName(String rng330testRepeatName) {
        rng330testRepeatName__ = rng330testRepeatName;
    }

    /**
     * @return the rng330partMap
     */
    public Map<Integer, Rng330PartModel> getRng330partMap() {
        return rng330partMap__;
    }
    /**
     * @param rng330partMap the rng330partMap to set
     */
    public void setRng330partMap(Map<Integer, Rng330PartModel> rng330partMap) {
        rng330partMap__ = rng330partMap;
    }
    /**
     * <br>[機  能] 指定されたインデックスのマルチパート情報を返す
     * <br>[解  説]
     * <br>[備  考]
     * @param index
     * @return 指定されたインデックスのマルチパート情報
     */
    public Rng330PartModel getRng330Part(int index) {
        if (!rng330partMap__.containsKey(index)) {
            rng330partMap__.put(index, new Rng330PartModel());
        }
        return rng330partMap__.get(index);
    }

    /**
     * @return the rng330RequestDspFlg
     */
    public int getRng330RequestDspFlg() {
        return rng330RequestDspFlg__;
    }
    /**
     * @param rng330RequestDspFlg the rng330RequestDspFlg to set
     */
    public void setRng330RequestDspFlg(int rng330RequestDspFlg) {
        this.rng330RequestDspFlg__ = rng330RequestDspFlg;
    }
    /**
     * @return the rng330TestResult
     */
    public String getRng330TestResult() {
        return rng330TestResult__;
    }
    /**
     * @param rng330TestResult the rng330TestResult to set
     */
    public void setRng330TestResult(String rng330TestResult) {
        rng330TestResult__ = rng330TestResult;
    }
}
