package jp.groupsession.v2.sml.sml290;

import java.util.List;

import jp.co.sjts.util.StringUtil;
import jp.co.sjts.util.ValidateUtil;
import jp.groupsession.v2.sml.model.LabelDataModel;

/**
 * <br>[機  能] Sml290画面に必要なデータを作成したリ、必要な形にデータを整形，変換するクラス
 * <br>[解  説]
 * <br>[備  考]
 *
 * @author  JTS
 */
public class Sml290DataOperator {

    /**
     * <br>[機  能] ラベル一覧に画面表示用の表示順をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param lbList ラベル一覧
     */
    public void setLbValue(List<LabelDataModel> lbList) {
        for (LabelDataModel sldSetMdl : lbList) {
            sldSetMdl.setLbValue(String.valueOf(sldSetMdl.getLabelSid()));
        }
    }

    /**
     * <br>[機  能] 並び順が設定されていない場合に、並び順をセットする
     * <br>[解  説]
     * <br>[備  考]
     * @param paramMdl パラメータ情報
     * @param lbList ラベル一覧
     */
    public void setSortRadio(Sml290ParamModel paramMdl, List<LabelDataModel> lbList) {
        if (StringUtil.isNullZeroString(paramMdl.getSml290SortRadio()) && lbList.size() > 0) {
            LabelDataModel sldMdl = lbList.get(0);
            paramMdl.setSml290SortRadio(String.valueOf(sldMdl.getLabelSid()));
        }
    }

    /**
     * <br>[機  能] ソート順変更が可能かを判定する
     * <br>[解  説]
     * <br>[備  考]
     * @param keyList キー情報
     * @param selectSid 並び替え対象のラベルSID
     * @return true:変更可能 false:変更不可
     */
    public boolean canUpdateSort(String[] keyList, String selectSid) {
        //画面表示全キーリスト取得
        if (keyList == null || keyList.length < 1) {
            return false;
        }

        //ラジオ選択値取得
        if (StringUtil.isNullZeroString(selectSid) || !ValidateUtil.isNumber(selectSid)) {
            return false;
        }
        int motoSid = Integer.parseInt(selectSid);
        if (motoSid <= 0) {
            return false;
        }

        return true;
    }

}
