package jp.groupsession.v2.wml.dao.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.co.sjts.util.dao.AbstractDao;
import jp.co.sjts.util.jdbc.JDBCUtil;
import jp.co.sjts.util.jdbc.SqlBuffer;
import jp.groupsession.v2.wml.model.base.WmlFilterLabelModel;

/**
 * <p>WML_FILTER_LABEL Data Access Object
 *
 * @author JTS DaoGenerator version 0.5
 */
public class WmlFilterLabelDao extends AbstractDao {

    /** Logging インスタンス */
    private static Log log__ = LogFactory.getLog(WmlFilterLabelDao.class);

    /**
     * <p>Default Constructor
     */
    public WmlFilterLabelDao() {
    }

    /**
     * <p>Set Connection
     * @param con Connection
     */
    public WmlFilterLabelDao(Connection con) {
        super(con);
    }

    /**
     * <p>Drop Table
     * @throws SQLException SQL実行例外
     */
    public void dropTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql("drop table WML_FILTER_LABEL");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Create Table
     * @throws SQLException SQL実行例外
     */
    public void createTable() throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" create table WML_FILTER_LABEL (");
            sql.addSql("   WFT_SID integer not null,");
            sql.addSql("   WLB_SID integer not null,");
            sql.addSql("   primary key (WFT_SID,WLB_SID)");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Insert WML_FILTER_LABEL Data Bindding JavaBean
     * @param bean WML_FILTER_LABEL Data Bindding JavaBean
     * @throws SQLException SQL実行例外
     */
    public void insert(WmlFilterLabelModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" insert ");
            sql.addSql(" into ");
            sql.addSql(" WML_FILTER_LABEL(");
            sql.addSql("   WFT_SID,");
            sql.addSql("   WLB_SID");
            sql.addSql(" )");
            sql.addSql(" values");
            sql.addSql(" (");
            sql.addSql("   ?,");
            sql.addSql("   ?");
            sql.addSql(" )");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(bean.getWftSid());
            sql.addIntValue(bean.getWlbSid());
            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
    }

    /**
     * <p>Update WML_FILTER_LABEL Data Bindding JavaBean
     * @param bean WML_FILTER_LABEL Data Bindding JavaBean
     * @return 更新件数
     * @throws SQLException SQL実行例外
     */
    public int update(WmlFilterLabelModel bean) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" update");
            sql.addSql("   WML_FILTER_LABEL");
            sql.addSql(" set ");
            sql.addSql(" where ");
            sql.addSql("   WFT_SID=?");
            sql.addSql(" and");
            sql.addSql("   WLB_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            //where
            sql.addIntValue(bean.getWftSid());
            sql.addIntValue(bean.getWlbSid());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <br>[機  能] select用のSQLを取得する
     * <br>[解  説]
     * <br>[備  考]
     * @return select用のSQL
     */
    private SqlBuffer __getSelectSql() {
        SqlBuffer sql = new SqlBuffer();
        sql.addSql(" select ");
        sql.addSql("   WFT_SID,");
        sql.addSql("   WLB_SID");

        return sql;
    }

    /**
     * <p>Select WML_FILTER_LABEL All Data
     * @return List in WML_FILTER_LABELModel
     * @throws SQLException SQL実行例外
     */
    public List<WmlFilterLabelModel> select() throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        ArrayList<WmlFilterLabelModel> ret = new ArrayList<>();
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from ");
            sql.addSql("   WML_FILTER_LABEL");

            pstmt = con.prepareStatement(sql.toSqlString());
            log__.info(sql.toLogString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getWmlFilterLabelFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Select WML_FILTER_LABEL
     * @param wftSid WFT_SID
     * @param wlbSid WLB_SID
     * @return WML_FILTER_LABELModel
     * @throws SQLException SQL実行例外
     */
    public WmlFilterLabelModel select(int wftSid, int wlbSid) throws SQLException {

        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        WmlFilterLabelModel ret = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from");
            sql.addSql("   WML_FILTER_LABEL");
            sql.addSql(" where ");
            sql.addSql("   WFT_SID=?");
            sql.addSql(" and");
            sql.addSql("   WLB_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(wftSid);
            sql.addIntValue(wlbSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                ret = __getWmlFilterLabelFromRs(rs);
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] フィルターSIDを指定して、それに紐づくラベルSID一覧を取得する
     * <br>[解  説]
     * <br>[備  考]
     * @param filterSid フィルターSID
     * @return フィルターSIDに紐づくラベルSID一覧
     * @throws SQLException
     */
    public List<WmlFilterLabelModel> selectLabelSid(List<Integer> filterSid) throws SQLException {

        List<WmlFilterLabelModel> ret = new ArrayList<>();
        if (filterSid == null || filterSid.isEmpty()) {
            return ret;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = __getSelectSql();
            sql.addSql(" from");
            sql.addSql("   WML_FILTER_LABEL");
            sql.addSql(" where ");
            sql.addSql("   WFT_SID in (");
            for (int idx = 0; idx < filterSid.size(); idx++) {
                if (idx != 0) {
                    sql.addSql(", ");
                }
                sql.addSql("?");
                sql.addIntValue(filterSid.get(idx));
            }
            sql.addSql("   )");

            pstmt = con.prepareStatement(sql.toSqlString());

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ret.add(__getWmlFilterLabelFromRs(rs));
            }
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeResultSet(rs);
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] フィルターSIDを指定して、それに紐づくデータをすべて削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param filterSid フィルターSID
     * @return 削除件数
     * @throws SQLException
     */
    public int deleteFilterLabel(int filterSid) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        int ret = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete from");
            sql.addSql("   WML_FILTER_LABEL");
            sql.addSql(" where ");
            sql.addSql("   WFT_SID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(filterSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            ret = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <br>[機  能] ラベルSIDを指定して、それに紐づくデータをすべて削除する
     * <br>[解  説]
     * <br>[備  考]
     * @param labelSid ラベルSID
     * @return 削除件数
     * @throws SQLException
     */
    public int deleteFromLabelSid(int labelSid) throws SQLException {
        PreparedStatement pstmt = null;
        Connection con = null;
        int ret = 0;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete from");
            sql.addSql("   WML_FILTER_LABEL");
            sql.addSql(" where ");
            sql.addSql("   WLB_SID=?");
            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(labelSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            ret = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return ret;
    }

    /**
     * <p>Delete WML_FILTER_LABEL
     * @param wftSid WFT_SID
     * @param wlbSid WLB_SID
     * @return 削除件数
     * @throws SQLException SQL実行例外
     */
    public int delete(int wftSid, int wlbSid) throws SQLException {

        PreparedStatement pstmt = null;
        int count = 0;
        Connection con = null;
        con = getCon();

        try {
            //SQL文
            SqlBuffer sql = new SqlBuffer();
            sql.addSql(" delete");
            sql.addSql(" from");
            sql.addSql("   WML_FILTER_LABEL");
            sql.addSql(" where ");
            sql.addSql("   WFT_SID=?");
            sql.addSql(" and");
            sql.addSql("   WLB_SID=?");

            pstmt = con.prepareStatement(sql.toSqlString());
            sql.addIntValue(wftSid);
            sql.addIntValue(wlbSid);

            log__.info(sql.toLogString());
            sql.setParameter(pstmt);
            count = pstmt.executeUpdate();
        } catch (SQLException e) {
            throw e;
        } finally {
            JDBCUtil.closeStatement(pstmt);
        }
        return count;
    }

    /**
     * <p>Create WML_FILTER_LABEL Data Bindding JavaBean From ResultSet
     * @param rs ResultSet
     * @return created WmlFilterLabelModel
     * @throws SQLException SQL実行例外
     */
    private WmlFilterLabelModel __getWmlFilterLabelFromRs(ResultSet rs) throws SQLException {
        WmlFilterLabelModel bean = new WmlFilterLabelModel();
        bean.setWftSid(rs.getInt("WFT_SID"));
        bean.setWlbSid(rs.getInt("WLB_SID"));
        return bean;
    }
}
